package com.digiwin.mobile.mobileuibot.proxy.cam.service.impl;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.cam.model.*;
import com.digiwin.mobile.mobileuibot.proxy.cam.service.DigIwinCamProxyService;
import com.fasterxml.jackson.core.type.TypeReference;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestClientException;

import java.util.List;
import java.util.Map;

/**
 * @author yanfeng
 * @date 2023/9/20
 */
@Slf4j
@Service("digIwinCamProxyServiceImpl")
public class DigIwinCamProxyServiceImpl implements DigIwinCamProxyService {

    @Autowired
    private HttpService httpService;

    @Override
    public DigiwinCamDingDingResult dingDingSsoLogin(DigiwinCamDingDingQuery query) {
        String url = AppContext.getApiUrlSetting().getCamUrl() + DigIwinCamProxyService.API_PREFIX
                + "/dingtalk2digiwin/sso/login";

        try {
            ParameterizedTypeReference<DigIwinCamResponse<DigiwinCamDingDingResult>> responseType =
                    new ParameterizedTypeReference<DigIwinCamResponse<DigiwinCamDingDingResult>>() {
                    };
            ResponseEntity<DigIwinCamResponse<DigiwinCamDingDingResult>> response = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(), JsonUtil.javaObjectToJsonString(query)
                    , responseType);
            if (response.getStatusCode().is2xxSuccessful()) {
                if (ObjectUtils.isNotEmpty(response.getBody())) {
                    return response.getBody().getData();
                }
            } else {
                return new DigiwinCamDingDingResult();
            }
        } catch (Exception e) {
            throw new ServiceException(e.getMessage());
        }
        return null;
    }

    @Override
    public List<DigiwinCamDingDingMapperResult.MapperData> getGoodsMappings(String appId) {
        String url = AppContext.getApiUrlSetting().getCamUrl() + DigIwinCamProxyService.API_PREFIX
                + "/app/mappings?code=" + appId;
        try {
            ParameterizedTypeReference<DigIwinCamResponse> responseType =
                    new ParameterizedTypeReference<DigIwinCamResponse>() {
                    };
            ResponseEntity<DigIwinCamResponse> responseEntity = this.httpService.doGet(url, new AthenaBasicHttpRequestHead(), responseType);
            if (responseEntity.getStatusCode().is2xxSuccessful()) {
                if (ObjectUtils.isNotEmpty(responseEntity.getBody())) {
                    List<DigiwinCamDingDingMapperResult> resultList = JsonUtil.objectToJavaObject(responseEntity.getBody().getData(), new TypeReference<List<DigiwinCamDingDingMapperResult>>() {
                    });
                    if (!CollectionUtils.isEmpty(resultList)) {
                        for (DigiwinCamDingDingMapperResult result : resultList) {
                            if (DigiwinCamDingDingMapperEnum.DING_DING.getValue().equals(result.getPlatform())) {
                                return result.getDatas();
                            }
                        }
                    }
                }
            }
        } catch (RestClientException e) {
            log.error("getGoodsMappings异常:{}", e.getMessage());
        }
        return null;
    }

    @Override
    public DigIwinCamResponse getLineCamInfo(Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getCamUrl() + DigIwinCamProxyService.API_PREFIX
                + "/line/sso/login/without/register";
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigIwinCamResponse> responseType =
                new ParameterizedTypeReference<DigIwinCamResponse>() {
                };
        ResponseEntity<DigIwinCamResponse> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(),
                JsonUtil.javaObjectToJsonString(params), responseType);
        if (responseEntity.getStatusCode().is2xxSuccessful()) {
            return responseEntity.getBody();
        } else {
            return null;
        }
    }
}
