package com.digiwin.mobile.mobileuibot.proxy.dap;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Map;

/**
 * <p>功能描述：DAP平台后端接口响应的标准格式</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DapResponse
 * @Author: Zaregoto
 * @Date: 2021/11/22 3:04
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class DapResponse implements Serializable {
    private static final long serialVersionUID = -3658696416382198477L;

    private Long duration;
    private String statusDescription;
    private String errorType;
    private Map<String, Object> response;
    private Map<String, Object> profile;
    private String errorMessage;
    private String errorCode;
    private Map<String, Object> debugInfo;
    private Map<String, Object> errorInstructors;
    private String uuid;
    private Integer status;

}