package com.digiwin.mobile.mobileuibot.proxy.digiwhale.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.EocPerson;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 调取移动平台老接口的/oauth/oauth/token接口，进行登入校验
 *
 * @author wuyang
 * @date 20220120
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class DigiwhaleLoginResponse extends DigiwinIamUserInfo implements Serializable {

    private static final long serialVersionUID = 8406886180849692083L;

    @JsonProperty(value = "access_token")
    @JSONField(name = "access_token")
    private String accessToken;
    private String token_type;

    @JsonProperty(value = "refresh_token")
    @JSONField(name = "refresh_token")
    private String refreshToken;

    @JsonProperty(value = "expires_in")
    @JSONField(name = "expires_in")
    private Integer expiresIn;

    private String openID;
    private String iamCode;
    private String customID;
    private IamAuth iamAuth;
    private String error;

    @JsonProperty(value = "error_description")
    @JSONField(name = "error_description")
    private String errorDescription;

    private Boolean shared;
    private List metadata;
    private Integer enterpriseTenantType;
    private Boolean isEnterpriseTenant;
    private String comefrom;
    private String jobCode;
    private Long sid;
    private Boolean agreeAgreement;
    private Boolean isEoc;
    private Long tenantSid;
    private String tenantName;
    private Boolean isConfirm;
    private String identityType;
    private Boolean isOwner;
    private String appId;
    private String email;
    private String deviceType;
    private List mapping;
    private String address;
    private Boolean kicked;
    private String telephone;
    private String dept;
    private Boolean isActivated;
    private String userName;
    private String userId;
    private Boolean isDealer;
    private String token;
    private Boolean logined;
    private Long tokenExpiresIn;
    private Boolean corpWechat;
    private String tenantId;
    private Boolean isEnterprise;
    private Integer userType;
    private String tokenType;
    private String hash;
    private Boolean changed;
    private String message;
    private String errorMessage;
    private String errorCode;
    private PasswordChange passwordChange;

    /**
     * 二次验证，验证码接受方式 mobile/email
     */
    private String identityCodeAcceptType;
    /**
     * 如果为true，则需要二次验证
     */
    private Boolean needVerificationCode;

    /**
     * 如果为true，则需要确认是否要解绑
     */
    private Boolean needConfirmUnbind;

    /**
     * 录制id
     */
    private String mockId;

    /**
     * 代理授权码
     */
    private String agentAuthorizationCode;
    /**
     * 被代理用户清单
     */
    private List<AgentUser> agentUserList;

    /**
     * EOC 人员详细信息
     */
    private EocPerson eoc;
}
