package com.digiwin.mobile.mobileuibot.proxy.digiwhale.model;

import lombok.AllArgsConstructor;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 移动平台的person信息
 *
 * @author wuyang
 * @date 20230404
 */
@NoArgsConstructor
@AllArgsConstructor
public class MPersonCard implements Serializable {


    /**
     * Change log: v1.0 首次创建
     */
    private static final long serialVersionUID = -4158936011935641572L;

    /**
     * 名片ID
     */
    private String cardID;

    /**
     * 用户ID
     */
    private String pID;
    /**
     * 用户姓名
     */
    private String pName;
    /**
     * 用户头像的附件ID
     */
    private String logo;
    /**
     * 社区ID
     */
    private String cID;
    /**
     * 社区名称
     */
    private String cName;
    /**
     * 公司名称
     */
    private String company;
    /**
     * 部门
     */
    private String dep;
    /**
     * 职位
     */
    private String pos;
    /**
     * 办公地址
     */
    private String addr;
    /**
     * 邮件地址
     */
    private String email;
    /**
     * 办公电话
     */
    private String phone;
    /**
     * 移动电话
     */
    private String mobile;
    /**
     * 公司网址
     */
    private String web;
    /**
     * 名片是否被认证，value：0 未认证 1 认证
     */
    private Integer auth;
    /**
     * 个人简介
     */
    private String desc;
    /**
     * 是否关注当前登录用户
     */
    private Integer followMe;
    /**
     * 是否被当前用户关注
     */
    private Integer followed;

    public String getCardID() {
        return cardID;
    }

    public void setCardID(String cardID) {
        this.cardID = cardID;
    }

    public String getpID() {
        return pID;
    }

    public void setpID(String pID) {
        this.pID = pID;
    }

    public String getpName() {
        return pName;
    }

    public void setpName(String pName) {
        this.pName = pName;
    }

    public String getLogo() {
        return logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getcID() {
        return cID;
    }

    public void setcID(String cID) {
        this.cID = cID;
    }

    public String getcName() {
        return cName;
    }

    public void setcName(String cName) {
        this.cName = cName;
    }

    public String getCompany() {
        return company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getDep() {
        return dep;
    }

    public void setDep(String dep) {
        this.dep = dep;
    }

    public String getPos() {
        return pos;
    }

    public void setPos(String pos) {
        this.pos = pos;
    }

    public String getAddr() {
        return addr;
    }

    public void setAddr(String addr) {
        this.addr = addr;
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getMobile() {
        return mobile;
    }

    public void setMobile(String mobile) {
        this.mobile = mobile;
    }

    public String getWeb() {
        return web;
    }

    public void setWeb(String web) {
        this.web = web;
    }

    public Integer getAuth() {
        return auth;
    }

    public void setAuth(Integer auth) {
        this.auth = auth;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getFollowMe() {
        return followMe;
    }

    public void setFollowMe(Integer followMe) {
        this.followMe = followMe;
    }

    public Integer getFollowed() {
        return followed;
    }

    public void setFollowed(Integer followed) {
        this.followed = followed;
    }
}
