package com.digiwin.mobile.mobileuibot.proxy.digiwhale.model;

import com.fasterxml.jackson.databind.ObjectMapper;
import lombok.Data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

/**
 * http请求返回内容体
 *
 * @author wuyang
 * @date 202330404
 */
@Data
public class MReturnValidate implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = -3136280522883568192L;
    /**
     * 成功标记
     */
    private Integer errorCode = -1;
    /**
     * 返回内容
     */
    private ValidateResult content;

    private static ObjectMapper objectMapper;

    public String toString() {
        if (objectMapper == null) {
            objectMapper = new ObjectMapper();
        }
        try {
            if (content == null) {
                return objectMapper.writeValueAsString(this);
            } else {
                Map<String, Object> p = new HashMap<String, Object>();
                p.put("errorCode", this.errorCode);
                Map<String, String> p2 = new HashMap<String, String>();
                p.put("content", p2);
                if (content.getLatestVersion() != null)
                    p2.put("latestVersion", content.getLatestVersion());
                if (content.getUpdateStrategy() != null)
                    p2.put("updateStrategy", content.getUpdateStrategy());
                if (content.getDownloadUrl() != null)
                    p2.put("downloadUrl", content.getDownloadUrl());
                if(content.getMD5() != null){
                    p2.put("md5", content.getMD5());
                }else{
                    p2.put("md5","");
                }
                if (content.getMessage() != null)
                    p2.put("message", content.getMessage());
                if (content.getUsertoken() != null)
                    p2.put("dmcUserToken", content.getUsertoken());
                ServerNotice notice = content.getNotice();
                if (notice != null) {
                    if (notice.getNoticeTitle() != null)
                        p2.put("noticeTitle", notice.getNoticeTitle());
                    if (notice.getNoticeContent() != null)
                        p2.put("noticeContent", notice.getNoticeContent());
                    if (notice.getNoticeStartTime() != null)
                        p2.put("noticeStartTime", notice.getNoticeStartTime());
                    if (notice.getNoticeEndTime() != null)
                        p2.put("noticeEndTime", notice.getNoticeEndTime());
                }
                return objectMapper.writeValueAsString(p);
            }
        } catch (Exception e) {
            e.printStackTrace();
            return "{\"success\":-1,\"content\":null}";
        }
    }
}
