package com.digiwin.mobile.mobileuibot.proxy.digiwhale.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
public class PasswordChange implements Serializable {
    private static final long serialVersionUID = -1091114996878202683L;

    /**
     * 是否需要修改密碼
     */
    private Boolean changeRequired;
    /**
     * PwChangeTypeEnum "default":需變更預設密碼 "overdue":逾期
     */
    private String pwChangeType;
    /**
     * 批次匯入會員需變更預設密碼："您的使⽤的是初始密碼" 定期通知⽤⼾變更密碼："您的密碼已逾 {變更周期} 未變更"
     */
    private String pwChangeNotification;
    private String title;
    /**
     * 内容
     */
    private String content;
    /**
     * 取消按钮信息
     */
    private String cancelMsg;
    /**
     * 确认按钮信息
     */
    private String ensureMsg;

    public PasswordChange(Boolean changeRequired) {
        this.changeRequired = changeRequired;
    }
}
