package com.digiwin.mobile.mobileuibot.proxy.digiwhale.model;


import lombok.Data;

/**
 * APP更新的实体类
 *
 * @author wuyang
 * @date 20230404
 */
@Data
public class ValidateResult {

    private String fTypeName;
    private int fVersion;

    /**
     * 客户端最新版本号
     */
    private String latestVersion;

    /**
     * 客户端更新策略 value: 0.无需更新 1.推荐更新 2.强制更新
     */
    private String updateStrategy;

    /**
     * 客户端下载地址
     */
    private String downloadUrl;

    /**
     * 更新提示消息
     */
    private String message;

    /**
     * 文檔中心下載token
     */
    private String usertoken;

    /**
     * 升级维护提示语
     */
    private ServerNotice notice;

    /**
     * 用app下载校验
     */
    private String MD5;

    public ValidateResult() {
        this.fTypeName = getClass().getName();
        this.fVersion = 1;
    }

}
