package com.digiwin.mobile.mobileuibot.proxy.digiwhale.service;

import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.DigiwhaleLoginResponse;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.MPersonCard;
import org.springframework.http.ResponseEntity;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 * <p>功能描述：移动后台系统代理服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwhaleProxyServie
 * @Author: Zaregoto
 * @Date: 2022/01/19 16:02
 */
public interface DigiwhaleProxyServie {

    /**
     * 移动平台mobile_update的app版本校验
     *
     * @param queryString
     * @return
     */
    String upgradeUpdate(String queryString);

    /**
     * 获取人员基本信息
     *
     * @param queryString
     * @return
     */
    MPersonCard getPersonByUserId(String queryString);

    /**
     * 老平台极光发送消息
     *
     * @param map
     */
    void pushDigiwinMessage(String token, Map<String, Object> map);
}
