package com.digiwin.mobile.mobileuibot.proxy.digiwhale.service.impl;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.MPersonCard;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.service.DigiwhaleProxyServie;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service("digiwhaleProxyServie")
public class DigiwhaleProxyServiceImpl implements DigiwhaleProxyServie {

    @Autowired
    private SysEnvConfig sysEnvConfig;

    private static final Logger logger = LoggerFactory.getLogger(DigiwhaleProxyServiceImpl.class);

    @Autowired
    private HttpService httpService;

    @Override
    public String upgradeUpdate(String queryString) {
        try {
            String url = AppContext.getApiUrlSetting().getDigiwhaleUrl() + "/mobile_update/upgrade/update?"
                    + queryString;
            ResponseEntity<String> responseResponseEntity =
                    this.httpService.doGet(url, String.class);
            return responseResponseEntity.getBody();
        } catch (Exception e) {
            return StringUtils.EMPTY;
        }
    }

    @Override
    public MPersonCard getPersonByUserId(String queryString) {
        try {
            String url = AppContext.getApiUrlSetting().getDigiwhaleUrl() + "/mobile/person/getPersonByUserId?"
                    + queryString;
            ResponseEntity<MPersonCard> responseResponseEntity =
                    this.httpService.doGet(url, MPersonCard.class);
            return responseResponseEntity.getBody();
        } catch (Exception e) {
            return null;
        }
    }

    @Override
    public void pushDigiwinMessage(String token, Map<String, Object> map) {
        String url = AppContext.getApiUrlSetting().getDigiwhaleUrl() + "/openapi/invoke/dinghui/notice/send?access_token=" + token;

        ParameterizedTypeReference<Map<String, Object>> responseType =
                new ParameterizedTypeReference<Map<String, Object>>() {
                };
        httpService.doPost(url, new AthenaBasicHttpRequestHead(), JsonUtil.javaObjectToJsonString(map), responseType);
        System.out.println("发送消息成功");
    }

}