package com.digiwin.mobile.mobileuibot.proxy.dmc.config;

import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.DMCBuilder;
import com.digiwin.dap.middleware.dmc.internal.DMCConfigBuilder;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.Lazy;

/**
 * DMC-sdk客户端
 *
 * @author zhangjj
 * @date 2021/6/16 0016 13:37
 */
@Slf4j
@Configuration
@DependsOn("baseConfig")
public class DigiwinDmcConfig {

    // 移动独有的存储
    public static final String MOBILE_USERNAME = "athena-mobile";
    public static final String MOBILE_PASSWORD = "athena-mobile";
    public static final String MOBILE_BUCKET = "athena-mobile";

    public static final String ATHENA_USERNAME = "Athena";
    public static final String ATHENA_PASSWORD = "Athena";
    public static final String ATHENA_BUCKET = "Athena";

    public static final String FRC_USERNAME = "FRC";
    public static final String FRC_PASSWORD = "FRC";
    public static final String FRC_BUCKET = "FRC";

    public static final String SRM_LOADING_USERNAME = "srm-loading";
    public static final String SRM_LOADING_PASSWORD = "srm-loading";
    public static final String SRM_LOADING_BUCKET = "srm-loading";

    public static final String KSC_USERNAME = "KSC";
    public static final String KSC_PASSWORD = "KSC";
    public static final String KSC_BUCKET = "KSC";

    public static final String TBDS_USERNAME = "tbds";
    public static final String TBDS_PASSWORD = "tbds";
    public static final String TBDS_BUCKET = "tbds";

    public static final String CTP_USERNAME = "CTP";
    public static final String CTP_PASSWORD = "CTP";
    public static final String CTP_BUCKET = "CTP";

    public static final String SCH_USERNAME = "SCH";
    public static final String SCH_PASSWORD = "SCH";
    public static final String SCH_BUCKET = "SCH";

    /**
     * 敏捷数据用户名、密码、桶名
     */
    public static final String AGILE_DATA_USERNAME = "asada";
    public static final String AGILE_DATA_PASSWORD = "asadaM8@15f";
    public static final String AGILE_DATA_BUCKET = "asada";

    @Autowired
    private SysEnvConfig sysEnvConfig;

    @Lazy
    @Bean
    public DMC dmcMobileClient() {
        DMC dmcClient = null;
        try {
            String dmcUrl = AppContext.getApiUrlSetting().getDmcUrl();
            if (StringUtils.isEmpty(dmcUrl)) {
                dmcClient = DMCBuilder.create().build(
                        DMCConfigBuilder.create(
                                dmcUrl,
                                MOBILE_USERNAME, MOBILE_PASSWORD, MOBILE_BUCKET
                        ).appToken(sysEnvConfig.getAppToken()).build()
                );
            }

        } catch (Exception e) {
            e.printStackTrace();
            dmcClient = null;
        }
        return dmcClient;
    }

    @Lazy
    @Bean
    public DMC dmcAthenaClient() {
        DMC dmcClient = null;
        try {
            String dmcUrl = AppContext.getApiUrlSetting().getDmcUrl();
            if (StringUtils.isEmpty(dmcUrl)) {
                dmcClient = DMCBuilder.create().build(
                        DMCConfigBuilder.create(
                                dmcUrl,
                                ATHENA_USERNAME, ATHENA_PASSWORD, ATHENA_BUCKET
                        ).appToken(sysEnvConfig.getAppToken()).build()
                );
            }
        } catch (Exception e) {
            e.printStackTrace();
            dmcClient = null;
        }
        return dmcClient;
    }

    @Lazy
    @Bean
    public DMC dmcFrcClient() {
        DMC dmcClient = null;
        String dmcUrl = AppContext.getApiUrlSetting().getDmcUrl();
        try {
            if (StringUtils.isEmpty(dmcUrl)) {
                dmcClient = DMCBuilder.create().build(
                        DMCConfigBuilder.create(dmcUrl
                                ,
                                FRC_USERNAME, FRC_PASSWORD, FRC_BUCKET
                        ).appToken(sysEnvConfig.getAppToken()).build()
                );
            }
        } catch (Exception e) {
            e.printStackTrace();
            if (StringUtils.isEmpty(dmcUrl)) {
                dmcClient = DMCBuilder.create().build(
                        DMCConfigBuilder.create(
                                dmcUrl,
                                ATHENA_USERNAME, ATHENA_PASSWORD, ATHENA_BUCKET
                        ).appToken(sysEnvConfig.getAppToken()).build()
                );
            }
        }
        return dmcClient;
    }

    @Lazy
    @Bean
    public DMC dmcSrmLoadingClient() {
        DMC dmcClient = null;
        String dmcUrl = AppContext.getApiUrlSetting().getDmcUrl();
        try {
            if (StringUtils.isEmpty(dmcUrl)) {
                dmcClient = DMCBuilder.create().build(
                        DMCConfigBuilder.create(
                                dmcUrl,
                                SRM_LOADING_USERNAME, SRM_LOADING_PASSWORD, SRM_LOADING_BUCKET
                        ).appToken(sysEnvConfig.getAppToken()).build()
                );
            }
        } catch (Exception e) {
            e.printStackTrace();
            if (StringUtils.isEmpty(dmcUrl)) {
                dmcClient = DMCBuilder.create().build(
                        DMCConfigBuilder.create(
                                dmcUrl,
                                ATHENA_USERNAME, ATHENA_PASSWORD, ATHENA_BUCKET
                        ).appToken(sysEnvConfig.getAppToken()).build()
                );
            }
        }
        return dmcClient;
    }

    @Lazy
    @Bean
    public DMC dmcKscClient() {
        DMC dmcClient = null;
        String dmcUrl = AppContext.getApiUrlSetting().getDmcUrl();
        try {
            if (StringUtils.isEmpty(dmcUrl)) {
                dmcClient = DMCBuilder.create().build(
                        DMCConfigBuilder.create(
                                dmcUrl,
                                KSC_USERNAME, KSC_PASSWORD, KSC_BUCKET
                        ).appToken(sysEnvConfig.getAppToken()).build()
                );
            }
        } catch (Exception e) {
            e.printStackTrace();
            if (StringUtils.isEmpty(dmcUrl)) {
                dmcClient = DMCBuilder.create().build(
                        DMCConfigBuilder.create(
                                dmcUrl,
                                ATHENA_USERNAME, ATHENA_PASSWORD, ATHENA_BUCKET
                        ).appToken(sysEnvConfig.getAppToken()).build()
                );
            }
        }
        return dmcClient;
    }

    @Lazy
    @Bean
    public DMC dmcTbdsClient() {
        DMC dmcClient = null;
        String dmcUrl = AppContext.getApiUrlSetting().getDmcUrl();
        try {
            if (StringUtils.isEmpty(dmcUrl)) {
                dmcClient = DMCBuilder.create().build(
                        DMCConfigBuilder.create(
                                dmcUrl,
                                TBDS_USERNAME, TBDS_PASSWORD, TBDS_BUCKET
                        ).appToken(sysEnvConfig.getAppToken()).build()
                );
            }
        } catch (Exception e) {
            e.printStackTrace();
            if (StringUtils.isEmpty(dmcUrl)) {
                dmcClient = DMCBuilder.create().build(
                        DMCConfigBuilder.create(
                                dmcUrl,
                                ATHENA_USERNAME, ATHENA_PASSWORD, ATHENA_BUCKET
                        ).appToken(sysEnvConfig.getAppToken()).build()
                );
            }
        }
        return dmcClient;
    }

    @Lazy
    @Bean
    public DMC dmcCtpClient() {
        DMC dmcClient = null;
        String dmcUrl = AppContext.getApiUrlSetting().getDmcUrl();
        try {
            if (StringUtils.isEmpty(dmcUrl)) {
                dmcClient = DMCBuilder.create().build(
                        DMCConfigBuilder.create(
                                dmcUrl,
                                CTP_USERNAME, CTP_PASSWORD, CTP_BUCKET
                        ).appToken(sysEnvConfig.getAppToken()).build()
                );
            }

        } catch (Exception e) {
            e.printStackTrace();
            if (StringUtils.isEmpty(dmcUrl)) {
                dmcClient = DMCBuilder.create().build(
                        DMCConfigBuilder.create(
                                dmcUrl,
                                ATHENA_USERNAME, ATHENA_PASSWORD, ATHENA_BUCKET
                        ).appToken(sysEnvConfig.getAppToken()).build()
                );
            }
        }
        return dmcClient;
    }

    @Lazy
    @Bean
    public DMC dmcSchClient() {
        DMC dmcClient = null;
        String dmcUrl = AppContext.getApiUrlSetting().getDmcUrl();
        try {
            if (StringUtils.isEmpty(dmcUrl)) {
                dmcClient = DMCBuilder.create().build(
                        DMCConfigBuilder.create(
                                dmcUrl,
                                SCH_USERNAME, SCH_PASSWORD, SCH_BUCKET
                        ).appToken(sysEnvConfig.getAppToken()).build()
                );
            }
        } catch (Exception e) {
            e.printStackTrace();
            if (StringUtils.isEmpty(dmcUrl)) {
                dmcClient = DMCBuilder.create().build(
                        DMCConfigBuilder.create(
                                dmcUrl,
                                ATHENA_USERNAME, ATHENA_PASSWORD, ATHENA_BUCKET
                        ).appToken(sysEnvConfig.getAppToken()).build()
                );
            }
        }
        return dmcClient;
    }

    @Lazy
    @Bean
    public DMC agileDataClient() {
        DMC dmcClient = null;
        String dmcUrl = AppContext.getApiUrlSetting().getDmcUrl();
        try {
            if (StringUtils.isEmpty(dmcUrl)) {
                dmcClient = DMCBuilder.create().build(
                        DMCConfigBuilder.create(
                                dmcUrl,
                                AGILE_DATA_USERNAME, AGILE_DATA_PASSWORD, AGILE_DATA_BUCKET
                        ).appToken(sysEnvConfig.getAppToken()).build()
                );
            }
        } catch (Exception e) {
            log.error("agileDataClient error：{}", e.getMessage(), e);
            if (StringUtils.isEmpty(dmcUrl)) {
                dmcClient = DMCBuilder.create().build(
                        DMCConfigBuilder.create(
                                dmcUrl,
                                ATHENA_USERNAME, ATHENA_PASSWORD, ATHENA_BUCKET
                        ).appToken(sysEnvConfig.getAppToken()).build()
                );
            }
        }
        return dmcClient;
    }
}