package com.digiwin.mobile.mobileuibot.proxy.dmc.model;

import lombok.Data;

/**
 * 多段文件上传入参
 *
 * @author yanfeng
 * @date 2024/8/23
 */
@Data
public class SegmentedUploadFileDTO {

    /**
     * 必有字段  备注：原始名称，需要带后缀名
     */
    private String fileName;

    /**
     * 可有字段  备注：显示名称
     */
    private String displayName;

    /**
     * 可有字段  备注：文件描述信息
     */
    private String description;

    /**
     * 备注：标签，多个用分号[;]分开
     */
    private String tag;

    /**
     * 可有字段  备注：过期时间，到期会自动移进回收站或者永久删除
     */
    private String expireDate;

    /**
     * 可有字段  备注：目录ID，根目录填0或者不填
     */
    private String directoryId;

    /**
     * 可有字段  备注：IAM的租户ID（默认token里面的租户）
     */
    private String tenantId;

}