package com.digiwin.mobile.mobileuibot.proxy.dmc.service;

import com.digiwin.dap.middleware.dmc.model.DirInfo;
import com.digiwin.dap.middleware.dmc.model.FileInfo;
import com.digiwin.dap.middleware.dmc.model.ShareInfo;
import com.digiwin.mobile.mobileuibot.proxy.dmc.model.SegmentedUploadFileDTO;
import org.springframework.core.io.Resource;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷文档中心（DMC）代理服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinDmcProxyService
 * @Author: Zaregoto
 * @Date: 2021/6/9 10:55
 */
public interface DigiwinDmcProxyService {

    String API_PREFIX = "/api/dmc/v2";

    String DEFAULT_DIR = "00000000-0000-0000-0000-000000000000";

    /**
     * 上传文件到指定目录,bucket为Athena
     *
     * @param file  文件
     * @param dirId 目录id
     * @return
     */
    @Deprecated
    FileInfo uploadFile(File file, String dirId);

    /**
     * 上传文件到指定目录
     *
     * @param var1
     * @param var2
     * @return
     */
    FileInfo uploadFile(InputStream var1, FileInfo var2);

    /**
     * 上传文件到指定目录
     *
     * @param fileBytes
     * @param fileName
     * @param dirId
     * @return
     */
    @Deprecated
    FileInfo uploadFile(byte[] fileBytes, String fileName, String dirId);

    /**
     * 上传文件到指定目录
     *
     * @param fileBytes
     * @param fileName
     * @param contentType 上传文件的MIME类型
     * @param dirId
     * @param bucket      可选值为DigiwinDmcConfig.ATHENA_BUCKET和DigiwinDmcConfig.FRC_BUCKET
     * @return
     */
    FileInfo uploadFile(byte[] fileBytes, String fileName, String contentType, String dirId, String bucket);

    /**
     * 获取dmc系统的userToken
     *
     * @return
     */
    @Deprecated
    String getDmcUserToken();

    /**
     * 获取dmc系统的userToken
     *
     * @param bucket 可选值为DigiwinDmcConfig.ATHENA_BUCKET和DigiwinDmcConfig.FRC_BUCKET
     * @return
     */
    String getDmcUserToken(String bucket);


    /**
     * 获取文件分享链接
     *
     * @param fileId 附件id
     */
    @Deprecated
    ShareInfo shareFile(String fileId);

    /**
     * 获取文件分享链接
     *
     * @param fileId
     * @param bucket 可选值为DigiwinDmcConfig.ATHENA_BUCKET和DigiwinDmcConfig.FRC_BUCKET
     * @return
     */
    ShareInfo shareFile(String fileId, String bucket);

    /**
     * 根据目录名称获取目录id
     *
     * @param dirName 目录名称
     * @return
     */
    @Deprecated
    String getDirIdByName(String dirName);

    /**
     * 根据目录名称获取目录id
     *
     * @param dirName
     * @param bucket  可选值为DigiwinDmcConfig.ATHENA_BUCKET和DigiwinDmcConfig.FRC_BUCKET
     * @return
     */
    String getDirIdByName(String dirName, String bucket);

    /**
     * 删除附件
     *
     * @param fileId 附件id
     * @return
     */
    @Deprecated
    boolean deleteFile(String fileId);

    /**
     * 删除指定目录
     *
     * @param dirId  目录id
     * @param bucket 桶
     * @return
     */
    boolean deleteDir(String dirId, String bucket);

    /**
     * 删除附件
     *
     * @param fileId
     * @param bucket 可选值为DigiwinDmcConfig.ATHENA_BUCKET和DigiwinDmcConfig.FRC_BUCKET
     * @return
     */
    boolean deleteFile(String fileId, String bucket);

    /**
     * 删除分享
     *
     * @param shareId
     * @param bucket
     * @return
     */
    boolean deleteShare(String shareId, String bucket);

    /**
     * 在根目录下创建目录
     *
     * @param name
     * @return
     */
    @Deprecated
    DirInfo createDir(String name);

    /**
     * 在根目录下创建目录
     *
     * @param name
     * @param bucket 可选值为DigiwinDmcConfig.ATHENA_BUCKET和DigiwinDmcConfig.FRC_BUCKET
     * @return
     */
    DirInfo createDir(String name, String bucket);

    /**
     * 在根目录下创建目录
     *
     * @param dirId
     * @param name
     * @param bucket 可选值为DigiwinDmcConfig.ATHENA_BUCKET和DigiwinDmcConfig.FRC_BUCKET
     * @return
     */
    DirInfo createDir(String dirId, String name, String bucket);

    /**
     * 分段上传-创建空文件
     *
     * @param dto
     * @return
     */
    String segmentedUploadFile(SegmentedUploadFileDTO dto, String bucket, String token);

    /**
     * 分段上传-上传分片
     *
     * @param bucket 数据库
     * @param fileId 文件id(segmentedUploadFile()方法返回的id)
     * @param from   文件流起始位置
     * @param to     文件流结束位置
     * @param total  文件大小
     * @return
     */
    String segmentUploadCreateFile(Resource resource, String token, String bucket, String fileId, Integer from, Integer to, Integer total);

    /**
     * 获取目录下的所有文件信息
     *
     * @param dirId
     * @param bucket 可选值为DigiwinDmcConfig.ATHENA_BUCKET和DigiwinDmcConfig.FRC_BUCKET
     * @return
     */
    List<FileInfo> getFileInfos(String dirId, String bucket);

    /**
     * 获取文件id获取文件信息
     *
     * @param bucket
     * @param ids
     * @return
     */
    List<FileInfo> getFileInfoByIds(String bucket, List<String> ids);

}