package com.digiwin.mobile.mobileuibot.proxy.emc.model;

import lombok.Getter;
import org.springframework.util.StringUtils;

/**
 * <p>功能描述：鼎捷EMC验证码场景枚举类</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: EmcVerificationCodeSceneEnum.java
 * @Author: wangjwc
 * @Date: created at 2025/8/5 16:40
 */
@Getter
public enum EmcVerificationCodeSceneEnum {
    /**
     * 注册
     */
    REGISTER("register"),
    /**
     * 修改密码
     */
    CHANGEPASSWORD("changepassword"),
    /**
     * 解冻登录
     */
    UNFREEZELOGIN("unfreezelogin"),
    /**
     * 自定义验证码
     */
    CUSTOMCAPTCHA("customcaptcha"),
    /**
     * 验证码登录
     */
    VERIFICATIONCODELOGIN("verificationCodelogin"),
    ;

    private final String value;

    EmcVerificationCodeSceneEnum(String value) {
        this.value = value;
    }

    public static boolean isExist(String value) {
        if (!StringUtils.hasLength(value)) {
            return false;
        }
        for (EmcVerificationCodeSceneEnum typeEnum : values()) {
            if (typeEnum.getValue().equals(value)) {
                return true;
            }
        }
        return false;
    }

    public static boolean notExist(String value) {
        return !isExist(value);
    }
}
