package com.digiwin.mobile.mobileuibot.proxy.emc.service;

import com.digiwin.mobile.mobileuibot.proxy.emc.model.CheckVerificationCodeResponse;
import com.digiwin.mobile.mobileuibot.proxy.emc.model.DigiwinEmcResponse;

import java.util.Map;

/**
 * 鼎捷emc系统代理服务
 *
 * @author wuyangz
 * @date 2022/9/8
 */
public interface DigiwinEmcProxyService {

    String API_PREFIX = "/api/emc/v1";

    /**
     * 获取不同场景下的验证码
     *
     * @param locale      语言别
     * @param phoneNumber 手机号
     * @param scene       场景
     * @return
     */
    DigiwinEmcResponse getVerificationCode(String locale, String phoneNumber, String scene);

    /**
     * 发送邮件或者短信
     * @param iamUserToken
     * @param type
     * @return
     */
    Boolean sendEmailOrPhoneCode(String iamUserToken, Integer type, String msg);

    /**
     * 发送验证码
     * @param iamUserToken 用户token
     * @param type com.digiwin.mobile.mobileuibot.user.enums.VerificationTypeEnum
     * @param account 手机号或者邮箱
     * @param scene com.digiwin.mobile.mobileuibot.proxy.emc.model.EmcVerificationCodeSceneEnum
     * @return 响应
     */
    Boolean sendVerificationCode(String iamUserToken, String type, String account, String scene);

    /**
     * 检查验证码并返回新验证码
     * @param iamUserToken 用户token
     * @param params 参数
     * @return 返回新验证码
     */
    CheckVerificationCodeResponse checkVerificationCodeAndRenew(String iamUserToken, Map<String, Object> params);
}
