package com.digiwin.mobile.mobileuibot.proxy.emc.service.impl;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.proxy.emc.model.CheckVerificationCodeResponse;
import com.digiwin.mobile.mobileuibot.proxy.emc.model.DigiwinEmcResponse;
import com.digiwin.mobile.mobileuibot.proxy.emc.service.DigiwinEmcProxyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.*;

/**
 * @author wuyang
 */
@Service("digiwinEmcProxyService")
public class DigiwinEmcProxyServiceImpl implements DigiwinEmcProxyService {

    @Autowired
    private HttpService httpService;

    @Autowired
    private SysEnvConfig sysEnvConfig;

    @Override
    public DigiwinEmcResponse getVerificationCode(String locale, String phoneNumber, String scene) {
        String url = AppContext.getApiUrlSetting().getEmcUrl() + DigiwinEmcProxyService.API_PREFIX
                + "/verificationCode/mobilephone/" + phoneNumber + "/" + scene;
        ResponseEntity<DigiwinEmcResponse> responseEntity;
        /**
         * 成功：{"code":200,"success":true,"result":"success"}
         * 失败：{"code":0,"success":false,"message":"获取验证码时间过短，请稍后重试！","result":"获取验证码时间过短，请稍后重试！"}
         */
        if (Objects.equals(locale.trim(), Locale.TRADITIONAL_CHINESE.toString())) {
            Map<String, String> content = new HashMap<>(1);
            content.put("content", "【鼎新雲】您的驗證碼為：[%s](5分鐘有效)，為保證您的帳號安全，請注意保密。感謝您使用鼎新雲！");
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead().setAcceptLanguage("zh-TW,zh;q=0.8"),
                    JsonUtil.javaObjectToJsonString(content), DigiwinEmcResponse.class);
        } else {
            Map<String, String> content = new HashMap<>(1);
            content.put("content", "验证码：[%s](5分钟有效)，为保证您的账号安全，请注意保密。感谢您使用鼎捷云！");
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead().setAcceptLanguage("zh-CN,zh;q=0.8"),
                    JsonUtil.javaObjectToJsonString(content), DigiwinEmcResponse.class);
        }
        return responseEntity.getBody();
    }

    @Override
    public Boolean sendEmailOrPhoneCode(String iamUserToken, Integer type, String msg) {
        String path = "";
        //0：邮箱，1：短信
        if (type.equals(0)) {
            path = "/verificationCode/email";
        }
        if (type.equals(1)) {
            path = "/verificationCode/mobilephone";
        }
        String url = AppContext.getApiUrlSetting().getEmcUrl() + DigiwinEmcProxyService.API_PREFIX + path + "/" + msg + "/verificationCodelogin";
        ResponseEntity<DigiwinEmcResponse> responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead().setProxyToken(sysEnvConfig.getAppToken()), Collections.EMPTY_MAP,
                new ParameterizedTypeReference<DigiwinEmcResponse>() {
                });
        if (responseEntity.getStatusCode().is2xxSuccessful() && responseEntity.getBody().getSuccess()) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean sendVerificationCode(String iamUserToken, String type, String account, String scene) {
        String url = AppContext.getApiUrlSetting().getEmcUrl() + DigiwinEmcProxyService.API_PREFIX
                + "/verificationCode/" + type + "/" + account + "/" + scene;
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinEmcResponse> responseType =
                new ParameterizedTypeReference<DigiwinEmcResponse>() {
                };
        ResponseEntity<DigiwinEmcResponse> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken),
                        JsonUtil.javaObjectToJsonString(new HashMap<>()), responseType);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            throw new ServiceException(responseEntity.getBody().getMessage());
        }
        return true;
    }

    @Override
    public CheckVerificationCodeResponse checkVerificationCodeAndRenew(String iamUserToken, Map<String, Object> params) {
        String url = AppContext.getApiUrlSetting().getEmcUrl() + DigiwinEmcProxyService.API_PREFIX
                + "/checkVerificationCode/renew";
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<CheckVerificationCodeResponse> responseType =
                new ParameterizedTypeReference<CheckVerificationCodeResponse>() {
                };
        ResponseEntity<CheckVerificationCodeResponse> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken),
                        JsonUtil.javaObjectToJsonString(params), responseType);
        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            throw new ServiceException(responseEntity.getBody().getMessage());
        }
        return responseEntity.getBody();
    }
}