package com.digiwin.mobile.mobileuibot.proxy.enums;

import com.digiwin.mobile.mobileuibot.proxy.aam.service.DigiwinAamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.aim.service.DigiwinAimProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atdm.service.DigiwinAtdmProxyService;
import com.digiwin.mobile.mobileuibot.proxy.atmc.service.DigiwinAtmcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.audc.service.DigiwinAudcProxyService;
import com.digiwin.mobile.mobileuibot.proxy.uibot.service.DigiwinPcUiBotProxyService;
import org.springframework.util.StringUtils;

/**
 * 功能: 智驱中台 组件调用需要必传 租户ID 的组件
 * 请求外部的Url 是否包含此枚举内前缀：
 * 包含：强校验租户ID必传
 * 不包含：租户ID非必传
 *
 * @author: wjw
 * @date: created at 2023/1/20
 */
public enum AthenaCheckApiEnum {
    /**
     * 强校验的URL列表
     */
    ATMC(new String[]{DigiwinAtmcProxyService.API_PREFIX}),
    UIBOT(new String[]{DigiwinPcUiBotProxyService.API_PREFIX_TOP}),
    ATDM(new String[]{DigiwinAtdmProxyService.DATA_API_PREFIX, DigiwinAtdmProxyService.ACTION_API_PREFIX}),
    AUDC(new String[]{DigiwinAudcProxyService.API_PREFIX, DigiwinAudcProxyService.AMTC_API_PREFIX}),
    // wjw FIXME: 2023/1/29 应该与其它一样，由前缀控制
    IM(new String[]{"/user/loginAndCreate", "/user/getAndCreate", "/team/create", "/team/getTeamMembers/",
            "/team/addMembers", "/user/getUsers"}),
    AAM(new String[]{DigiwinAamProxyService.API_PREFIX}),
    AIM(new String[]{DigiwinAimProxyService.API_PREFIX, DigiwinAimProxyService.NEW_API_PREFIX}),
    ;

    private String[] prefixs;

    AthenaCheckApiEnum(String[] prefixs) {
        this.prefixs = prefixs;
    }

    public String[] getPrefixs() {
        return prefixs;
    }

    /**
     * 是否存在枚举值
     *
     * @param url
     * @return
     */
    public static boolean isExist(String url) {
        if (!StringUtils.hasLength(url)) {
            return false;
        }
        for (AthenaCheckApiEnum apiEnum : AthenaCheckApiEnum.values()) {
            for (String prefix : apiEnum.getPrefixs()) {
                if (url.contains(prefix)) {
                    return true;
                }
            }
        }
        return false;
    }
}
