package com.digiwin.mobile.mobileuibot.proxy.eoc.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class DigiwinEocEmployee {

    private Long sid;

    private String id;

    private String name;

    private String email;

    private String telephone;

    private List<DigiwinEocEmployeeDepart> depts;

    private DigiwinEocEmployeeUser user;

    @Data
    public static class DigiwinEocEmployeeUser {
        private String id;
        private String name;
        private String email;
        private String telephone;
    }

    @Data
    public static class DigiwinEocEmployeeDepart {
        private Long sid;
        /**
         * 部门ID
         */
        private String id;
        /**
         * 部门名称
         */
        private String name;
        /**
         * 部门主管EOC ID
         */
        private String deptDirectorId;
        /**
         * 是否是主部门
         */
        private Boolean mainDept;
    }
}
