package com.digiwin.mobile.mobileuibot.proxy.eoc.model;

import lombok.Data;

import java.util.List;

/**
 * 获取租户下面所有人员API的返回值接口
 * api/eoc/v2/emp
 */
@Data
public class DigiwinEocTenantAllUser {

    private int code;
    private String message;
    private boolean success;
    private EocTenantDataDTO data;

    @Data
    public static class EocTenantDataDTO {

        private Integer total;

        private List<DigiwinEocUser> list;

    }

    @Data
    public static class DigiwinEocUser {
        private Long sid;

        /**
         * 必有字段  备注：员工id
         */
        private String id;

        /**
         * 必有字段  备注：员工名称
         */
        private String name;

        private String email;

        private Boolean status;

        /**
         * 必有字段  备注：部门id
         */
        private String deptId;

        /**
         * 必有字段  备注：部门名称
         */
        private String deptName;


        private String userId;

        private String userName;
    }
}
