package com.digiwin.mobile.mobileuibot.proxy.eoc.model;

import com.digiwin.mobile.mobileuibot.common.string.StringUtil;

import java.io.Serializable;

/**
 * 人员详细信息
 *
 * @author zhangjj
 * @date 2021/8/27 0027 15:24
 */
public class EocPersonInfo implements Serializable {
    private static final long serialVersionUID = 8444199999389744795L;

    private String eocId;
    private String name;
    private String userId;
    private String accId;
    private String dept;
    private String email;
    private String phone;
    private String position;
    /**
     * 职称
     */
    private String titleName;

    public String getEocId() {
        return eocId;
    }

    public void setEocId(String eocId) {
        this.eocId = eocId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = StringUtil.clearEscapeControlCharacter(name);
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getAccId() {
        return accId;
    }

    public void setAccId(String accId) {
        this.accId = accId;
    }

    public String getDept() {
        return dept;
    }

    public void setDept(String dept) {
        this.dept = StringUtil.clearEscapeControlCharacter(dept);
    }

    public String getEmail() {
        return email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = StringUtil.clearEscapeControlCharacter(position);
    }

    public String getTitleName() {
        return titleName;
    }

    public void setTitleName(String titleName) {
        this.titleName = titleName;
    }
}
