package com.digiwin.mobile.mobileuibot.proxy.eoc.service;

import com.digiwin.mobile.mobileuibot.proxy.eoc.model.*;

import java.util.List;
import java.util.Map;

/**
 * 鼎捷eoc系统代理服务
 *
 * @author zhangjj
 * @date 2021/7/14 0014 11:21
 */
public interface DigiwinEocProxyService {

    /**
     * 获取人员列表
     *
     * @param iamUserToken   用户token
     * @param pageSize       每页资料数
     * @param pageNum        页码
     * @param queryCondition 模糊搜索关键字
     * @return
     */
    EocPersonResponse getPersonList(String iamUserToken, int pageSize, int pageNum, String queryCondition);

    /**
     * 获取人员列表
     *
     * @param iamUserToken   用户token
     * @param pageSize       每页资料数
     * @param pageNum        页码
     * @param queryCondition 模糊搜索关键字
     * @return
     */
    EocPersonResponse getSimplePersonList(String iamUserToken, int pageSize, int pageNum, String queryCondition);

    /**
     * 获取人员列表
     *
     * @param iamUserToken 用户token
     * @param pageSize     每页资料数
     * @param pageNum      页码
     * @param params       模糊搜索关键字
     * @return
     */
    EocPersonResponse getSimplePersonListByParams(String iamUserToken, int pageSize, int pageNum, Map<String, Object> params);

    /**
     * 获取所有部门
     *
     * @param iamUserToken
     * @return
     */
    EocDeptResponse getEocDeptList(String iamUserToken, int pageSize, int pageNum);

    /**
     * 获取部门下人员列表
     *
     * @param iamUserToken
     * @param pageSize
     * @param pageNum
     * @return
     */
    EocDeptPersonResponse getEocDeptPersonList(String deptId, String iamUserToken, int pageSize, int pageNum);

    /**
     * 获取人员详细信息
     *
     * @param id
     * @param iamUserToken
     * @param type         1为eocId,2为userId
     * @return
     */
    EocPersonInfo getEocPersonInfo(String id, String iamUserToken, int type);

    /**
     * 获取eoc用户详细信息，和web端保持一致
     *
     * @param id
     * @param iamUserToken
     * @return
     */
    EocPerson getEocInfo(String id, String iamUserToken);

    /**
     * 获取人员详细信息(没有accId)
     *
     * @param id
     * @param iamUserToken
     * @return
     */
    EocPersonInfo getEocPersonInfo(String id, String iamUserToken);

    /**
     * 获取人员姓名
     *
     * @param id
     * @param iamUserToken
     * @return
     */
    String getName(String id, String iamUserToken);

    /**
     * 获取eocId
     *
     * @param iamUserToken
     * @param userId
     * @return
     */
    String getEocId(String iamUserToken, String userId);

    /**
     * 获取公司别
     *
     * @param iamUserToken
     */
    List<Map<String, Object>> getCompany(String iamUserToken);

    /**
     * 获取工厂别
     */
    List<Map<String, Object>> getFactory(String iamUserToken);

    /**
     * 获取区域
     */
    List<Map<String, Object>> getArea(String iamUserToken);

    /**
     * 判断当前人员是否为部门主管
     *
     * @param userId
     * @return
     */
    Boolean isDeptDirector(String userId, String iamUserToken);

    /**
     * 获取指定用户代理的所有目标用户列表
     *
     * @param userId 用户id
     * @return 用户基本信息
     */
    List<EocProxyUserResult.EocProxyUser> getProxyTargetUsers(String userId, String iamUserToken);

    /**
     * 新增或更新员工
     *
     * @param locale
     * @param userId
     * @param iamUserToken
     */
    boolean addOrUpdateEocEmp(String locale, String userId, String iamUserToken, DigiwinEocAddUpdateEmp empInfo);

    /**
     * 获取Eoc组织树
     *
     * @param iamUserToken
     */
    EocOrg getEocOrgTree(String iamUserToken);
}
