package com.digiwin.mobile.mobileuibot.proxy.eoc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.AppRequestContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import com.digiwin.mobile.mobileuibot.proxy.eoc.model.*;
import com.digiwin.mobile.mobileuibot.proxy.eoc.service.DigiwinEocProxyService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

import java.util.*;

/**
 * @author zhangjj
 * @date 2021/7/14 0014 11:43
 */
@Slf4j
@Service("digiwinEocProxyService")
public class DigiwinEocProxyServiceImpl implements DigiwinEocProxyService {

    @Autowired
    private HttpService httpService;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private SysEnvConfig sysEnvConfig;

    @Override
    public EocPersonResponse getPersonList(String iamUserToken, int pageSize, int pageNum, String queryCondition) {
        EocPersonResponse eocPersonResponse = null;
        JSONObject queryObj = new JSONObject();
        queryObj.put("content", queryCondition);
        String queryStr = queryObj.toString();
        Map<String, Object> uriVariables = new HashMap<>();
        uriVariables.put("pageSize", pageSize);
        uriVariables.put("pageNum", pageNum);
        uriVariables.put("params", queryStr);

        String url = AppContext.getApiUrlSetting().getEocUrl()
                + "/api/eoc/v2/emp?pageSize={pageSize}&pageNum={pageNum}&params={params}";
        ResponseEntity<Map> responseEntity =
                httpService.doGet(url, new AthenaBasicHttpRequestHead(iamUserToken), uriVariables, Map.class);
        Map<String, Object> responseMap = responseEntity.getBody();
        if (responseMap.get("code").equals(200)) {
            eocPersonResponse = JsonUtil.objectToJavaObject(responseMap.get("data"), EocPersonResponse.class);
        }
        return eocPersonResponse != null ? eocPersonResponse : EocPersonResponse.getEmptyObject();
    }

    @Override
    public EocPersonResponse getSimplePersonList(String iamUserToken, int pageSize, int pageNum, String queryCondition) {
        EocPersonResponse eocPersonResponse = null;
        JSONObject queryObj = new JSONObject();
        queryObj.put("content", queryCondition);
        String queryStr = queryObj.toString();
        Map<String, Object> uriVariables = new HashMap<>();
        uriVariables.put("pageSize", pageSize);
        uriVariables.put("pageNum", pageNum);
        uriVariables.put("params", queryStr);

        String url = AppContext.getApiUrlSetting().getEocUrl()
                + "/api/eoc/v2/emp/simple?pageSize={pageSize}&pageNum={pageNum}&params={params}";
        ResponseEntity<Map> responseEntity =
                httpService.doGet(url, new AthenaBasicHttpRequestHead(iamUserToken), uriVariables, Map.class);
        Map<String, Object> responseMap = responseEntity.getBody();
        if (responseMap.get("code").equals(200)) {
            eocPersonResponse = JsonUtil.objectToJavaObject(responseMap.get("data"), EocPersonResponse.class);
        }
        return eocPersonResponse != null ? eocPersonResponse : EocPersonResponse.getEmptyObject();
    }

    @Override
    public EocPersonResponse getSimplePersonListByParams(String iamUserToken, int pageSize, int pageNum, Map<String, Object> params) {
        EocPersonResponse eocPersonResponse = null;
        Map<String, Object> uriVariables = new HashMap<>();
        uriVariables.put("pageSize", pageSize);
        uriVariables.put("pageNum", pageNum);
        uriVariables.put("params", params);

        String url = AppContext.getApiUrlSetting().getEocUrl()
                + "/api/eoc/v2/emp/simple?pageSize={pageSize}&pageNum={pageNum}&params={params}";
        ResponseEntity<Map> responseEntity =
                httpService.doGet(url, new AthenaBasicHttpRequestHead(iamUserToken), uriVariables, Map.class);
        Map<String, Object> responseMap = responseEntity.getBody();
        if (responseMap.get("code").equals(200)) {
            eocPersonResponse = JsonUtil.objectToJavaObject(responseMap.get("data"), EocPersonResponse.class);
        }
        return eocPersonResponse != null ? eocPersonResponse : EocPersonResponse.getEmptyObject();
    }

    @Override
    public EocDeptResponse getEocDeptList(String iamUserToken, int pageSize, int pageNum) {
        EocDeptResponse eocDeptResponse = null;
        Map<String, Object> uriVariables = new HashMap<>();
        uriVariables.put("pageSize", pageSize);
        uriVariables.put("pageNum", pageNum);
        String url = AppContext.getApiUrlSetting().getEocUrl()
                + "/api/eoc/v2/dept/list?pageSize={pageSize}&pageNum={pageNum}";
        ResponseEntity<Map> responseEntity =
                httpService.doGet(url, new AthenaBasicHttpRequestHead(iamUserToken), uriVariables, Map.class);
        Map<String, Object> responseMap = responseEntity.getBody();
        if (responseMap.get("code").equals(200)) {
            eocDeptResponse = JsonUtil.objectToJavaObject(responseMap.get("data"), EocDeptResponse.class);
        }
        return eocDeptResponse != null ? eocDeptResponse : EocDeptResponse.getEmptyObject();
    }

    @Override
    public EocDeptPersonResponse getEocDeptPersonList(String deptId, String iamUserToken, int pageSize, int pageNum) {
        EocDeptPersonResponse eocDeptPersonResponse = null;
        Map<String, Object> uriVariables = new HashMap<>();
        uriVariables.put("pageSize", pageSize);
        uriVariables.put("pageNum", pageNum);
        String url = AppContext.getApiUrlSetting().getEocUrl()
                + "/api/eoc/v2/dept/" + deptId + "/emps?pageSize={pageSize}&pageNum={pageNum}";
        ResponseEntity<Map> responseEntity =
                httpService.doGet(url, new AthenaBasicHttpRequestHead(iamUserToken), uriVariables, Map.class);
        Map<String, Object> responseMap = responseEntity.getBody();
        if (responseMap.get("code").equals(200)) {
            eocDeptPersonResponse = JsonUtil.objectToJavaObject(responseMap.get("data"), EocDeptPersonResponse.class);
        }
        return eocDeptPersonResponse != null ? eocDeptPersonResponse : EocDeptPersonResponse.getEmptyObject();
    }

    @Override
    public EocPerson getEocInfo(String id, String iamUserToken) {
        Map<String, String> body = new HashMap<>(1);
        /*
        userId是iam的，empId是eoc的；
            鼎捷云上开通了应用可用的是iam的，企业用户里面的用户可以不上鼎捷云，也就是说，
            userId一定有empId，但empId不一定有userId
         */
        body.put("userId", id);
        try {
            String url = AppContext.getApiUrlSetting().getEocUrl()
                    + "/api/eoc/v2/emp/info";
            ResponseEntity<DigiwinEocResult> responseEntity =
                    httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(body), DigiwinEocResult.class);
            DigiwinEocResult result = responseEntity.getBody();
            if (result != null && result.isSuccess()) {
                return JsonUtil.objectToJavaObject(result.getData(), EocPerson.class);
            }
        } catch (Exception e) {
            return new EocPerson();
        }
        return null;
    }

    @Override
    public EocPersonInfo getEocPersonInfo(String id, String iamUserToken, int type) {
        EocPersonInfo personInfo = new EocPersonInfo();
        Map body = new HashMap();
        String eocId = null;
        if (type == 1) {
            eocId = id;
            body.put("empId", id);
        } else {
            body.put("userId", id);
        }
        String url = AppContext.getApiUrlSetting().getEocUrl()
                + "/api/eoc/v2/emp/info";
        ResponseEntity<Map> responseEntity =
                httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(body), Map.class);
        Map<String, Object> responseMap = responseEntity.getBody();
        if (responseMap.get("code").equals(200)) {
            Map person = (Map) responseMap.get("data");
            eocId = (String) person.get("id");
            personInfo.setEocId((String) person.get("id"));
            personInfo.setName((String) person.get("name"));
            personInfo.setEmail((String) person.get("email"));
            personInfo.setPhone((String) person.get("telephone"));
            Map user = (Map) person.get("user");
            if (user != null) {
                personInfo.setUserId((String) user.get("id"));
//                personInfo.setName((String) user.get("name"));
                personInfo.setEmail((String) user.get("email"));
            }
            // todo 怎么显示部门职级还没确定
//            List<Map> depts = (List<Map>) person.get("depts");
//            if (depts != null && !depts.isEmpty()) {
//                depts.stream().forEach(dept -> {
//                    dept.get("name");//部门
//                    dept.get("levelName");//职级
//                });
//            }
            //职位
            StringBuilder position = new StringBuilder();
            List<Map> duties = (List<Map>) person.get("duties");
            if (duties != null && !duties.isEmpty()) {
                duties.stream().forEach(duty -> {
                    position.append(duty.get("name") + "/");
                });
            }
            if (position.length() > 0) {
                personInfo.setPosition(position.substring(0, position.length() - 1));
            }
        }
        //查询对应的云信账号
        if (StringUtils.hasLength(eocId)) {
            String imUrl = AppContext.getApiUrlSetting().getImUrl()
                    + "/user/getUserInfo/" + eocId;
            ResponseEntity<Map> imResponseEntity =
                    httpService.doGet(imUrl, new AthenaBasicHttpRequestHead(iamUserToken), new HashMap<>(), Map.class);
            Map<String, Object> imResponseMap = imResponseEntity.getBody();
            if (imResponseMap.get("response") != null) {
                Map imInfo = (Map) imResponseMap.get("response");
                personInfo.setAccId((String) imInfo.get("accid"));
            }
        }
        return personInfo;
    }

    @Override
    public EocPersonInfo getEocPersonInfo(String id, String iamUserToken) {
        EocPersonInfo personInfo = new EocPersonInfo();
        Map body = new HashMap();
        body.put("empId", id);
        String url = AppContext.getApiUrlSetting().getEocUrl()
                + "/api/eoc/v2/emp/info";
        ResponseEntity<Map> responseEntity =
                httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(body), Map.class);
        Map<String, Object> responseMap = responseEntity.getBody();
        if (responseMap.get("code").equals(200)) {
            Map person = (Map) responseMap.get("data");
            personInfo.setEocId((String) person.get("id"));
            personInfo.setName((String) person.get("name"));
            personInfo.setEmail((String) person.get("email"));
            personInfo.setPhone((String) person.get("telephone"));
            Map user = (Map) person.get("user");
            if (user != null) {
                personInfo.setUserId((String) user.get("id"));
            }
            // todo 怎么显示部门职级还没确定
//            List<Map> depts = (List<Map>) person.get("depts");
//            if (depts != null && !depts.isEmpty()) {
//                depts.stream().forEach(dept -> {
//                    dept.get("name");//部门
//                    dept.get("levelName");//职级
//                });
//            }
            //职位
            StringBuilder position = new StringBuilder();
            List<Map> duties = (List<Map>) person.get("duties");
            if (duties != null && !duties.isEmpty()) {
                duties.stream().forEach(duty -> {
                    position.append(duty.get("name") + "/");
                });
            }
            if (position.length() > 0) {
                personInfo.setPosition(position.substring(0, position.length() - 1));
            }
        }
        return personInfo;
    }

    @Override
    public String getName(String id, String iamUserToken) {
        Map body = new HashMap();
        body.put("empId", id);
        String url = AppContext.getApiUrlSetting().getEocUrl()
                + "/api/eoc/v2/emp/info";
        ResponseEntity<Map> responseEntity =
                httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(body), Map.class);
        Map<String, Object> responseMap = responseEntity.getBody();
        Map person = (Map) responseMap.get("data");
        return (String) person.get("name");
    }

    @Override
    public String getEocId(String iamUserToken, String userId) {
        String url = AppContext.getApiUrlSetting().getEocUrl()
                + "/api/eoc/v2/emp/id";
        Map body = new HashMap(1);
        body.put("userId", userId);
        ResponseEntity<Map> responseEntity =
                httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(body), Map.class);
        Map<String, Object> responseMap = responseEntity.getBody();
        return (String) responseMap.get("data");
    }


    @Override
    public List<Map<String, Object>> getCompany(String iamUserToken) {
        String url = AppContext.getApiUrlSetting().getEocUrl()
                + "/api/eoc/v2/corp/company";
        ResponseEntity<Map> responseEntity =
                httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), new HashMap<>(), Map.class);
        List<Map<String, Object>> resultMap = (List<Map<String, Object>>) responseEntity.getBody().get("data");
        return resultMap != null ? resultMap : Collections.emptyList();
    }

    @Override
    public List<Map<String, Object>> getFactory(String iamUserToken) {
        String url = AppContext.getApiUrlSetting().getEocUrl()
                + "/api/eoc/v2/corp/factory";
        ResponseEntity<Map> responseEntity =
                httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), new HashMap<>(), Map.class);
        List<Map<String, Object>> resultMap = (List<Map<String, Object>>) responseEntity.getBody().get("data");
        return resultMap != null ? resultMap : Collections.emptyList();
    }

    @Override
    public List<Map<String, Object>> getArea(String iamUserToken) {
        String url = AppContext.getApiUrlSetting().getEocUrl()
                + "/api/eoc/v2/area?pageSize={pageSize}";
        Map<String, Object> uriVariables = new HashMap<>();
        uriVariables.put("pageSize", 9999);
        ResponseEntity<Map> responseEntity =
                httpService.doGet(url, new AthenaBasicHttpRequestHead(iamUserToken), uriVariables, Map.class);
        Map<String, Object> resultMap = (Map<String, Object>) responseEntity.getBody().get("data");
        if (resultMap == null) {
            return Collections.emptyList();
        }
        List<Map<String, Object>> resultList = (List<Map<String, Object>>) resultMap.get("list");
        return resultList != null ? resultList : Collections.emptyList();
    }

    /**
     * 判断指定 userId 是否是部门主管
     *
     * @param userId
     * @return
     */
    @Override
    public Boolean isDeptDirector(String userId, String iamUserToken) {

        List<DigiwinEocTenantAllUser.DigiwinEocUser> eocUserDTOList = getAllUserByDirectorId(userId, 1, iamUserToken);
        if (!CollectionUtils.isEmpty(eocUserDTOList)) {
            return Boolean.TRUE;
        }

        DigiwinEocEmployee eocEmployeeDTO = getEmployeeByUserId(userId, iamUserToken);
        if (eocEmployeeDTO != null && !CollectionUtils.isEmpty(eocEmployeeDTO.getDepts())) {
            for (DigiwinEocEmployee.DigiwinEocEmployeeDepart dept : eocEmployeeDTO.getDepts()) {
                if (Objects.equals(dept.getDeptDirectorId(), eocEmployeeDTO.getId())) {
                    return Boolean.TRUE;
                }
            }
        }

        return Boolean.FALSE;
    }

    /**
     * 查找指定直属主管所属的人员列表
     *
     * @param directorId   要查询的直属主管userId
     * @param size         获取几个人
     * @param iamUserToken
     * @return
     */
    public List<DigiwinEocTenantAllUser.DigiwinEocUser> getAllUserByDirectorId(String directorId, Integer size, String iamUserToken) {

        //http://172.16.2.141:22694/html/web/controller/share/share.html#5f110cf741fcbe5bc65089cd

        //根据userId获取eocId
        DigiwinEocEmployee eocEmployeeDTO = getEmployeeByUserId(directorId, iamUserToken);
        if (eocEmployeeDTO == null) {
            return Collections.emptyList();
        }
        String url = AppContext.getApiUrlSetting().getEocUrl() + "/api/eoc/v2/emp/simple?pageNum=1&pageSize={pageSize}&params={params}";

        Map params = new HashMap();
        params.put("directorId", eocEmployeeDTO.getId());

        Map<String, String> param = new HashMap<>(2);
        param.put("pageSize", size.toString());
        param.put("params", JsonUtil.javaObjectToJsonString(params));

        ResponseEntity<DigiwinEocTenantAllUser> responseEntity =
                httpService.doGet(url, new AthenaBasicHttpRequestHead(iamUserToken), param, DigiwinEocTenantAllUser.class);
        DigiwinEocTenantAllUser result = responseEntity.getBody();
        if (result != null && result.isSuccess()) {
            return result.getData().getList();
        }
        return null;
    }

    /**
     * 根据userId获取员工详情
     *
     * @param userId
     * @param iamUserToken
     * @return
     */
    public DigiwinEocEmployee getEmployeeByUserId(String userId, String iamUserToken) {
        return getEmployee(userId, null, iamUserToken);
    }

    private DigiwinEocEmployee getEmployee(String userId, String empId, String iamUserToken) {
        String url = AppContext.getApiUrlSetting().getEocUrl() + "/api/eoc/v2/emp/info";

        Map<String, String> param = new HashMap<>(2);
        param.put("userId", userId);
        param.put("empId", empId);

        ResponseEntity<Map> responseEntity =
                httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(param), Map.class);
        Map<String, Object> resultMap = (Map<String, Object>) responseEntity.getBody().get("data");
        return resultMap != null ? JsonUtil.objectToJavaObject(resultMap, DigiwinEocEmployee.class) : null;
    }

    @Override
    public List<EocProxyUserResult.EocProxyUser> getProxyTargetUsers(String userId, String iamUserToken) {
        String url = AppContext.getApiUrlSetting().getEocUrl() + "/api/eoc/v2/emp/agent/target";

        Map<String, String> param = new HashMap<>(1);
        param.put("userId", userId);
        try {
            ResponseEntity<EocProxyUserResult> responseEntity =
                    httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken), JsonUtil.javaObjectToJsonString(param), EocProxyUserResult.class);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                return null;
            }
            EocProxyUserResult baseResult = responseEntity.getBody();
            if (baseResult != null && baseResult.getCode() == 200 && baseResult.getData() != null) {
                return baseResult.getData();
            }
            return null;
        } catch (Exception ex) {
            return null;
        }

    }

    @Override
    public boolean addOrUpdateEocEmp(String locale, String userId, String iamUserToken, DigiwinEocAddUpdateEmp empInfo) {
        String url = AppContext.getApiUrlSetting().getEocUrl() + "/api/eoc/v2/emp";

        /**
         * {"code":200,"message":"success","data":{"sid":812069141944320,"tenantSid":634803865117248,"id":"13916855715","name":"5715用户","status":false,"depts":[],"user":{"id":"7f5715","name":"5715用户","email":"","telephone":"13916855715"},"trial":false,"duties":[],"typeSid":0,"attributeSid":0,"strongholdSid":0,"financeSid":0,"groups":[]},"success":true}
         * The user has been bound.
         */
        try {
            ResponseEntity<Map> responseEntity =
                    httpService.doPost(url, new AthenaBasicHttpRequestHead(iamUserToken),
                            JsonUtil.javaObjectToJsonString(empInfo), Map.class);
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                return false;
            }
            return true;
        } catch (Exception ex) {
            log.error(ex.getMessage());
            ex.printStackTrace();
            return false;
        }

    }

    private HttpHeaders getHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        return headers;
    }

    private void addLang(HttpHeaders headers, String iamUserToken) {
        headers.add("locale", AppRequestContext.getContextEntity().getLocale());
        headers.add("digi-middleware-auth-user", iamUserToken);
        headers.add("digi-middleware-auth-app", sysEnvConfig.getAppToken());
        headers.add("token", iamUserToken);
    }

    @Override
    public EocOrg getEocOrgTree(String iamUserToken) {
        String url = AppContext.getApiUrlSetting().getEocUrl()
                + "/api/eoc/v2/org/tree";
        ResponseEntity<DigiwinEocResult> responseEntity =
                httpService.doGet(url, new AthenaBasicHttpRequestHead(iamUserToken), new HashMap<>(), DigiwinEocResult.class);
        DigiwinEocResult result = responseEntity.getBody();
        if (result != null && result.isSuccess()) {
            return JsonUtil.objectToJavaObject(result.getData(), EocOrg.class);
        }
        return null;
    }
}