package com.digiwin.mobile.mobileuibot.proxy.esp.callback;

import com.digiwin.mobile.mobileuibot.model.db1.CallbackInfo;
import com.digiwin.mobile.mobileuibot.proxy.esp.callback.service.CallbackInfoRecordService;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 用于ESP全异步调用回调管理
 */
@Component
public class DigiwinEspCallbackManager {
    private static final ConcurrentHashMap<String, DigiwinEspCallback> callbacks = new ConcurrentHashMap<>();

    private static DigiwinEspCallbackManager instance;

    @Autowired
    private CallbackInfoRecordService callbackInfoRecordService;

    @PostConstruct
    public void init() {
        instance = this;
    }

    public static void registerCallback(String reqId, DigiwinEspCallback callback) {
        // 先查数据，如果有数据直接回调,后更新状态
        long startTime = System.currentTimeMillis(); // 记录开始时间
        long timeout = 2 * 60 * 1000; // 2分钟的超时时间（以毫秒为单位）
        while (true) {
            CallbackInfo callbackData = instance.callbackInfoRecordService.getCallbacksDataById(reqId);
            if (ObjectUtils.isNotEmpty(callbackData) && Objects.equals("pending",callbackData.getStatus())) {
                callback.onDataReceived(callbackData.getCallbackData());
                instance.callbackInfoRecordService.updateCallbackStatus(reqId, "completed",null);
                callbacks.remove(reqId);
                break;
            } else {
                if(!callbacks.containsKey(reqId)){
                    callbacks.put(reqId, callback);
                    instance.callbackInfoRecordService.insertCallbackData(reqId, "registered", "");
                }
            }
            // 检查是否超过超时时间
            if (System.currentTimeMillis() - startTime > timeout) {
                callback.onDataReceived("{}");
                break; // 超过，跳出循环
            }
            // 增加延迟，避免循环执行太快
            try {
                Thread.sleep(200);
            } catch (InterruptedException e) {
                break;
            }
        }
    }

    public static void notifyDataReceived(String reqId, String data) {
        DigiwinEspCallback callback = callbacks.get(reqId);
        if (callback != null) {
            callback.onDataReceived(data);
        }
        //map中没有的话直接去数据库查数据，有的话直接回掉，没有则插入数据
        CallbackInfo callbackData = instance.callbackInfoRecordService.getCallbacksDataById(reqId);
        if (ObjectUtils.isEmpty(callbackData)) {
            instance.callbackInfoRecordService.insertCallbackData(reqId, "pending", data);
        }else{
            instance.callbackInfoRecordService.updateCallbackStatus(reqId, "pending",data);
        }

    }

}
