package com.digiwin.mobile.mobileuibot.proxy.esp.callback.service;

import com.digiwin.mobile.mobileuibot.mapper.db1.EspCallbackDataRecordMapper;
import com.digiwin.mobile.mobileuibot.model.db1.CallbackInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;

@Service("callbackInfoRecordService")
public class CallbackInfoRecordServiceImpl implements CallbackInfoRecordService {

    @Autowired
    private EspCallbackDataRecordMapper espCallbackDataRecordMapper;

    @Override
    public CallbackInfo getCallbacksDataById(String reqId) {
        return espCallbackDataRecordMapper.getCallbacksDataById(reqId);
    }

    @Override
    public Boolean updateCallbackStatus(String reqId, String status,String data) {
        Map<String, Object> params = new HashMap<>();
        params.put("reqId", reqId);
        params.put("status", status);
        params.put("callbackData",data);
        params.put("updateTime", new Date());
        return espCallbackDataRecordMapper.updateCallbackStatus(params);
    }

    @Override
    public Boolean insertCallbackData(String reqId, String status, String data) {
        CallbackInfo callbackInfo = new CallbackInfo();
        callbackInfo.setReqId(reqId);
        callbackInfo.setCallbackData(data);
        callbackInfo.setStatus(status);
        callbackInfo.setCreateTime(new Date());
        callbackInfo.setUpdateTime(new Date());
        return espCallbackDataRecordMapper.insertCallbackData(callbackInfo);
    }
}
