package com.digiwin.mobile.mobileuibot.proxy.esp.config;

import com.digiwin.athena.esp.sdk.init.EspSdkInitialize;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.config.SysEnvConfig;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * esp-sdk初始化
 *
 * @author zhangjj
 * @date 2022/4/13 4:02 PM
 */
public class DigiwinEspConfig {

    private Logger logger = LoggerFactory.getLogger(DigiwinEspConfig.class);

    @Autowired
    private SysEnvConfig sysEnvConfig;

    public void init() {
        //敏捷问数下地跳过,ESP不下地
        if (BooleanUtils.isTrue(AppContext.getApiUrlSetting().getAgileDataPrivatization())) {
            return;
        }
        String themeMapUrl = AppContext.getApiUrlSetting().getThemeMapUrl();
        String espUrl = AppContext.getApiUrlSetting().getEspUrl();
        String mdcUrl = AppContext.getApiUrlSetting().getMdcUrl();
        String eocUrl = AppContext.getApiUrlSetting().getEocUrl();
//        themeMapUrl = themeMapUrl.substring(0, themeMapUrl.indexOf("/restful"));
        logger.debug("准备注册esp-sdk\nesp-url:{}\nthemeUrl:{}\neocUrl:{}",
                espUrl, themeMapUrl,
                AppContext.getApiUrlSetting().getEocUrl());
        EspSdkInitialize.initConfig(
                espUrl,
                mdcUrl,
                themeMapUrl,
                eocUrl);
        EspSdkInitialize.initLmcConfig(AppContext.getApiUrlSetting().getLmcUrl());
        EspSdkInitialize.enableEspRouting(true);
        // 与athena智驱中台使用相同token，但用移动的appid
        EspSdkInitialize.initAppConfig("athenamobile", sysEnvConfig.getAppToken());
//        EspSdkInitialize.initAppSecret(sysEnvConfig.getAppSecret());
//        EspSdkInitialize.setAppAuthExclude("IAM");

    }

}