package com.digiwin.mobile.mobileuibot.proxy.esp.model;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author wuyang
 */
@Data
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
@NoArgsConstructor
@AllArgsConstructor
public class DigiwinCustomerInfo implements Serializable {
    private static final long serialVersionUID = 2081870813583220011L;

    /**
     * 客户编号
     */
    private String customerNo;
    /**
     * 客户名称
     */
    private String customerName;
    /**
     * 客户简称
     */
    private String customerShortname;
    /**
     * 联系人编号
     */
    private String contactEmpNo;
    /**
     * 联系人名称
     */
    private String contactEmpName;
    /**
     * 联系电话
     */
    private String telephone;
    /**
     * email
     */
    private String email;
    /**
     * 地址
     */
    private String address;
    /**
     * 状态
     */
    private String manageStatus;
    /**
     * 备注
     */
    private String remark;
    /**
     * 业务员
     */
    private String salesman;
    /**
     * 业务员名称
     */
    private String salesmanName;
    /**
     * 所属部门
     */
    private String departmentNo;
    /**
     * 所属部门名称
     */
    private String departmentName;
    /**
     * 客戶等级
     */
    private String customerGrade;
    /**
     * 公司电话
     */
    private String companyTelNo;
    /**
     * 首次接触日期	yyyyMMdd
     */
    private Date firstContactDate;
    /**
     * 正式客户编号
     */
    private String formalCustomerNo;
    /**
     * 统一编号
     */
    private String uniformNumber;
    /**
     * 活跃度编号
     */
    private String activityNo;
    /**
     * 活跃度名称
     */
    private String activityName;
    /**
     * 是否为新客	true：是 false：否
     */
    private Boolean isNewCustomer;
    /**
     * 是否潜在成为正式	true.是；false.否
     */
    private Boolean isPotentialToBeFormal;
    /**
     * 转正式状态	1.未申请 2.已转ERP新客 3.已转ERP正式客
     */
    private String transferFormalStatus;
    /**
     * 云端营运公司编号
     */
    private String eocCompanyId;
    /**
     * 云端营运据点编号
     */
    private String eocSiteId;
    /**
     * 云端营运域编号
     */
    private String eocRegionId;
    /**
     * 客户类型
     */
    private DigiwinCustomerType customerType;
    /**
     * 联系人信息
     */
    private DigiwinCustomerContactPersonInfo customerContactPersonInfo;
    /**
     * 标签信息
     */
    private DigiwinCustomerTagInfo customerTagInfo;
    /**
     * 客户竞争对手信息
     */
    private DigiwinCustomerCompetitorInfo customerCompetitorInfo;
}
