package com.digiwin.mobile.mobileuibot.proxy.esp.model;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;


/**
 * @author wuyang
 */
@Data
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
@NoArgsConstructor
@AllArgsConstructor
public class DigiwinCustomerInfoRequest implements Serializable {
    private static final long serialVersionUID = 4524459418509604709L;

    /**
     * 客户编号(必填)
     */
    private String customerNo;
    /**
     * 客户性质	1.潜在2.正式3.全部 。不传默认全部
     */
    private String customerProperty;
    /**
     * 状态码
     */
    private String manageStatus;
    /**
     * 客户等级
     */
    private String customerGrade;
    /**
     * 查询日期	yyyyMMdd
     */
    private String queryDate;
    /**
     * 活跃度编号
     */
    private String activityNo;
    /**
     * 统一编号
     */
    private String uniformNumber;
}
