package com.digiwin.mobile.mobileuibot.proxy.esp.model;

import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.Map;

/**
 * esp接口响应异常类
 * 示例数据如下
 * {
 * "error": {
 * "rest_status_code": 502,
 * "message": "<html>\r\n<head><title>502 Bad Gateway</title></head>\r\n<body>\r\n<center><h1>502 Bad Gateway</h1></center>\r\n<hr><center>nginx</center>\r\n</body>\r\n<html>\r\n"
 * },
 * "errorCode": "P.ESP.300.0322",
 * "errorMessage": "EAI Response:远程服务发生例外",
 * "errorInstructors": {
 * "chainInfo": "ESP^3ef46721-c6d1-451f-a004-2e8a7c103344<<"
 * }
 * }
 *
 * @author Zaregoto
 * @date 2023/8/4 19:25
 */
@Data
@NoArgsConstructor
public class DigiwinEspErrorResponse {

    private Map<String, Object> error;
    private String errorCode;
    private String errorMessage;
    private Map<String, Object> errorInstructors;
}
