package com.digiwin.mobile.mobileuibot.proxy.esp.model;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.Data;

import java.util.Objects;
import java.util.Optional;

/**
 * esp接口响应类
 *
 * @author zhangjj
 * @date 2022/4/15 10:38 AM
 */
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
@Data
public class DigiwinEspResponse {

    public static final String RESP_CODE_OK = "0";

    public static final String RESP_CODE_ERROR = "-1";

    public static final String RESP_EMPTY = "EMPTY in API!!!";

    private DigiwinEspStdData stdData;

    /**
     * 获取API执行结果代码
     *
     * @return API执行结果代码。若无法正常获取，则返回RESP_CODE_ERROR值
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public String getStdDataExecutionCode() {
        return Optional.ofNullable(this.getStdData())
                .map(DigiwinEspStdData::getExecution)
                .map(DigiwinEspExecution::getCode).orElse(RESP_CODE_ERROR);
    }

    /**
     * 获取API执行结果描述文字
     *
     * @return API执行结果描述文字。若无法正常获取，则返回RESP_DESCRIPTION_EMPTY值
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public String getStdDataExecutionDescription() {
        return Optional.ofNullable(this.getStdData())
                .map(DigiwinEspStdData::getExecution)
                .map(DigiwinEspExecution::getDescription).orElse(RESP_EMPTY);
    }

    /**
     * 获取API执行结果消息
     *
     * @return API执行结果消息。若无法正常获取，则返回RESP_DESCRIPTION_EMPTY值
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public String getStdDataExecutionMessage() {
        return Optional.ofNullable(this.getStdData())
                .map(DigiwinEspStdData::getExecution)
                .map(DigiwinEspExecution::getMessage).orElse(RESP_EMPTY);
    }

    /**
     * 当应用API的响应资料不ok时，返回应用API响应的完整消息
     *
     * @return 应用API响应的完整消息
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public String getResponseFullDescriptionMsgWhenNotOK(String serviceProd, String serviceName, String parameterBodyJson) {
        return "Service [" + serviceName + "] NOT OK. Here is summary: \r\n"
                + "ServiceProd is: " + serviceProd + ", \r\n"
                + "RequestBody is: " + parameterBodyJson + ", \r\n"
                + "Execution code: " + this.getStdDataExecutionCode() + ", \r\n"
                + "Execution description: " + this.getStdDataExecutionDescription() + ", \r\n"
                + "Execution message: " + this.getStdDataExecutionMessage();
    }

    /**
     * 判断应用API的响应资料是否ok
     *
     * @param respDataKey 响应的业务资料key
     * @return true-表示响应资料ok，false-表示响应资料不ok，需要调用方抛出异常
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public Boolean isRespOk(String respDataKey) {
        return Objects.equals(RESP_CODE_OK, this.getStdDataExecutionCode())
                && this.getStdData() != null
                && this.getStdData().getExecution() != null
                && this.getStdData().getParameter() != null
                && this.getStdData().getParameter().get(respDataKey) != null;
    }

    /**
     * 判断应用API的响应资料是否ok
     *
     * @return true-表示响应资料ok，false-表示响应资料不ok，需要调用方抛出异常
     */
    @JsonProperty(access = JsonProperty.Access.WRITE_ONLY)
    @JSONField(serialize = false)
    public Boolean isRespOk() {
        return Objects.equals(RESP_CODE_OK, this.getStdDataExecutionCode())
                && this.getStdData() != null
                && this.getStdData().getExecution() != null
                && this.getStdData().getParameter() != null;
    }
}
