package com.digiwin.mobile.mobileuibot.proxy.esp.model;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.Data;

/**
 * 历史单价
 *
 * @author zhangjj
 * @date 2022/7/21 11:44
 */
@Data
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class DigiwinOrderPriceData {

    /**
     * 品号
     */
    private String itemCode;
    /**
     * 品名
     */
    private String itemName;
    /**
     * 规格
     */
    private String itemSpec;
    /**
     * 特征码
     */
    private String itemFeatureCode;
    /**
     * 特征码规格
     */
    private String itemFeatureSpec;
    /**
     * WAFER型号
     */
    private String waferNo;
    /**
     * 供应商编号
     */
    private String supplierCode;
    /**
     * 供应商简称
     */
    private String supplierName;
    /**
     * 供应商全称
     */
    private String supplierFullName;
    /**
     * 币种
     */
    private String currencyCode;
    /**
     * 含税
     */
    private Boolean taxInclude;
    /**
     * 采购日期
     */
    private String purchaseDate;
    /**
     * 采购单价
     */
    private Double purchasePrice;
    /**
     * 计价单位编号
     */
    private String priceUnitCode;
    /**
     * 计价单位名称
     */
    private String priceUnitName;
}
