package com.digiwin.mobile.mobileuibot.proxy.esp.model;

import com.digiwin.mobile.mobileuibot.proxy.zhilink.TimeSlot;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 运输主要信息
 *
 * @author wuyang
 */
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
@Data
@NoArgsConstructor
@AllArgsConstructor
public class DigiwinTransportResponse implements Serializable {
    private static final long serialVersionUID = -8207740374876930468L;

    /**
     * 运单号
     */
    private String transportNo;

    /**
     * 发货人
     */
    private String shipperName;
    /**
     * 发货地址
     */
    private String deliveryAddress;
    /**
     * 发货人联系方式
     */
    private String shipperMobile;
    /**
     * 收货人
     */
    private String receiverName;
    /**
     * 发货城市
     */
    private String receiptAddress;
    /**
     * 收货人联系方式
     */
    private String receiverMobile;
    /**
     * 月台编号
     */
    private String platformNo;
    /**
     * 月台名称
     */
    private String platformName;
    /**
     * 预约送货日期
     */
    private String appointmentDeliveryDate;
    /**
     * 时间段
     */
    private List<TimeSlot> timeSlot;

    /**
     * (发车状态 0-待发车 1-已发车)
     */
    private Integer departStatus;
    /**
     * 发货日期
     */
    private String departDate;
    /**
     * 收货日期
     */
    private String receiptDate;

    /**
     * 到达状态 0-待到达 1-已到达待签收 2-已签收
     */
    private String arrivalStatus;

    /**
     * 是否到达电子围栏区域范围 0-未到达 1-已到达
     */
    private String electronicFenceStatus;

    /**
     * 当前位置经度
     */
    private String currentLongitude;

    /**
     * 当前位置纬度
     */
    private String currentLatitude;

    public String getTimeSlots(List<TimeSlot> timeSlots) {
        String value = "";
        if (timeSlots != null && timeSlots.size() > 0) {
            for (int i = 0; i < timeSlots.size(); i++) {
                TimeSlot timeSlot = timeSlots.get(i);
                value = value + timeSlot.getAppointmentDeliveryTimeStart() + "~" + timeSlot.getAppointmentDeliveryTimeEnd();
                if (i < timeSlots.size() - 1) {
                    value += "、";
                }
            }
        }
        return value;
    }
}
