package com.digiwin.mobile.mobileuibot.proxy.esp.model;

import com.digiwin.mobile.mobileuibot.core.strategy.modelbuild.custom.apc.personnel.PersonnelStateEnum;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

/**
 * 功能: 人员信息
 *
 * @author: wjw
 * @date: created at 2023/2/8
 */
@Data
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class WoOpReportInfo implements Serializable {

    private PersonnelStateEnum stateEnum;

    private String opSeq;

    private String workstationNo;

    private String docTypeNo;

    private String workstationName;

    private String planSource;

    private String sourceOperation;

    private Double dispatchQty;

    private String productionStatus;

    private String checkInDatetime;

    private String subOpNo;

    private String subOpName;

    private String subOpSeq;

    private String eocCompanyId;

    private String eocSiteId;

    private String reportWorkHoursId;

    /**
     * 班组编号
     */
    private String teamNo;
    /**
     * 班组名称
     */
    private String teamName;
    /**
     * 报工人员编码
     */
    private String reporterNo;
    /**
     * 报工人员名称
     */
    private String reporterName;

// ---------------获取本部门已上线人员信息  独有字段--------------------
    /**
     * 工单单号/製令號碼
     */
    private String woNo;
    /**
     * 生产批号/生產批號
     */
    private String plotNo;
    /**
     * 工艺编码/製程編碼
     */
    private String opNo;
    /**
     * 工艺名称/製程編碼
     */
    private String opName;
    /**
     * 计划批号/計畫批號
     */
    private String planLotNo;

    /**
     * 产品品名
     */
    private String itemName;

    /**
     * 产品规格
     */
    private String itemSpec;

    /**
     * 区域编号/區域編號
     */
    private String areaNo;
    /**
     * 区域名称/區域名稱
     */
    private String areaName;
    /**
     * 项目编号/專案編號
     */
    private String projectNo;
    /**
     * 项目名称/專案名稱
     */
    private String projectName;

// ---------------获取本部门除外报工人员信息  独有字段--------------------
    /**
     * yyyy-MM-dd HH:mm:ss
     */
    private Date startTime;
    /**
     * yyyy-MM-dd HH:mm:ss
     */
    private Date endTime;
    /**
     * 除外回报原因编号
     */
    private String exceptNo;
    /**
     * 除外回报原因名称
     */
    private String exceptName;
    /**
     * 备注
     */
    private String remark;

// ---------------获取本部门已上线合并单号信息  独有字段--------------------
    /**
     * 合并单号
     */
    private String mergeNo;

    /**
     * 主管否 true.是；false.否
     */
    private boolean isSupervisor;

    /**
     * 客户编号
     */
    private String customerNo;

    /**
     * 客户编号
     */
    private String customerName;

    /**
     * 支援人员编号
     */
    private String supporterNo;

    /**
     * 支援人员名称
     */
    private String supporterName;

    /**
     * 总工时
     */
    private String totalLaborHours;

    /**
     * 最后上线时间
     */
    private String latestCheckInDatetime;

    /**
     * 支援开始日期
     */
    private String supportDateStart;

    /**
     * 支援结束日期
     */
    private String supportDateEnd;

    /**
     * 支援完成
     */
    private Boolean supporterComplete;

    /**
     * 班组信息，支援Tab需要，因为支援的teamNo和teamName是多个，逗号分隔，而且去重，不知道对应编号和名称的关系
     */
    private List<TeamInfo> teamList;

    @Data
    @JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
    public static class TeamInfo {
        /**
         * 班组编号
         */
        private String teamNo;
        /**
         * 班组名称
         */
        private String teamName;
    }
}
