package com.digiwin.mobile.mobileuibot.proxy.esp.model;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wuyang
 * 工时重叠资料/已上线未下线资料的实体类
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class WorkHoursOverlap implements Serializable {
    private static final long serialVersionUID = -7200100459127299828L;

    /**
     * 工单单别
     */
    private String docTypeNo;
    /**
     * 工单单号
     */
    private String woNo;
    /**
     * 生产批号
     */
    private String plotNo;
    /**
     * 工序
     */
    private String opSeq;
    /**
     * 工艺编码
     */
    private String opNo;
    /**
     * 工艺名称
     */
    private String opName;
    /**
     * 子工序
     */
    private String subOpSeq;
    /**
     * 子工艺编码
     */
    private String subOpNo;
    /**
     * 子工艺名称
     */
    private String subOpName;
    /**
     * 上线时间	yyyyMMddHHmmss
     */
    private String checkInDatetime;
    /**
     * 下线时间	yyyyMMddHHmmss
     */
    private String checkOutDatetime;
    /**
     * 项目号
     */
    private String projectNo;
    /**
     * 项目名称
     */
    private String projectName;
    /**
     * 计划批号
     */
    private String planLotNo;

}
