package com.digiwin.mobile.mobileuibot.proxy.esp.model;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 在途宝的区域
 *
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class ZtbArea implements Serializable {


    private static final long serialVersionUID = 5114115517946856151L;
    /**
     * 区域id
     */
    private String id;
    /**
     * 区域上层id
     */
    private String parentId;
    /**
     * 区域层级
     */
    private String lvl;
    /**
     * 区号
     */
    private String cityCode;
    /**
     * 区域名称
     */
    private String name;
    /**
     * 区域简称
     */
    private String shortName;

}
