package com.digiwin.mobile.mobileuibot.proxy.esp.model;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author wuyang
 * @desc 在途宝装车数量
 * @date 20230303
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class ZtbCargoUnloading implements Serializable {
    private static final long serialVersionUID = -6937581216332972098L;

    /**
     * 品号
     */
    private String itemNo;
    /**
     * 品名
     */
    private String itemName;
    /**
     * 规格
     */
    private String itemSpec;
    /**
     * 物料数量
     */
    private String itemQty;
    /**
     * 单位
     */
    private String itemUnit;
    /**
     * 应发数量/未装车数量
     */
    private String unLoadingQty;
    /**
     * 装车数量
     */
    private String transportQty;
    /**
     * 单位编号
     */
    private String unitNo;
    /**
     * 单位名称
     */
    private String unitName;
    /**
     * 拒绝类型
     */
    private String rejectType;
    /**
     * 拒收类型的名称
     */
    private String rejectTypeName;
    /**
     * 待收货数量
     */
    private String unReceiptQty;
    /**
     * 已收货数量
     */
    private String receiptQty;
    /**
     * 已拒收数量
     */
    private String rejectQty;
    /**
     * 运单号
     */
    private String transportNo;
    /**
     * 运单项次
     */
    private String transportSeq;
    /**
     * 标签数量
     */
    private String barcode_num;
}
