package com.digiwin.mobile.mobileuibot.proxy.esp.model;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 在途宝的货物数量
 *
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class ZtbDeliveryLoadingCount implements Serializable {

    private static final long serialVersionUID = 1126385642002267928L;

    /**
     * 未装车数量
     */
    private String unloadItemCount;
    /**
     * 已装车数量
     */
    private String loadedItemCount;
}
