package com.digiwin.mobile.mobileuibot.proxy.esp.model;

import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 在途宝的地址簿
 *
 * @author wuyang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@JsonNaming(PropertyNamingStrategy.SnakeCaseStrategy.class)
public class ZtbUserAddress implements Serializable {

    private static final long serialVersionUID = -6859732843546917802L;
    /**
     * 地址ID
     */
    private String addressId;
    /**
     * 区域id
     */
    private String areaId;
    /**
     * 地址真实code码
     */
    private String adCode;
    /**
     * 完整地址
     */
    private String completeAddress;
    /**
     * 详细地址
     */
    private String detailAddress;
    /**
     * 用户id
     */
    private String userId;
    /**
     * 用户名称
     */
    private String userName;
    /**
     * 用户手机号
     */
    private String userPhone;
    /**
     * 省
     */
    private String province;
    /**
     * 市
     */
    private String city;
    /**
     * 区
     */
    private String area;

}
