package com.digiwin.mobile.mobileuibot.proxy.esp.service;

import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.mobile.mobileuibot.api.ApiRequestPosition;
import com.digiwin.mobile.mobileuibot.printer.model.AbiReportAsyncExport;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectTaskInfo;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.*;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZTBDriverVehicle;

import java.util.List;
import java.util.Map;

/**
 * esp接口
 *
 * @author zhangjj
 * @date 2022/4/14 2:16 PM
 */
public interface DigiwinEspProxyService {

    /**
     * 异步发起esp请求(通用接口-同步调用)
     *
     * @param tenantId       租户id
     * @param locale         语言别
     * @param serviceProd    服务提供方
     * @param serviceName    API名称
     * @param headers        请求headers
     * @param bodyJsonString 请求body  （传std_data.parameter里的内容即可）
     * @return
     */
    ResponseModel invokeRestSync(String tenantId,
                                 String locale,
                                 String serviceProd,
                                 String serviceName,
                                 Map<String, String> headers,
                                 String bodyJsonString);

    /**
     * 异步发起esp请求(通用接口-异步调用)
     *
     * @param tenantId       租户id
     * @param locale         语言别
     * @param serviceProd    服务提供方
     * @param serviceName    API名称
     * @param headers        请求headers
     * @param bodyJsonString 请求body  （传std_data.parameter里的内容即可）
     * @return
     */
    ResponseModel invokeRestFasync(String tenantId,
                                   String locale,
                                   String serviceProd,
                                   String serviceName,
                                   Map<String, String> headers,
                                   String bodyJsonString);

    /**
     * 查询是否有项目落后
     *
     * @param tenantId
     * @param locale
     * @return
     */
    boolean checkProjectBackward(String iamUserToken, String tenantId, String locale);

    /**
     * 查询是否有项目应收逾期
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    boolean checkProjectAmountOverdue(String iamUserToken, String tenantId, String locale);

    /**
     * 批量获取图纸资讯
     *
     * @param cardInfoRequestList
     * @param userToken
     * @param tenantId
     * @param locale
     * @return
     */
    List<Map<String, Object>> getCardInfo(List<Map<String, Object>> cardInfoRequestList, String userToken,
                                          String tenantId, String locale);

    /**
     * 获取EOC(鼎捷云端端组织)符合授权及用户关联之员工信息
     *
     * @param projectMemberInfoRequestList
     * @param userToken
     * @param tenantId
     * @param locale
     * @return
     */
    List<Map<String, Object>> getEmployeeInfoByProjectNo(List<Map<String, Object>>
                                                                 projectMemberInfoRequestList, String userToken, String tenantId, String locale);

    /**
     * 依传入的日期及其它条件取得人力资源负荷信息
     *
     * @param humanResourceLoadRequestList
     * @param userToken
     * @param tenantId
     * @param locale
     * @return
     */
    List<Map<String, Object>> getHumanResourceLoad(List<Map<String, Object>>
                                                           humanResourceLoadRequestList, String userToken, String tenantId, String locale);

    /**
     * 获取项目中控台关键路径任务task_no
     * API：project.critical.path.info.get
     *
     * @param iamUserToken
     * @param projectNo
     * @param tenantId
     * @param locale
     * @return
     */
    List<String> getProjectCriticalPath(String iamUserToken, String projectNo, String tenantId, String locale);

    /**
     * 任务取得
     * API：bm.pisc.task.get
     * 云管家手动报工获取前置任务依赖关系查询
     *
     * @param iamUserToken
     * @param projectNo
     * @param taskNo
     * @param tenantId
     * @param locale
     * @return
     */
    List<String> getTaskPiscInfo(String iamUserToken, String projectNo, String taskNo, String tenantId, String locale);

    /**
     * 获取任务卡详情
     *
     * @param iamUserToken
     * @param projectNo
     * @param taskNo
     * @param tenantId
     * @param locale
     * @return
     */
    List<PccProjectTaskInfo> getTaskInfo(String iamUserToken, String projectNo, String taskNo,
                                         String tenantId, String locale);

    /**
     * 获取项目中控台关键路径任务task_no
     * API：bm.pisc.project.critical.path.get
     *
     * @param iamUserToken
     * @param projectNo
     * @param tenantId
     * @param locale
     * @return
     */
    List<String> getNewProjectCriticalPath(String iamUserToken, String projectNo, String tenantId, String locale);

    /**
     * 根据日期参数获取当前项目集合的剩余人力
     *
     * @param itemInfo
     * @param dateId
     * @param tenantId
     * @param locale
     * @param iamUserToken
     * @return
     */
    List<Map<String, Object>> getHumanResourceLoadByDateId(List<String> itemInfo, String dateId, String tenantId, String locale, String iamUserToken);


    /**
     * 项目工单生产信息处理
     * 依据条件 (项目编号、任务编号等) 调用稳态服务，取得工单生产进度信息(如状态、完成率...等等)
     * API：project.wo.production.info.process
     * <p>
     * 任务类型=MES.MES
     *
     * @param eocSiteId
     * @param eocCompanyId
     * @param taskInfoList
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    List<Map<String, Object>> getProjectWoProductionInfoProcess(String eocSiteId, String eocCompanyId,
                                                                List<PccProjectTaskInfo> taskInfoList,
                                                                String iamUserToken, String tenantId, String locale,
                                                                String processStatus);

    /**
     * 其他任务类型
     * 获取PCC尾阶段任务详情-项目单据信息处理
     * API：project.doc.info.process
     *
     * @param eocSiteId
     * @param eocCompanyId
     * @param taskInfoList
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param processStatus
     * @return
     */
    List<Map<String, Object>> getProjectDocInfoProcess(String eocSiteId, String eocCompanyId,
                                                       List<PccProjectTaskInfo> taskInfoList,
                                                       String iamUserToken, String tenantId, String locale,
                                                       String processStatus);

    /**
     * 取得任务信息
     * 从敏态DB取得任务数据资料(pcc_task 任务明细档)
     * <p>
     * 一般任务类型，任务类型=ORD
     * 获取PCC尾阶段任务详情-取得任务信息
     * API：task.info.get
     *
     * @param eocSiteId
     * @param eocCompanyId
     * @param projectDocInfoRequestList
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    List<Map<String, Object>> getTaskInfo(String eocSiteId, String eocCompanyId,
                                          List<PccProjectTaskInfo> projectDocInfoRequestList,
                                          String iamUserToken, String tenantId, String locale, String processStatus);


    /**
     * 取得任务信息
     * API:bm.pisc.attachment.join.relation.get
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param processStatus
     * @param projectNo
     * @return
     */
    List<Map<String, Object>> getBmPiscAttachmentJoinRelation(String eocSiteId, String eocCompanyId,
                                                              String iamUserToken, String tenantId,
                                                              String locale, String processStatus,
                                                              String projectNo, String taskNo);

    /**
     * 取得工作项资料.
     * 依据条件(项目编号 or 外显项目编号、任务编号、状态)，从PLM取得工作项单据等相关资料
     * API：work.item.data.get
     *
     * @param eocSiteId
     * @param eocCompanyId
     * @param taskInfoList
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param processStatus
     * @return
     */
    List<Map<String, Object>> getWorkItemData(String eocSiteId, String eocCompanyId, List<PccProjectTaskInfo> taskInfoList,
                                              String iamUserToken, String tenantId, String locale, String processStatus);


    /**
     * 获取项目任务完成率资料.
     * 根据入参PCC项目、任务编号条件，从PLM取得PLM项目下任务完成率、预计与实际开始、结束日期等等相关资料 (PLM项目=pcc.项目+pcc.任务)
     * API：project.task.complete.rate.data.get
     *
     * @param eocSiteId
     * @param eocCompanyId
     * @param taskInfoList
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    List<Map<String, Object>> getProjectTaskCompleteRateData(String eocSiteId, String eocCompanyId, List<PccProjectTaskInfo> taskInfoList,
                                                             String iamUserToken, String tenantId, String locale);


    /**
     * 通过采购单号获取工厂内云端营运据点编号信息(eoc_site_id)
     *
     * @param purchaseNo
     * @param companyId
     * @param iamUserToken
     * @param tenantId
     * @param locale
     */
    String getEocSiteIdByPurchaseNo(String purchaseNo,
                                    String companyId,
                                    String iamUserToken,
                                    String tenantId,
                                    String locale);

    /**
     * 通过品号获取类别库存资料
     *
     * @param itemNo
     * @param companyId
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    List<DigiwinItemCategory> getCategoryByItemNo(String itemNo,
                                                  String companyId,
                                                  String iamUserToken,
                                                  String tenantId,
                                                  String locale);

    /**
     * 获取品号类别库存资料
     *
     * @param eocSiteId
     * @param itemCategoryList
     * @param companyId
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    List<DigiwinInventoryData> getInventoryByCategory(String eocSiteId,
                                                      List<DigiwinItemCategory> itemCategoryList,
                                                      String companyId,
                                                      String iamUserToken,
                                                      String tenantId,
                                                      String locale);

    /**
     * 获取历史单价
     *
     * @param itemCodeList
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    List<DigiwinOrderPriceData> getLatelyPriceListByItemCode(List<String> itemCodeList, String iamUserToken, String tenantId, String locale);

    /**
     * 获取客户基础资料
     *
     * @param customerNos
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    List<Map<String, Object>> getCustomerInfoByNo(List<String> customerNos, String iamUserToken,
                                                  String tenantId, String locale);

    /**
     * 获取应收账款
     *
     * @param customerNos
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param eocCompanyId
     * @return
     */
    List<Map<String, Object>> getReceivableByNo(List<String> customerNos, String iamUserToken,
                                                String tenantId, String locale, String eocCompanyId);

    /**
     * 处理与校验除外报工信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    Map<String, Object> exceptReportVerifyInfoProcess(String iamUserToken,
                                                      String tenantId, String locale, Map<String, Object> params);

    /**
     * 处理除外报工信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    Boolean exceptReportInfoProcess(String iamUserToken,
                                    String tenantId, String locale, Map<String, Object> params, List<Map<String, Object>> woOpReportData);

    /**
     * 获取ASN单头详情
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    Map<String, Object> getAsnHeader(String iamUserToken, String tenantId, String locale,
                                     Map<String, Object> params);

    /**
     * 获取个人车辆列表
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<Map<String, Object>> getDriverVehicle(String iamUserToken, String tenantId, String locale,
                                               Map<String, Object> params);

    /**
     * 获取电子栏位显示否
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    Boolean getElectronicFenceShowFlag(String iamUserToken, String tenantId, String locale,
                                       Map<String, Object> params);

    /**
     * 获取电子围栏工厂列表
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<Map<String, Object>> getElectronicFenceFactoryList(String iamUserToken, String tenantId, String locale,
                                                            Map<String, Object> params);

    /**
     * 获取个人车辆列表(用于货物装车场景)
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<Map<String, Object>> getDriverVehicleDetail(String iamUserToken, String tenantId, String locale,
                                                     Map<String, Object> params);

    /**
     * 新增个人车辆信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    Boolean addDriverVehicle(String iamUserToken, String tenantId, String locale,
                             Map<String, Object> params);

    /**
     * 修改个人车辆信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    Boolean updateDriverVehicle(String iamUserToken, String tenantId, String locale,
                                Map<String, Object> params);

    /**
     * 新增个人车辆信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    Boolean saveElectronicFence(String iamUserToken, String tenantId, String locale,
                                Map<String, Object> params);

    /**
     * 删除个人车辆信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param data
     * @return
     */
    Boolean deleteDriverVehicle(String iamUserToken, String tenantId, String locale,
                                Map<String, Object> data);

    /**
     * 获取ASN单身详情
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param page_no,page_size,use_has_next
     * @param parameter
     * @return
     */
    Map<String, Object> getAsnBody(String iamUserToken, String tenantId, String locale,
                                   Integer page_no, Integer page_size, Boolean use_has_next, Map<String, Object> parameter);

    /**
     * 获取发货单车辆信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param taskNo
     * @return
     */
    List<Map<String, Object>> getVehicleInfo(String iamUserToken, String tenantId, String locale,
                                             String taskNo, Boolean isLoadCar, String keyword);

    /**
     * 司機更新當前使用車輛
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    DigiwinEspStdData driverCurrentVehicleUpdate(String iamUserToken, String tenantId, String locale,
                                                 Map<String, Object> params);

    /**
     * 在途宝-任务提交
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param taskNo
     * @param status       1.扫码接单提交;2.货物出库提交; 3.货物装车;4.货物发车
     * @return
     */
    DigiwinEspStdData ztbSubmit(String iamUserToken, String tenantId, String locale, String taskNo, String status);

    /**
     * 在途宝-货物装车任务提交
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param cargoInformation
     * @param vehicleInfo
     * @return
     */
    DigiwinEspStdData ztbLoadingSubmit(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> cargoInformation,
                                       Map<String, Object> vehicleInfo);

    /**
     * 在途宝-加入租户并授权
     *
     * @param iamUserToken
     * @param locale
     * @return
     */
    DigiwinEspStdData ztbJsonTenant(String iamUserToken, String locale, String taskNo, String userId);

    /**
     * 通过项目ID批量获取项目
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param projectIds
     * @return
     */
    List<Map<String, Object>> getProjectsByIDs(String iamUserToken, String tenantId, String locale,
                                               List<String> projectIds);

    /**
     * 取得项目异常检讨信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param docInfos
     * @return
     */
    List<Map<String, Object>> getAbnormalReviewInfo(String iamUserToken, String tenantId, String locale,
                                                    List<Map<String, Object>> docInfos);

    /**
     * 取得枚举值信息(在途宝回去枚举数据)
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param schema
     * @return
     */
    List<DigiwinEspEnumerateResponse> getEnumerateInfo(String iamUserToken, String tenantId, String locale,
                                                       String schema);

    /**
     * 货物发车提交
     *
     * @return
     */
    DigiwinEspStdData cargoDepart(String iamUserToken, String tenantId, String locale,
                                  Map<String, Object> params);


    /**
     * 取得运输车辆信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param transportNo
     * @return
     */
    Map<String, Object> getTransportVehicleInfo(String iamUserToken, String tenantId, String locale,
                                                String transportNo);

    /**
     * 取得入厂安排信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param transportNo
     * @return
     */
    Map<String, Object> getTransportEntryArrangement(String iamUserToken, String tenantId, String locale,
                                                     String transportNo);

    /**
     * 取得运输主要信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param transportNo
     * @return
     */
    DigiwinTransportResponse getTransportMainInfo(String iamUserToken, String tenantId, String locale,
                                                  String transportNo);

    /**
     * 取得运输主要信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param transportNo
     * @return
     */
    Map<String, Object> getTransportMainInfoResponseMap(String iamUserToken, String tenantId, String locale,
                                                        String transportNo);

    /**
     * 排程信息更改--提交
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params       {
     *                     "platform_no" : "",
     *                     "platform_name" : "",
     *                     "appointment_delivery_date" : "",
     *                     "time_slot" :{
     *                     "appointment_delivery_time_start":"",
     *                     "appointment_delivery_time_end":""
     *                     },
     *                     "unloader_id": "",
     *                     "unloader_name": "",
     *                     "unloader_tool":"",
     *                     "plan_unload_time":""
     *                     }
     * @return
     */
    DigiwinEspStdData scheduleInfo(String iamUserToken, String tenantId, String locale,
                                   Map<String, Object> params);

    /**
     * 收货准备完成--提交
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param transportNo
     * @return
     */
    DigiwinEspStdData completeReceiptPreparationInfo(String iamUserToken, String tenantId, String locale,
                                                     String transportNo);

    /**
     * 收货准备--提交
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param transportNo
     * @param params
     * @return
     */
    DigiwinEspStdData receiptPreparationInfo(String iamUserToken, String tenantId, String locale,
                                             String transportNo, Map<String, Object> params);

    /**
     * 安排入厂工作--提交
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param transportNo
     * @param params
     * @return
     */
    DigiwinEspStdData transportComingSoonProcess(String iamUserToken, String tenantId, String locale,
                                                 String transportNo, Map<String, Object> params);

    /**
     * 可根据条件获取人员信息（不输入条件时，默认查全部）
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param param        用户id/姓名
     * @param params
     * @return
     */
    List<ZtbUserInfo> getUserInfo(String iamUserToken, String tenantId, String locale,
                                  String param, Integer pageNo, Integer pageSize,
                                  Map<String, String> params);

    /**
     * 在途宝-运输在途-获取送货排程
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    List<Map<String, Object>> getShippingSchedule(String iamUserToken, String tenantId, String locale, String transportNo);


    /**
     * 在途宝-运输在途-异常报警接口
     * abnormal.alert.check
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param transportNo
     * @return
     */
    DigiwinEspStdData abnormalAlertCheck(String iamUserToken, String tenantId, String locale, String transportNo);

    /**
     * 在途宝-运输在途-到达校验
     * abnormal.alert.check
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param transportNo
     * @return
     */
    DigiwinEspStdData validArrival(String iamUserToken, String tenantId, String locale, String taskNo, String transportNo, ApiRequestPosition position);


    /**
     * 取得运输货物信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param transportNo
     * @param pageNo
     * @param pageSize
     * @param useHasNext
     * @return
     */
    Map<String, Object> getTransportCargoInfo(String iamUserToken, String tenantId, String locale,
                                              String transportNo, Integer pageNo, Integer pageSize,
                                              Boolean useHasNext);

    /**
     * 运输在途-到达接口
     * cargo.arrival.info.process
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param transportNo
     * @return
     */
    DigiwinEspStdData cargoArrival(String arrivalType, String iamUserToken, String tenantId, String locale, String transportNo,
                                   String receiverName, String receiverMobile, ApiRequestPosition position);

    /**
     * 收货确认的提交按钮（包括拒收按钮）
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params{      transport_no  运输单号
     *                     is_reject_receipt 是否拒收
     *                     reject_reason  拒收原因
     *                     }
     * @return
     */
    DigiwinEspStdData confirmCargoReceiptInfo(String iamUserToken, String tenantId, String locale,
                                              Map<String, Object> params);

    /**
     * 取得预约送货日期
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param deliveryNo
     * @return
     */
    List<AppointmentDeliveryDate> getAppointmentDeliveryDate(String iamUserToken, String tenantId,
                                                             String locale, String deliveryNo);

    /**
     * 取得预约月台信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params       {
     *                     "delivery_no",
     *                     "appointment_delivery_date"
     *                     }
     * @return
     */
    List<UseAppointmentDeliveryPlatform> getAppointmentPlatformInfo(String iamUserToken, String tenantId,
                                                                    String locale, Map<String, Object> params);

    /**
     * 取得预约送货时间段
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params       {
     *                     "delivery_no",
     *                     "appointment_delivery_date"
     *                     "platform_no"
     *                     }
     * @return
     */
    List<CanAppointmentDeliveryTimeSlot> getAppointmentDeliveryTimeSlot(String iamUserToken, String tenantId,
                                                                        String locale, Map<String, Object> params);

    /**
     * 运输在途-获取转运车辆
     * old.driver.transport.twist.vehicle.info.get
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param transportNo
     * @return
     */
    List<Map<String, Object>> getTransportDriver(String iamUserToken, String tenantId, String locale, String transportNo);


    /**
     * 运输在途-旧司机转运提交
     * old.driver.transport.twist.info.process
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param transportNo
     * @param vehicleInfoId
     * @param position
     * @return
     */
    DigiwinEspStdData oldDriverProcess(String iamUserToken, String tenantId, String locale, String transportNo, String vehicleInfoId, ApiRequestPosition position);

    /**
     * 运输在途-预警消息处理提交
     * old.driver.transport.twist.info.process
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @param position
     * @return
     */
    DigiwinEspStdData commitDriverMsg(String iamUserToken, String tenantId, String locale, Map<String, Object> params, ApiRequestPosition position);


    /**
     * 运输在途-新司机转运提交
     * new.driver.transport.twist.info.process
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param transportNo
     * @param vehicleInfoId
     * @return
     */
    DigiwinEspStdData newDriverProcess(String iamUserToken, String tenantId, String locale, String transportNo, Object vehicleInfoId);

    /**
     * 取得任务运输位置信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param taskNo
     * @param isArrival
     * @return
     */
    List<TransportList> getTaskTransportPositionInfo(String iamUserToken, String tenantId, String locale, String taskNo, Boolean isArrival);

    /**
     * 处理工单工艺报工人员上线资讯，依据数据来源走不同流程写入报工数据与制令状态
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<Map<String, Object>> woOpReportCheckInInfo(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params);

    /**
     * 判断当前登录人 是否是部门主管
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param eocCompanyId
     * @param eocSiteId
     * @return
     */
    Boolean isDeptDirector(String iamUserToken, String tenantId, String locale, String eocCompanyId, String eocSiteId);

    Boolean isDeptDirector(List<PersonnelDutyResp> list);

    /**
     * 获取当前登录人 人员职能
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param eocCompanyId
     * @param eocSiteId
     * @return
     */
    List<PersonnelDutyResp> personnelDutyGet(String iamUserToken, String tenantId, String locale,
                                             String eocCompanyId, String eocSiteId);

    /**
     * 获取主管下组员列表，包含自己
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param eocCompanyId
     * @param eocSiteId
     * @return
     */
    List<Map<String, Object>> currentTeamPersonnelInfoGet(String iamUserToken, String tenantId, String locale,
                                                          String eocCompanyId, String eocSiteId);

    /**
     * 获取主管下组员列表，包含自己
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @param headerParams
     * @return
     */
    List<Map<String, Object>> teamPersonnelInfoGet(String iamUserToken, String tenantId, String locale,
                                                   Map<String, Object> params, Map<String, Object> headerParams);

    /**
     * 获取地址区域列表信息(不分页)
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param parentId
     * @return
     */
    List<ZtbArea> getAreaList(String iamUserToken, String tenantId, String locale,
                              String parentId);

    /**
     * 获取用户地址列表
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params       "pageNo": 页码
     *                     "pageSize": 页面大小
     * @return
     */
    List<ZtbUserAddress> getuserAddressList(String iamUserToken, String tenantId, String locale,
                                            Map<String, Object> params);

    /**
     * 新增用户地址信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    Boolean createUserAddress(String iamUserToken, String tenantId, String locale,
                              Map<String, Object> params);

    /**
     * 删除用户地址信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param addressId
     * @return
     */
    Boolean deleteUserAddress(String iamUserToken, String tenantId, String locale,
                              String addressId);

    /**
     * 更新用户地址信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    Boolean updateUserAddress(String iamUserToken, String tenantId, String locale,
                              Map<String, Object> params);

    /**
     * 获取用户地址详情
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param addressId
     * @return
     */
    Map<String, Object> getUserAddress(String iamUserToken, String tenantId, String locale,
                                       String addressId);

    /**
     * 获取待装车已装车状态对应数量
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param taskNo
     * @return
     */
    ZtbDeliveryLoadingCount getDeliveryLoadingCount(String iamUserToken, String tenantId, String locale,
                                                    String taskNo);

    /**
     * 获取未装车货物信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param taskNo
     * @return
     */
    List<ZtbCargoUnloading> getDeliveryUnloadingList(String iamUserToken, String tenantId, String locale,
                                                     String taskNo);

    /**
     * 查询已装车车辆列表
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param taskNo
     * @return
     */
    List<ZTBDriverVehicle> getDeliveryLoadedCarList(String iamUserToken, String tenantId, String locale,
                                                    String taskNo);

    /**
     * 查询已装车车辆信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param transportNo
     * @return
     */
    List<ZtbCargoUnloading> getDeliveryLoadedItemList(String iamUserToken, String tenantId, String locale,
                                                      String transportNo);

    /**
     * 判断是否是司机角色
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param userId
     * @return
     */
    Boolean driverRoleValid(String iamUserToken, String tenantId, String locale, String userId);

    /**
     * 获取本部门已上线人员信息
     * wo.op.report.personnel.checked.in.info.get
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param eocCompanyId
     * @param eocSiteId
     * @return
     */
    List<WoOpReportInfo> woOpReportPersonnelCheckedInInfoGet(String iamUserToken, String tenantId, String locale,
                                                             String eocCompanyId, String eocSiteId);

    /**
     * 获取本部门未上线人员信息
     * wo.op.report.personnel.not.check.in.info.get
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param eocCompanyId
     * @param eocSiteId
     * @return
     */
    List<WoOpReportInfo> woOpReportPersonnelNotCheckInInfoGet(String iamUserToken, String tenantId, String locale,
                                                              String eocCompanyId, String eocSiteId);

    /**
     * 获取本部门除外报工人员信息
     * wo.op.report.personnel.except.info.get
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param eocCompanyId
     * @param eocSiteId
     * @return
     */
    List<WoOpReportInfo> woOpReportPersonnelExceptInfoGet(String iamUserToken, String tenantId, String locale,
                                                          String eocCompanyId, String eocSiteId);

    /**
     * 获取请求支援信息
     * request.support.info.get
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param eocCompanyId
     * @param eocSiteId
     * @return
     */
    List<WoOpReportInfo> requestSupportInfoGet(String iamUserToken, String tenantId, String locale,
                                               String eocCompanyId, String eocSiteId);

    /**
     * 扫描车辆码生成货运单的接口
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    Map<String, Object> taskTransportVehicleCodeScan(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * OCR识别车牌后生成货运单的接口
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    Map<String, Object> taskTransportOcrScan(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 扫描货物码接口
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<ZtbCargoUnloading> taskTransportBarcodeScan(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 更换货运单车辆
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    Map<String, Object> changeTaskTransportVehicle(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 完成装车
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    Map<String, Object> submitTaskTransportLoading(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 收货界面收货状态对应数量接口
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param transportNo
     */
    List<ZtbTransportReceiptStatusCount> getTransportReceiptStatusCount(String iamUserToken, String tenantId, String locale, String transportNo);

    /**
     * 收货界面对应收货状态的物料信息接口
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<ZtbCargoUnloading> getTransportReceiptItemInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 异常报警提交接口
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    Boolean transportAbnormalAlarmProcess(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 手动项目发起任务单提交
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    Boolean deliveryStartManualSubmit(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 扫描ASN单子发起任务单提交
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    Boolean deliveryHeadInfoSubmit(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 回单签字提交
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    Boolean transportPaperReceiptSubmit(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 获取在途宝的web端url
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params       "module_type": "1/2   1:注册 2:看板"
     * @return
     */
    String getSrmLoadingWebUrl(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 扫描来源单生成进场物流
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param sourceNo
     * @return
     */
    Map<String, Object> getDeliverySourceDetail(String iamUserToken, String tenantId, String locale, String sourceNo);


    /**
     * 扫描来源单生成进场物流
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param transport_no
     * @return
     */
    Map<String, Object> validTransportArrival(String iamUserToken, String tenantId, String locale, String transport_no);


    /**
     * 获取运单扫码收货记录
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param transport_no
     * @return
     */
    List<Map<String, Object>> getTransportReceive(String iamUserToken, String tenantId, String locale, String transport_no);

    /**
     * 收货方仓管员扫码签收
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param transport_no
     * @return
     */
    Map<String, Object> scanTransportToReceive(String userId, String iamUserToken, String tenantId, String locale, String transport_no);

    /**
     * 取得工单工艺报工待处理异常信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<Map<String, Object>> getWoOpReportWaitProcessAbnormalInfo(String iamUserToken, String tenantId,
                                                                   String locale, Map<String, Object> params);

    /**
     * 获取当前班组信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<Map<String, Object>> getCurrentTeamInfo(String iamUserToken, String tenantId,
                                                 String locale, Map<String, Object> params);

    /**
     * 取得工单工艺支援需求开窗信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params       班组工号 team_no 和班组名称 team_name
     * @return
     */
    List<Map<String, Object>> getWoOpSupportDemandWindowsInfo(String iamUserToken, String tenantId,
                                                              String locale, Map<String, Object> params);

    /**
     * 取得工单工艺请求支援审核信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<Map<String, Object>> getWoOpRequestSupportApproveInfo(String iamUserToken, String tenantId,
                                                               String locale, Map<String, Object> params);

    /**
     * 获取问题供应商信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param supplierSource ERP/IAM,不传默认IAM
     * @return
     */
    List<Map<String, Object>> getInfoSupplierQuestion(String iamUserToken, String tenantId,
                                                      String locale, String supplierSource);

    /**
     * 获取第三方项目信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<Map<String, Object>> getProjectInfo(String iamUserToken, String tenantId,
                                             String locale, Map<String, Object> params);

    /**
     * 席位与班组派工机制-未生效
     * 获取场域区域工单工艺信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<Map<String, Object>> getLayoutAreaWoOpInfo(String iamUserToken, String tenantId,
                                                    String locale, List<Map<String, Object>> params);

    /**
     * 席位与班组派工机制-生效
     * 获取场域区域工单工艺信息
     * wo.op.dispatch.area.space.detail.info.get
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    Map<String, Object> getWoOpDispatchAreaSpaceDetailInfo(String iamUserToken, String tenantId,
                                                           String locale, Map<String, Object> params);


    /**
     * 区域占用比例颜色的获取
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return List<MapObject>>
     * @author yanfeng
     */
    List<Map<String, Object>> getDispatchAreaSpaceColorInfo(String iamUserToken, String tenantId,
                                                            String locale, Map<String, Object> params);

    /**
     * 获取工单工艺派工信息
     * 获取工单的所有制程
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return List<MapObject>>
     * @author yanfeng bm.dsc.wo.op.dispatch.get
     */
    List<Map<String, Object>> getDispatchOpWoDscBmInfo(String iamUserToken, String tenantId,
                                                       String locale, Map<String, Object> params);

    /**
     * 取得工作站进度回馈资讯
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<Map<String, Object>> getWorkstationProgressFeedbackInfo(String iamUserToken, String tenantId,
                                                                 String locale, List<Map<String, Object>> params);

    /**
     * 取得工单工艺在线报工者信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<Map<String, Object>> getWoOpOnlineReporterInfo(String iamUserToken, String tenantId,
                                                        String locale, List<Map<String, Object>> params);

    /**
     * 退回报工异常结案
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<Map<String, Object>> returnWoOpReportAbnormalInfoClosecase(String iamUserToken, String tenantId,
                                                                    String locale, List<Map<String, Object>> params);

    /**
     * 退回报工异常结案
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    Boolean processWoOpReportAbnormalInfoClosecase(String iamUserToken, String tenantId,
                                                   String locale, List<Map<String, Object>> params);

    /**
     * 获取设备信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<Map<String, Object>> getEquipmentInfo(String iamUserToken, String tenantId,
                                               String locale, Map<String, Object> params);

    /**
     * 获取第三方项目阶段信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<Map<String, Object>> getProjectStageThirdPartyInfo(String iamUserToken, String tenantId,
                                                            String locale, Map<String, Object> params);

    /**
     * 获取工单工艺移转信息 (敏态)
     * 获取数量转移开窗数据
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<Map<String, Object>> getTransferQuantityInfo(String iamUserToken, String tenantId,
                                                      String locale, List<Map<String, Object>> params);

    /**
     * 获取工单下一道工艺信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<Map<String, Object>> getOpNextInfo(String iamUserToken, String tenantId,
                                            String locale, List<Map<String, Object>> params);

    /**
     * 获取工单工艺报工数量信息
     * wo.op.report.qty.info.get
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<Map<String, Object>> getWoOpReportQtyInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params);


    /**
     * 更新领料通知信息
     * ca.cim.issue.notice.info.update
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    boolean updateIssueNoticeInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 更新报工任务信息
     * ca.cim.outsourcing.report.info.update
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    boolean updateOutSourceReportInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 处理工单工艺派工信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    Boolean woOpDispatchDataProcess(String iamUserToken, String tenantId,
                                    String locale, List<Map<String, Object>> params);

    /**
     * 提交保存司机坐标
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     */
    void saveDriverPosition(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 获取司机在途消息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     */
    List<Map<String, Object>> getTransportDriverMsg(String iamUserToken, String tenantId, String locale, Map<String, Object> params);


    /**
     * 处理工单工艺移转信息
     * 更新进度回报-数量转移
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    Map<String, Object> updateProcessInfoTransferReport(String iamUserToken, String tenantId,
                                                        String locale, List<Map<String, Object>> params);

    /**
     * 依工作中心推存符合班组
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<Map<String, Object>> getWoOpWorkstationRecommandTeamInfo(String iamUserToken, String tenantId,
                                                                  String locale,
                                                                  List<Map<String, Object>> params,
                                                                  Map<String, Object> headerParams);

    /**
     * 创建试制过程记录信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<Map<String, Object>> createTbdsTrialProductionReport(String iamUserToken, String tenantId, String locale,
                                                              List<Map<String, Object>> params);

    /**
     * 取得试制生产完工确认信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @param opSeq
     * @return
     */
    Integer getTbdsTrialProductionComplete(String iamUserToken, String tenantId, String locale,
                                           List<Map<String, Object>> params, String opSeq);

    /**
     * 取得试制生产完工确认信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<Map<String, Object>> getTbdsTrialProductionCompleteList(
            String iamUserToken, String tenantId, String locale,
            List<Map<String, Object>> params);

    /**
     * 取得试验报告信息 (检查结果确认需要从CTP拿/其他都是TBDS)
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param joinInspectionNo
     * @return
     */
    List<Map<String, Object>> getBmQmscTestPlanReportInfo(String iamUserToken, String tenantId,
                                                          String locale, String joinInspectionNo);

    /**
     * 北斗获取预计开工日最早的工艺
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param trialWoProcessList
     * @return
     */
    List<Map<String, Object>> getBmOpscEarliestStartDateTrialWoProcess(String iamUserToken, String tenantId,
                                                                       String locale, List<Map<String, Object>> trialWoProcessList);

    /**
     * 获取试制工单工艺
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param trialWoProcessList
     * @return
     */
    List<Map<String, Object>> getBmOpscTrialWoProcess(String iamUserToken, String tenantId,
                                                      String locale, List<Map<String, Object>> trialWoProcessList);

    /**
     * 北斗读取试制工单
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param trialWoList
     * @return
     */
    List<Map<String, Object>> getBmMoscTrialWo(String iamUserToken, String tenantId,
                                               String locale, List<Map<String, Object>> trialWoList);

    /**
     * 北斗试研---计量单位信息获取
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @return
     */
    List<Map<String, Object>> getBmUscMeasureUnitList(String iamUserToken, String tenantId,
                                                      String locale);

    /**
     * 取得應收帳款資料信息
     * aacr.ardata.get
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<Map<String, Object>> getAacrArdateInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 新增应收帐款处理历程信息
     * aacr.app.arprogress.create
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    List<Map<String, Object>> createAacrAppArProgress(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 取得生产日计划信息
     * bm.dpsc.working.day.plan.get
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return List<MapObject>>
     */
    List<Map<String, Object>> bmDpscWorkingDayPlan(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 取得生产日计划及派工信息
     * apc.working.day.plan.dispatch.info.get
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return List<MapObject>>
     */
    List<Map<String, Object>> getApcWorkingDayPlanDispatchInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * vss供应天眼更新
     * 库存预警任务卡信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @author yanfeng
     */
    void updateTaskWarnInvImsc(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params);

    /**
     * 获取工单工艺合并报工工时信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     */
    Map<String, Object> getWoOpMergeReportWorkHoursInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 获取工单工艺报工工时信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     */
    Map<String, Object> getWoOpReportWorkHoursInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 获取工单工艺报工工时信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     */
    Map<String, Object> getBmWrscWoOpReportWorkHours(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 获取eoc部门员工信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     */
    Map<String, Object> getQuestionEocDeptUserInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * 取得任务报工记录资讯
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     */
    List<Map<String, Object>> getTaskReportRecordInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * APC取得标准工时和实际工时
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params
     * @return
     */
    public Map<String, Object> getWoOpReportWorkHoursHistoryInfoGet(String iamUserToken, String tenantId, String locale, Map<String, Object> params);

    /**
     * APC获取派工信息一览表信息
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param eocCompanyId
     * @param params
     * @return
     */
    List<Map<String, Object>> getDispatchReportInfo(String iamUserToken, String tenantId, String locale, String eocCompanyId, List<Map<String, Object>> params);

    /**
     * Abi报表异步导出
     *
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param export
     * @return
     */
    Map<String, Object> getExportAbiUrlFasync(String iamUserToken, String tenantId, String locale, AbiReportAsyncExport export);
}
