package com.digiwin.mobile.mobileuibot.proxy.esp.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.esp.sdk.Invoker;
import com.digiwin.athena.esp.sdk.model.RequestModel;
import com.digiwin.athena.esp.sdk.model.ResponseModel;
import com.digiwin.mobile.mobileuibot.api.ApiRequestPosition;
import com.digiwin.mobile.mobileuibot.common.calculate.UUIDUtil;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.context.SpringContextHolder;
import com.digiwin.mobile.mobileuibot.common.datetime.DateTimeUtil;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.log.TraceIdUtil;
import com.digiwin.mobile.mobileuibot.common.logrecord.OuterRequestRecordManage;
import com.digiwin.mobile.mobileuibot.common.logrecord.RequestSourceEnum;
import com.digiwin.mobile.mobileuibot.common.map.MapUtil;
import com.digiwin.mobile.mobileuibot.common.string.StringUtil;
import com.digiwin.mobile.mobileuibot.core.layout.doublepattern.util.ModuleUtils;
import com.digiwin.mobile.mobileuibot.locale.service.LocaleService;
import com.digiwin.mobile.mobileuibot.model.db1.OuterRequestRecord;
import com.digiwin.mobile.mobileuibot.printer.model.AbiReportAsyncExport;
import com.digiwin.mobile.mobileuibot.proxy.atdm.model.pcc.PccProjectTaskInfo;
import com.digiwin.mobile.mobileuibot.proxy.esp.model.*;
import com.digiwin.mobile.mobileuibot.proxy.esp.service.DigiwinEspProxyService;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.DigiwinIamUserInfo;
import com.digiwin.mobile.mobileuibot.proxy.iam.service.DigiwinIamProxyService;
import com.digiwin.mobile.mobileuibot.proxy.zhilink.ZTBDriverVehicle;
import com.fasterxml.jackson.core.type.TypeReference;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.*;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;


/**
 * @author zhangjj
 * @date 2022/4/14 2:33 PM
 */
@Service
public class DigiwinEspProxyServiceImpl implements DigiwinEspProxyService {

    private Logger logger = LoggerFactory.getLogger(DigiwinEspProxyServiceImpl.class);

    private final static String FEATURE_WEEK = "0";
    private final static String FEATURE_MONTH = "1";

    @Autowired
    private OuterRequestRecordManage outerRequestRecordManage;
    @Autowired
    private LocaleService localeService;
    @Autowired
    private DigiwinIamProxyService iamProxyService;

    @Override
    public ResponseModel invokeRestSync(@NotNull String tenantId,
                                        @NotNull String locale,
                                        @NotNull String serviceProd,
                                        @NotNull String serviceName,
                                        @NotNull Map<String, String> headers,
                                        @NotNull String bodyJsonString) {
        RequestModel requestModel = new RequestModel();
        requestModel.setHostAcct("athena");
        requestModel.setHostProd("Athena-mobile");
        requestModel.setHostVer(AppContext.getApiUrlSetting().getApplicationVersion());
        requestModel.setHostId("Athena-mobile");
        requestModel.setLanguage(locale);
        requestModel.setTenantId(tenantId);
        requestModel.setHeaderMap(headers);
        JSONObject body = new JSONObject();
        JSONObject stdData = new JSONObject();
        body.put("std_data", stdData);
        stdData.put("parameter", JsonUtil.jsonStringToObject(bodyJsonString, JSONObject.class));
        requestModel.setBodyJsonString(JsonUtil.javaObjectToJsonString(body));
        requestModel.setServiceProd(serviceProd);
        requestModel.setServiceName(serviceName);
        long startTime = System.currentTimeMillis();
        try {
            ResponseModel responseModel = Invoker.invokeRestSync(requestModel);
            long endTime = System.currentTimeMillis();
            LocalDateTime logStartTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(startTime), ZoneId.systemDefault());
            LocalDateTime logEndTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(endTime), ZoneId.systemDefault());
            logger.info("========================使用esp-sdk请求接口拦截==========================" +
                            "\nserviceProd：{}" +
                            "\nserviceName：{}" +
                            "\nrequestTime: {}" +
                            "\nresponseTime：{}" +
                            "\nrunningTime：{}ms" +
                            "\nrequest body json string：{}" +
                            "\nresponse body json string：{}",
                    serviceProd, serviceName,
                    logStartTime, logEndTime, endTime - startTime,
                    requestModel.getBodyJsonString(), responseModel.getBodyJsonString());

            // 封装跟踪日志
            this.buildOuterRequestRecord(true, requestModel, responseModel, startTime, endTime, "");

            DigiwinEspErrorResponse espErrorResponse = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                    DigiwinEspErrorResponse.class);
            if (!ObjectUtils.isEmpty(espErrorResponse) && !ObjectUtils.isEmpty(espErrorResponse.getErrorCode())
                    && !ObjectUtils.isEmpty(espErrorResponse.getErrorMessage())) {
                throw new ServiceException("ESP errorCode: " + espErrorResponse.getErrorCode() +
                        ", errorMessage: " + espErrorResponse.getErrorMessage() +
                        ", errorInstructors: " + espErrorResponse.getErrorInstructors());
            }
            return responseModel;
        } catch (Exception e) {
            logger.error("使用esp-sdk请求接口异常，API名称：{}，请求body：{}", serviceName, bodyJsonString);
            long endTime = System.currentTimeMillis();
            // 封装跟踪日志
            this.buildOuterRequestRecord(false, requestModel, null, startTime, endTime, ExceptionUtils.getStackTrace(e));

            e.printStackTrace();
        }
        return null;
    }

    @Override
    public ResponseModel invokeRestFasync(String tenantId, String locale, String serviceProd, String serviceName, Map<String, String> headers, String bodyJsonString) {
        RequestModel requestModel = new RequestModel();
        requestModel.setHostAcct("athena");
        requestModel.setHostProd("Athena-mobile");
        requestModel.setHostVer(AppContext.getApiUrlSetting().getApplicationVersion());
        requestModel.setHostId("Athena-mobile");
        requestModel.setLanguage(locale);
        requestModel.setTenantId(tenantId);
        requestModel.setHeaderMap(headers);
        JSONObject body = new JSONObject();
        JSONObject stdData = new JSONObject();
        body.put("std_data", stdData);
        stdData.put("parameter", JsonUtil.jsonStringToObject(bodyJsonString, JSONObject.class));
        requestModel.setBodyJsonString(JsonUtil.javaObjectToJsonString(body));
        requestModel.setServiceProd(serviceProd);
        requestModel.setServiceName(serviceName);
        long startTime = System.currentTimeMillis();
        try {
            ResponseModel responseModel = Invoker.invokeRestFasync(requestModel);
            long endTime = System.currentTimeMillis();
            // 封装跟踪日志
            this.buildOuterRequestRecord(true, requestModel, responseModel, startTime, endTime, "");
            DigiwinEspErrorResponse espErrorResponse = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                    DigiwinEspErrorResponse.class);
            if (!ObjectUtils.isEmpty(espErrorResponse) && !ObjectUtils.isEmpty(espErrorResponse.getErrorCode())
                    && !ObjectUtils.isEmpty(espErrorResponse.getErrorMessage())) {
                throw new ServiceException("ESP errorCode: " + espErrorResponse.getErrorCode() +
                        ", errorMessage: " + espErrorResponse.getErrorMessage() +
                        ", errorInstructors: " + espErrorResponse.getErrorInstructors());
            }
            return responseModel;
        } catch (Exception e) {
            long endTime = System.currentTimeMillis();
            this.buildOuterRequestRecord(false, requestModel, null, startTime, endTime, ExceptionUtils.getStackTrace(e));
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 封装跟踪日志
     *
     * @param success
     * @param requestModel
     * @param responseModel
     * @param startTime
     * @param endTime
     * @param errorMsg
     */
    private void buildOuterRequestRecord(boolean success, RequestModel requestModel, ResponseModel responseModel,
                                         long startTime, long endTime, String errorMsg) {
        try {
            OuterRequestRecord requestRecord = new OuterRequestRecord()
                    .setRequestId(UUIDUtil.getUuid())
                    .setTraceId(this.buildTraceId(responseModel))
                    .setMethod("ESP")
                    .setSource(RequestSourceEnum.OUTER.getSource())
                    .setUrl(requestModel.getServiceName())
                    .setRequestObj(this.buildRequest(requestModel))
                    .setResponseObj(this.buildResponse(success, responseModel, errorMsg))
                    .setRequestTime(new Timestamp(startTime))
                    .setResponseTime(new Timestamp(endTime))
                    .setCode(this.buildCode(success, responseModel))
                    .setMillis(endTime - startTime);

            // 队列存储
            outerRequestRecordManage.add(requestRecord);
        } catch (Exception e) {
            logger.error("esp-sdk server trace log error:", e);
        }

    }

    private String buildTraceId(ResponseModel responseModel) {
        String traceId = TraceIdUtil.get();
        if (responseModel == null) {
            return traceId;
        }
        if (StringUtils.hasLength(responseModel.getHeader("traceId"))) {
            return responseModel.getHeader("traceId");
        }
        if (StringUtils.hasLength(responseModel.getHeader("pinpointId"))) {
            return responseModel.getHeader("pinpointId");
        }
        return traceId;
    }

    private Integer buildCode(boolean success, ResponseModel responseModel) {
        try {
            if (!success || null == responseModel || !StringUtils.hasLength(responseModel.getBodyJsonString())) {
                return 500;
            }
            DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                    DigiwinEspResponse.class);
            if (null == response) {
                return 500;
            }
            return response.isRespOk() ? 200 : 500;
        } catch (Exception ignored) {
            return 500;
        }
    }

    private OuterRequestRecord.Request buildRequest(RequestModel requestModel) {
        OuterRequestRecord.Request reqRecord = new OuterRequestRecord.Request();
        reqRecord.setHeader(requestModel.getHeaderMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)))
                .setQueryString("")
                .setBody(JsonUtil.jsonStringToObject(requestModel.getBodyJsonString(),
                        new TypeReference<Map<String, Object>>() {
                        }));
        return reqRecord;
    }

    private OuterRequestRecord.Response buildResponse(boolean success, ResponseModel responseModel, String errorMsg) {
        Map<String, Object> body = new HashMap<>();
        body.put("errorMsg", errorMsg);
        OuterRequestRecord.Response respRecord = new OuterRequestRecord.Response();
        respRecord.setHeader(success ? responseModel.getHeaders() : new HashMap<>())
                .setBody(success ? JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                        new TypeReference<Map<String, Object>>() {
                        }) : body);
        return respRecord;
    }

    @Override
    public boolean checkProjectBackward(String iamUserToken, String tenantId, String locale) {
        JSONObject parameter = new JSONObject();
        JSONArray projectInfoArr = new JSONArray();
        parameter.put("project_info", projectInfoArr);
        parameter.put("site_no", "");
        parameter.put("enterprise_no", "");
        JSONObject projectInfo = new JSONObject();
        projectInfo.put("project_status", "");
        projectInfo.put("project_set_no", "");
        projectInfo.put("project_leader_code", "");
        projectInfo.put("project_type_no", "");
        projectInfoArr.add(projectInfo);
        Map<String, String> headers = new HashMap<>();
        headers.put("digi-token", iamUserToken);

        String serviceName = "project.schedule.analysis.info.get";
        String serviceProd = "PCC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "project_schedule_info");

        Map<String, Object> parameterMap = response.getStdData().getParameter();
        List<Map<String, Object>> projectScheduleInfoList = (List<Map<String, Object>>) parameterMap.get("project_schedule_info");
        if (projectScheduleInfoList == null || projectScheduleInfoList.isEmpty()) {
            return false;
        }
        AtomicBoolean haveProjectBackward = new AtomicBoolean(false);
        projectScheduleInfoList.stream().forEach(projectScheduleInfo -> {
            List<Map<String, Object>> projectScheduleDetailList = (List<Map<String, Object>>) projectScheduleInfo.get("project_schedule_detail");
            if (projectScheduleDetailList != null && !projectScheduleDetailList.isEmpty()) {
                projectScheduleDetailList.stream().forEach(projectScheduleDetail -> {
                    //预计完成率：plan_complete_rate；实际完成率：actual_complete_rate
                    double planCompleteRate = (double) projectScheduleDetail.get("plan_complete_rate");
                    double actualCompleteRate = (double) projectScheduleDetail.get("actual_complete_rate");
                    if (planCompleteRate - actualCompleteRate > 0) {
                        haveProjectBackward.set(true);
                    }
                });
            }
        });
        return haveProjectBackward.get();
    }

    @Override
    public boolean checkProjectAmountOverdue(String iamUserToken, String tenantId, String locale) {
        JSONObject parameter = new JSONObject();
        JSONArray projectReceiveInfo = new JSONArray();
        parameter.put("project_receive_info", projectReceiveInfo);
        parameter.put("site_no", "");
        parameter.put("enterprise_no", "");
        Map<String, String> headers = new HashMap<>();
        headers.put("digi-token", iamUserToken);

        String serviceName = "project.receive.analysis.info.process";
        String serviceProd = "PCC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "project_receive_info");

        Map<String, Object> parameterMap = response.getStdData().getParameter();
        List<Map<String, Object>> projectReceiveInfoList = (List<Map<String, Object>>) parameterMap.get("project_receive_info");
        if (projectReceiveInfoList == null || projectReceiveInfoList.isEmpty()) {
            return false;
        }
        AtomicBoolean haveProjectAmountOverdue = new AtomicBoolean(false);
        projectReceiveInfoList.stream().forEach(projectReceiveInfoItem -> {
            List<Map<String, Object>> projectReceiveDetailList = (List<Map<String, Object>>) projectReceiveInfoItem.get("project_receive_detail");
            if (projectReceiveDetailList != null && !projectReceiveDetailList.isEmpty()) {
                projectReceiveDetailList.stream().forEach(projectReceiveDetail -> {
                    //延迟天数：overdue_days；未收原币金额：not_received_trans_curr_amount
                    double overdueDays = (double) projectReceiveDetail.get("overdue_days");
                    double notReceivedTransCurrAmount = (double) projectReceiveDetail.get("not_received_trans_curr_amount");
//                    logger.error("延迟天数：{}，未收原币金额：{}", overdueDays, notReceivedTransCurrAmount);
                    if (overdueDays > 0 && notReceivedTransCurrAmount > 0) {
                        haveProjectAmountOverdue.set(true);
                    }
                });
            }
        });
        return false;
    }

    @Override
    public List<Map<String, Object>> getCardInfo(List<Map<String, Object>> cardInfoRequestList, String userToken, String tenantId, String locale) {
        Map<String, String> headers = new HashMap<>(1);
        JSONObject parameter = new JSONObject();
        parameter.put("item_info", cardInfoRequestList);
        headers.put("digi-token", userToken);

        String serviceName = "cad.attribute.info.get";
        String serviceProd = "KSC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "cad_info");

        return (List<Map<String, Object>>) response.getStdData().getParameter().get("cad_info");
    }

    @Override
    public List<Map<String, Object>> getEmployeeInfoByProjectNo(List<Map<String, Object>> projectMemberInfoRequestList, String userToken, String tenantId, String locale) {
        Map<String, String> headers = new HashMap<>(1);
        JSONObject parameter = new JSONObject();
        parameter.put("project_member_info", projectMemberInfoRequestList);
        headers.put("digi-token", userToken);

        String serviceName = "employee.info.process";
        String serviceProd = "PCC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "project_member_info");

        return (List<Map<String, Object>>) response.getStdData().getParameter().get("project_member_info");
    }

    @Override
    public List<Map<String, Object>> getHumanResourceLoad(List<Map<String, Object>>
                                                                  humanResourceLoadRequestList, String userToken, String tenantId, String locale) {
        Map<String, String> headers = new HashMap<>(1);
        JSONObject parameter = new JSONObject();
        parameter.put("query_condition", humanResourceLoadRequestList);
        headers.put("digi-token", userToken);

        String serviceName = "human.resource.load.info.get";
        String serviceProd = "PCC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "department_data");

        return (List<Map<String, Object>>) response.getStdData().getParameter().get("department_data");
    }

    @Override
    public List<String> getProjectCriticalPath(String iamUserToken, String projectNo, String tenantId, String locale) {
        List<String> taskNoList = new ArrayList<>();
        Map<String, String> headers = new HashMap<>(1);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        JSONArray projectInfoArr = new JSONArray();
        parameter.put("project_info", projectInfoArr);
        JSONObject projectInfo = new JSONObject();
        projectInfo.put("project_no", projectNo);
        projectInfoArr.add(projectInfo);

        String serviceName = "project.critical.path.info.get";
        String serviceProd = "PCC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "task_info");

        List<Map<String, Object>> taskInfoList = (List<Map<String, Object>>) response.getStdData().getParameter().get("task_info");
        //task_no
        if (taskInfoList == null || taskInfoList.isEmpty()) {
            return taskNoList;
        }
        taskNoList = taskInfoList.stream().map(taskInfo -> (String) taskInfo.get("task_no")).collect(Collectors.toList());
        return taskNoList;
    }

    @Override
    public List<String> getNewProjectCriticalPath(String iamUserToken, String projectNo, String tenantId, String locale) {
        List<String> taskNoList = new ArrayList<>();
        Map<String, String> headers = new HashMap<>(1);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        JSONArray projectInfoArr = new JSONArray();
        parameter.put("project_info", projectInfoArr);
        JSONObject projectInfo = new JSONObject();
        projectInfo.put("project_no", projectNo);
        parameter.put("algorithm_type", 2);
        parameter.put("calculation_method", 1);
        projectInfoArr.add(projectInfo);

        String serviceName = "bm.pisc.project.critical.path.get";
        String serviceProd = "BM-PISC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "task_info");

        List<Map<String, Object>> taskInfoList = (List<Map<String, Object>>) response.getStdData().getParameter().get("task_info");
        //task_no
        if (taskInfoList == null || taskInfoList.isEmpty()) {
            return taskNoList;
        }
        taskNoList = taskInfoList.stream().map(taskInfo -> (String) taskInfo.get("task_no")).collect(Collectors.toList());
        return taskNoList;
    }

    @Override
    public List<String> getTaskPiscInfo(String iamUserToken, String projectNo, String taskNo, String tenantId, String locale) {
        Map<String, String> headers = new HashMap<>(1);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, Object> map = new HashMap<>(1);
        map.put("project_no", projectNo);
        parameter.put("task_info", Collections.singletonList(map));
        parameter.put("query_condition", "D1M1");

        String serviceName = "bm.pisc.task.get";
        String serviceProd = "BM-PISC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok task_dependency_info
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "task_info");
        //获取此项目下所有项目的任务卡
        List<Map<String, Object>> taskInfoAllList = (List<Map<String, Object>>) response.getStdData().getParameter().get("task_info");
        //筛选当前任务卡
        List<Map<String, Object>> taskInfoList = taskInfoAllList
                .stream()
                .filter(a -> a.get("task_no").toString().equalsIgnoreCase(taskNo))
                .collect(Collectors.toList());
        List<String> beforeTaskNoList = taskInfoList.stream()
                .map(stringObjectMap -> (List<Map<String, Object>>) stringObjectMap.get("task_dependency_info"))
                .filter(CollUtil::isNotEmpty)
                .flatMap(Collection::stream)
                .map(objectMap -> objectMap.get("before_task_no").toString())
                .collect(Collectors.toList());
        //获取当前任务卡的前置任务beforeTaskNo
        List<String> taskStatusList = new ArrayList<>(beforeTaskNoList.size());
        //在获取前置任务的状态
        taskInfoAllList.forEach(stringObjectMap -> beforeTaskNoList.stream()
                .filter(beforeTaskNo -> beforeTaskNo.equalsIgnoreCase(stringObjectMap.get("task_no").toString()))
                .map(beforeTaskNo -> stringObjectMap.get("task_status").toString())
                .forEach(taskStatusList::add));
        return taskStatusList;
    }

    @Override
    public List<PccProjectTaskInfo> getTaskInfo(String iamUserToken, String projectNo,
                                                String taskNo, String tenantId, String locale) {
        Map<String, String> headers = new HashMap<>(1);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, Object> map = new HashMap<>(1);
        map.put("project_no", projectNo);
        map.put("task_no", taskNo);
        parameter.put("task_info", Collections.singletonList(map));
        parameter.put("query_condition", "M1D2");

        String serviceName = "bm.pisc.task.get";
        String serviceProd = "BM-PISC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok task_dependency_info
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "task_info");
        //获取此项目下所有项目的任务卡
        return ModuleUtils.listMapToListT((List<Map<String, Object>>) response.getStdData().getParameter().get("task_info"), PccProjectTaskInfo.class);
    }

    @Override
    public List<Map<String, Object>> getHumanResourceLoadByDateId(List<String> itemInfo, String dateId, String tenantId, String locale, String iamUserToken) {
        List<Map<String, Object>> employeeInfoList = new ArrayList<>();
        List<Map<String, Object>> humanResourceLoadList = new ArrayList<>();
        for (String item : itemInfo) {
            List<Map<String, Object>> projectMemberInfoRequestList = new ArrayList<>();
            Map<String, Object> items = new HashMap<>(1);
            items.put("project_no", item);
            projectMemberInfoRequestList.add(items);
            employeeInfoList.addAll(this.getEmployeeInfoByProjectNo(projectMemberInfoRequestList, iamUserToken, tenantId, locale));
        }
        if (employeeInfoList != null && employeeInfoList.size() > 0) {
            List<Map<String, Object>> humanResourceLoadRequestList = new ArrayList<>();
            Map<String, Object> items = new HashMap<>(1);
            items.put("datetime_s", DateTimeUtil.getTodayTimeUseDefaultPattern());
            if (FEATURE_WEEK.equals(dateId)) {
                items.put("datetime_e", DateTimeUtil.getSevthDate(null));
            } else if (FEATURE_MONTH.equals(dateId)) {
                items.put("datetime_e", DateTimeUtil.getOneMonthDate(null));
            } else {
                items.put("datetime_e", DateTimeUtil.getSevthDate(null));
            }

            List<Map<String, String>> personnelInfo = new ArrayList<>(employeeInfoList.size());
            for (Map<String, Object> employeeInfo : employeeInfoList) {
                Map<String, String> personnelNo = new HashMap<>();
                personnelNo.put("personnel_no", (String) employeeInfo.get("employee_no"));
                personnelInfo.add(personnelNo);
            }
            items.put("personnel_info", personnelInfo);
            humanResourceLoadRequestList.add(items);
            humanResourceLoadList.addAll(this.getHumanResourceLoad(humanResourceLoadRequestList, iamUserToken, tenantId, locale));
        } else {
            return Collections.emptyList();
        }
        return humanResourceLoadList;
    }

    @Override
    public List<Map<String, Object>> getProjectWoProductionInfoProcess(String eocSiteId, String eocCompanyId,
                                                                       List<PccProjectTaskInfo> taskInfoList,
                                                                       String iamUserToken, String tenantId,
                                                                       String locale, String processStatus) {
        String mKey = "doc_info";

        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        Map<String, String> digiEocmap = new HashMap<>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));

        JSONObject parameter = new JSONObject();
        JSONArray queryConditionArr = new JSONArray();
        for (PccProjectTaskInfo taskInfo : taskInfoList) {
            Map<String, Object> taskInfoMap = JsonUtil.objectToJavaObject(taskInfo, JSONObject.class);
            taskInfoMap.put("project_no", taskInfo.getProjectNo());
            taskInfoMap.put("task_no", taskInfo.getTaskNo());
            taskInfoMap.put("display_project_no", taskInfo.getDisplayProjectNo());
            taskInfoMap.put("process_status", processStatus);
            queryConditionArr.add(taskInfo);
        }
        parameter.put(mKey, queryConditionArr);
        parameter.put("enterprise_no", eocCompanyId);
        parameter.put("site_no", eocSiteId);

        String serviceProd = "PCC";
        String serviceName = "project.wo.production.info.process";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, mKey);

        return (List<Map<String, Object>>) response.getStdData().getParameter().get(mKey);

    }

    @Override
    public List<Map<String, Object>> getProjectDocInfoProcess(String eocSiteId, String eocCompanyId,
                                                              List<PccProjectTaskInfo> taskInfoList,
                                                              String iamUserToken, String tenantId, String locale,
                                                              String processStatus) {
        String mKey = "doc_info";

        Map<String, String> headers = new HashMap<>(2);
        headers.put("token", iamUserToken);
        Map<String, String> digiEocmap = new HashMap<>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));

        JSONObject parameter = new JSONObject();
        JSONArray queryConditionArr = new JSONArray();
        for (PccProjectTaskInfo taskInfo : taskInfoList) {
            Map<String, Object> taskInfoMap = JsonUtil.objectToJavaObject(taskInfo, JSONObject.class);
            taskInfoMap.put("process_status", processStatus);
            queryConditionArr.add(taskInfoMap);
        }
        parameter.put(mKey, queryConditionArr);
        parameter.put("enterprise_no", eocCompanyId);
        parameter.put("site_no", eocSiteId);

        String serviceProd = "PCC";
        String serviceName = "project.doc.info.process";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, mKey);

        return (List<Map<String, Object>>) response.getStdData().getParameter().get(mKey);

    }

    @Override
    public List<Map<String, Object>> getTaskInfo(String eocSiteId, String eocCompanyId,
                                                 List<PccProjectTaskInfo> pccProjectTaskInfoList,
                                                 String iamUserToken, String tenantId, String locale, String processStatus) {
        String mKey = "project_info";

        Map<String, String> headers = new HashMap<>(2);
        headers.put("token", iamUserToken);
        Map<String, String> digiEocmap = new HashMap<>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));

        JSONObject parameter = new JSONObject();
        JSONArray queryConditionArr = new JSONArray();
        for (PccProjectTaskInfo taskInfo : pccProjectTaskInfoList) {
            Map<String, Object> taskInfoMap = JsonUtil.objectToJavaObject(taskInfo, JSONObject.class);
            taskInfoMap.put("control_mode", "1");
            taskInfoMap.put("process_status", processStatus);
            queryConditionArr.add(taskInfoMap);
        }
        parameter.put(mKey, queryConditionArr);
        parameter.put("enterprise_no", eocCompanyId);
        parameter.put("site_no", eocSiteId);

        String serviceProd = "PCC";
        String serviceName = "task.info.get";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, mKey);

        return (List<Map<String, Object>>) response.getStdData().getParameter().get(mKey);
    }

    @Override
    public List<Map<String, Object>> getBmPiscAttachmentJoinRelation(String eocSiteId, String eocCompanyId,
                                                                     String iamUserToken, String tenantId, String locale,
                                                                     String processStatus, String projectNo,
                                                                     String taskNo) {
        String mKey = "task_info";

        Map<String, String> headers = new HashMap<>(2);
        headers.put("token", iamUserToken);
        Map<String, String> digiEocmap = new HashMap<>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));

        JSONObject parameter = new JSONObject();
        JSONArray queryConditionArr = new JSONArray();
        JSONObject taskInfo = new JSONObject();
        taskInfo.put("project_no", projectNo);
        taskInfo.put("task_no", taskNo);
        taskInfo.put("process_status", processStatus);
        queryConditionArr.add(taskInfo);
        parameter.put(mKey, queryConditionArr);
        parameter.put("query_condition", "ALL");
        parameter.put("enterprise_no", eocCompanyId);
        parameter.put("site_no", eocSiteId);

        String serviceProd = "BM-PISC";
        String serviceName = "bm.pisc.attachment.join.relation.get";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, mKey);

        return (List<Map<String, Object>>) response.getStdData().getParameter().get(mKey);
    }


    @Override
    public List<Map<String, Object>> getWorkItemData(String eocSiteId, String eocCompanyId,
                                                     List<PccProjectTaskInfo> taskInfoList, String iamUserToken,
                                                     String tenantId, String locale, String processStatus) {
        String serviceProd = "PLM";
        String serviceName = "work.item.data.get";
        String mKey = "doc_info";

        Map<String, String> headers = new HashMap<>(2);
        headers.put("token", iamUserToken);
        Map<String, String> digiEocmap = new HashMap<>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));

        JSONObject parameter = new JSONObject();
        JSONArray docInfoArray = new JSONArray();
        for (PccProjectTaskInfo taskInfo : taskInfoList) {
            Map<String, Object> docInfo = new HashMap<>(4);
            docInfo.put("project_no", taskInfo.getProjectNo());
            docInfo.put("task_no", taskInfo.getTaskNo());
            docInfo.put("process_status", processStatus);
            docInfo.put("display_project_no", taskInfo.getDisplayProjectNo());
            docInfoArray.add(docInfo);
        }
        parameter.put(mKey, docInfoArray);
        parameter.put("enterprise_no", eocCompanyId);
        parameter.put("site_no", eocSiteId);

        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, mKey);

        return (List<Map<String, Object>>) response.getStdData().getParameter().get(mKey);
    }

    @Override
    public List<Map<String, Object>> getProjectTaskCompleteRateData(String eocSiteId, String eocCompanyId,
                                                                    List<PccProjectTaskInfo> taskInfoList,
                                                                    String iamUserToken, String tenantId, String locale) {
        String serviceProd = "PLM";
        String serviceName = "project.task.complete.rate.data.get";
        String mKey = "doc_info";

        Map<String, String> headers = new HashMap<>(2);
        headers.put("token", iamUserToken);
        Map<String, String> digiEocmap = new HashMap<>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));

        JSONObject parameter = new JSONObject();
        JSONArray docInfoArray = new JSONArray();
        for (PccProjectTaskInfo taskInfo : taskInfoList) {
            Map<String, Object> docInfo = new HashMap<>(4);
            docInfo.put("project_no", taskInfo.getProjectNo());
            docInfo.put("task_no", taskInfo.getTaskNo());
            docInfoArray.add(docInfo);
        }
        parameter.put(mKey, docInfoArray);
        parameter.put("enterprise_no", eocCompanyId);
        parameter.put("site_no", eocSiteId);

        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, mKey);

        return (List<Map<String, Object>>) response.getStdData().getParameter().get(mKey);
    }

    @Override
    public String getEocSiteIdByPurchaseNo(String purchaseNo, String companyId, String iamUserToken, String tenantId, String locale) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        //digi-eocmap: {"eoc_company_id":"DEMO"}
        Map<String, String> digiEocmap = new HashMap<>();
        digiEocmap.put("eoc_company_id", companyId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        JSONObject parameter = new JSONObject();
        JSONArray purchaseDataArr = new JSONArray();
        JSONObject purchaseData = new JSONObject();
        purchaseData.put("purchase_no", purchaseNo);
        purchaseData.put("eoc_company_id", companyId);
        purchaseDataArr.add(purchaseData);
        parameter.put("purchase_data", purchaseDataArr);

        String serviceName = "bm.posc.purchase.order.get";
        String serviceProd = "BM-POSC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "purchase_data");

        Map<String, Object> parameterMap = response.getStdData().getParameter();
        List<Map<String, Object>> purchaseDataList = (List<Map<String, Object>>) parameterMap.get("purchase_data");
        if (purchaseDataList == null || purchaseDataList.isEmpty()) {
            return "";
        }
        return (String) purchaseDataList.get(0).get("eoc_site_id");
    }

    @Override
    public List<DigiwinItemCategory> getCategoryByItemNo(String itemNo, String companyId, String iamUserToken, String tenantId, String locale) {
        List<DigiwinItemCategory> list = new ArrayList<>();

        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        //digi-eocmap: {"eoc_company_id":"DEMO"}
        Map<String, String> digiEocmap = new HashMap<>();
        digiEocmap.put("eoc_company_id", companyId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));

        JSONObject parameter = new JSONObject();
        JSONArray itemDataArr = new JSONArray();
        JSONObject itemData = new JSONObject();
        itemData.put("item_no", itemNo);
        itemDataArr.add(itemData);
        parameter.put("item_data", itemDataArr);

        String serviceName = "bm.iisc.item.exclusive.class.get";
        String serviceProd = "BM-IISC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "item_data");

        List itemDataList = (List) response.getStdData().getParameter().get("item_data");
        if (itemDataList == null || itemDataList.isEmpty()) {
            return list;
        }
        List<Object> itemCategoryList = (List) ((Map) itemDataList.get(0)).get("item_category");
        if (itemCategoryList == null || itemCategoryList.isEmpty()) {
            return list;
        }
        return itemCategoryList.stream().map(itemCategory ->
                        JsonUtil.objectToJavaObject(itemCategory, DigiwinItemCategory.class))
                .collect(Collectors.toList());
    }

    @Override
    public List<DigiwinInventoryData> getInventoryByCategory(String eocSiteId, List<DigiwinItemCategory> itemCategoryList, String companyId, String iamUserToken, String tenantId, String locale) {
        List<DigiwinInventoryData> inventoryDataList = new ArrayList<>();

        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        Map<String, String> digiEocmap = new HashMap<>();
        digiEocmap.put("eoc_company_id", companyId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));

        JSONObject parameter = new JSONObject();
        JSONArray queryConditionArr = new JSONArray();
        for (DigiwinItemCategory itemCategory : itemCategoryList) {
            JSONObject queryCondition = new JSONObject();
            queryCondition.put("classification_method_no", itemCategory.getClassificationMethodNo());
            queryCondition.put("category_no", itemCategory.getCategoryNo());
            queryCondition.put("eoc_site_id", eocSiteId);
            queryConditionArr.add(queryCondition);
        }
        parameter.put("query_condition", queryConditionArr);
        parameter.put("query_type", "1");

        String serviceName = "bm.iisc.item.category.inventory.get";
        String serviceProd = "BM-IISC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "inventory_data");

        List<Object> inventoryDataObjList = (List<Object>) response.getStdData().getParameter().get("inventory_data");
        if (inventoryDataObjList == null || inventoryDataObjList.isEmpty()) {
            return inventoryDataList;
        }
        return inventoryDataObjList.stream()
                .map(o -> JsonUtil.objectToJavaObject(o, DigiwinInventoryData.class))
                .collect(Collectors.toList());
    }

    @Override
    public List<DigiwinOrderPriceData> getLatelyPriceListByItemCode(List<String> itemCodeList, String iamUserToken, String tenantId, String locale) {
        List<DigiwinOrderPriceData> orderPriceDataList = new ArrayList<>();

        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        Map<String, Object> parameter = new HashMap();
        List<Map> itemData = new ArrayList<>();
        if (CollectionUtils.isEmpty(itemCodeList)) {
            return orderPriceDataList;
        }
        for (String itemCode : itemCodeList) {
            Map<String, Object> item = new HashMap<>();
            item.put("item_code", itemCode);
            item.put("item_feature_code", "");
            itemData.add(item);
        }
        parameter.put("item_data", itemData);
        parameter.put("enterprise_no", "");
        parameter.put("site_no", "");
        parameter.put("supplier_center_code", "");

        String serviceName = "ddsm.zicd.po.order.lately.price.get";
        String serviceProd = "E10";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "order_price_data");

        List<Object> orderPriceDataObjList = (List<Object>) response.getStdData().getParameter().get("order_price_data");
        if (orderPriceDataObjList == null || orderPriceDataObjList.isEmpty()) {
            return orderPriceDataList;
        }
        return orderPriceDataObjList.stream()
                .map(o -> JsonUtil.objectToJavaObject(o, DigiwinOrderPriceData.class))
                .collect(Collectors.toList());
    }

    @Override
    public List<Map<String, Object>> getCustomerInfoByNo(List<String> customerNos, String iamUserToken, String tenantId, String locale) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        List<DigiwinCustomerInfoRequest> digiwinCustomerInfoRequests = new ArrayList<>(customerNos.size());
        for (String customerNo : customerNos) {
            DigiwinCustomerInfoRequest customerInfoRequest = new DigiwinCustomerInfoRequest();
            customerInfoRequest.setCustomerNo(customerNo);
            digiwinCustomerInfoRequests.add(customerInfoRequest);
        }
        JSONObject parameter = new JSONObject();
        parameter.put("customer_info", digiwinCustomerInfoRequests);

        String serviceName = "customer.application.info.get";
        String serviceProd = "POM";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "customer_info");

        return (List<Map<String, Object>>) response.getStdData().getParameter().get("customer_info");
    }

    @Override
    public List<Map<String, Object>> getReceivableByNo(List<String> customerNos, String iamUserToken, String tenantId, String locale, String eocCompanyId) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        Map<String, String> eocmap = new HashMap<>(1);
        eocmap.put("eoc_company_id", eocCompanyId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(eocmap));
        List<DigiwinReceivableRequest> digiwinReceivableRequests = new ArrayList<>(customerNos.size());
        for (String customerNo : customerNos) {
            DigiwinReceivableRequest digiwinReceivableRequest = new DigiwinReceivableRequest();
            digiwinReceivableRequest.setCustomerNo(customerNo);
            digiwinReceivableRequest.setEocCompanyId(eocCompanyId);
            digiwinReceivableRequests.add(digiwinReceivableRequest);
        }
        JSONObject parameter = new JSONObject();
        parameter.put("ar_data", digiwinReceivableRequests);

        String serviceName = "bm.arsc.account.receivable.customer.detail.get";
        String serviceProd = "BM-ARSC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "ar_data");

        return (List<Map<String, Object>>) response.getStdData().getParameter().get("ar_data");
    }

    @Override
    public Map<String, Object>
    exceptReportVerifyInfoProcess(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        String serviceProd = "APC";
        String serviceName = "except.report.verify.info.process";
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        if (!CollectionUtils.isEmpty(params)) {
            Map<String, String> digiEocmap = new HashMap<>();
            digiEocmap.put("eoc_company_id", StringUtil.valueOf(params.get("eoc_company_id")));
            digiEocmap.put("eoc_site_id", StringUtil.valueOf(params.get("eoc_site_id")));
            headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        }
        JSONObject parameter = new JSONObject();
        ArrayList<Map<String, Object>> data = new ArrayList<>(1);
        data.add(params);
        parameter.put("except_report_data", data);

        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers,
                parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (response == null) {
            throw new ServiceException("Service " + serviceName + " call returned NONE Response!");
        }
        if (StringUtils.hasLength(response.getStdDataExecutionDescription())) {
            return JsonUtil.objectToJavaObject(response.getStdData().getExecution(), Map.class);
        }
        // 注意：不要判断 error_msg 字段
        if (!response.isRespOk("wo_op_report_data")) {
            throw new ServiceException(response.getResponseFullDescriptionMsgWhenNotOK(serviceProd, serviceName, parameterBodyJson));
        }
        return response.getStdData().getParameter();
    }

    @Override
    public Boolean exceptReportInfoProcess(String iamUserToken, String tenantId, String locale, Map<String, Object> params, List<Map<String, Object>> woOpReportData) {
        String serviceProd = "APC";
        String serviceName = "except.report.info.process";
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        if (!CollectionUtils.isEmpty(params)) {
            Map<String, String> digiEocmap = new HashMap<>();
            digiEocmap.put("eoc_company_id", StringUtil.valueOf(params.get("eoc_company_id")));
            digiEocmap.put("eoc_site_id", StringUtil.valueOf(params.get("eoc_site_id")));
            headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        }
        JSONObject parameter = new JSONObject();
        ArrayList<Map<String, Object>> data = new ArrayList<>(1);
        data.add(params);
        parameter.put("except_report_data", data);
        parameter.put("wo_op_report_data", woOpReportData);

        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson);

        return true;
    }

    @Override
    public Map<String, Object> getAsnHeader(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);

        String serviceName = "delivery.head.info.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "delivery_head");

        return (Map<String, Object>) response.getStdData().getParameter().get("delivery_head");
    }


    @Override
    public List<Map<String, Object>> getDriverVehicle(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }

        String serviceName = "driver.vehicle.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "vehicle_list");

        return (List<Map<String, Object>>) response.getStdData().getParameter().get("vehicle_list");
    }

    @Override
    public Boolean getElectronicFenceShowFlag(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }

        String serviceName = "electronic.fence.show.flag.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "electronic_fence_show_flag");

        return (Boolean) response.getStdData().getParameter().get("electronic_fence_show_flag");
    }

    @Override
    public List<Map<String, Object>> getElectronicFenceFactoryList(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }

        String serviceName = "electronic.fence.list.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "electronic_fence_factory_list");

        return (List<Map<String, Object>>) response.getStdData().getParameter().get("electronic_fence_factory_list");
    }

    @Override
    public List<Map<String, Object>> getDriverVehicleDetail(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }

        String serviceName = "driver.vehicle.detail.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("vehicle_list");
    }

    @Override
    public Boolean addDriverVehicle(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }

        String serviceName = "driver.vehicle.create";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.isRespOk();
    }

    @Override
    public Boolean updateDriverVehicle(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }

        String serviceName = "driver.vehicle.update";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.isRespOk();
    }

    @Override
    public Boolean saveElectronicFence(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }

        String serviceName = "electronic.fence.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.isRespOk();
    }

    @Override
    public Boolean deleteDriverVehicle(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }

        String serviceName = "driver.vehicle.delete";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.isRespOk();
    }

    @Override
    public Map<String, Object> getAsnBody(String iamUserToken, String tenantId, String locale,
                                          Integer page_no, Integer page_size, Boolean use_has_next, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("page_no", page_no);
        parameter.put("page_size", page_size);
        parameter.put("use_has_next", use_has_next);
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }

        String serviceName = "delivery.detail.info.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "delivery_detail");

        Map<String, Object> deliveryDetailInfo = new HashMap<>();
        deliveryDetailInfo.put("total_results", response.getStdData().getParameter().get("total_results"));
        deliveryDetailInfo.put("has_next", response.getStdData().getParameter().get("has_next"));
        deliveryDetailInfo.put("delivery_detail", response.getStdData().getParameter().get("delivery_detail"));
        return deliveryDetailInfo;
    }

    @Override
    public List<Map<String, Object>> getVehicleInfo(String iamUserToken, String tenantId, String locale, String taskNo, Boolean isLoadCar, String keyword) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, Object> params = new HashMap<>(1);
        params.put("task_no", taskNo);
        if (StringUtils.hasLength(keyword)) {
            params.put("vehicle_keyword", keyword);
        }
        params.put("is_filter_load_car", isLoadCar);
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }

        String serviceName = "delivery.vehicle.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "vehicle_info");

        return (List<Map<String, Object>>) response.getStdData().getParameter().get("vehicle_info");
    }

    @Override
    public DigiwinEspStdData driverCurrentVehicleUpdate(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }

        String serviceName = "driver.current.vehicle.update";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson);

        return response.getStdData();
    }

    @Override
    public DigiwinEspStdData ztbSubmit(String iamUserToken, String tenantId, String locale, String taskNo, String status) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        JSONObject param = new JSONObject();
        param.put("task_no", taskNo);
        param.put("status", status);
        parameter.put("parameter", param);

        String serviceName = "delivery.task.status.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson);

        return response.getStdData();
    }

    @Override
    public DigiwinEspStdData ztbLoadingSubmit(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> cargoInformation, Map<String, Object> vehicleInfo) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("cargo_information", cargoInformation);
        parameter.put("vehicle_info", vehicleInfo);

        String serviceName = "cargo.loading.info.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson);

        return response.getStdData();
    }

    @Override
    public DigiwinEspStdData ztbJsonTenant(String iamUserToken, String locale, String taskNo, String userId) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        JSONObject param = new JSONObject();
        param.put("task_no", taskNo);
        param.put("user_id", userId);
        parameter.put("parameter", param);

        String serviceName = "driver.join.tenant.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync("", locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson);

        return response.getStdData();
    }

    @Override
    public List<Map<String, Object>> getProjectsByIDs(String iamUserToken, String tenantId, String locale, List<String> projectIds) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        for (String projectId : projectIds) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("project_no", projectId);
            jsonArray.add(jsonObject);
        }
        parameter.put("project_info", jsonArray);

        String serviceName = "bm.pisc.project.get";
        String serviceProd = "BM-PISC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "project_info");

        return (List<Map<String, Object>>) response.getStdData().getParameter().get("project_info");
    }

    @Override
    public List<Map<String, Object>> getAbnormalReviewInfo(String iamUserToken, String tenantId,
                                                           String locale, List<Map<String, Object>> docInfos) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("doc_info", docInfos);

        String serviceName = "project.abnormal.review.info.get";
        String serviceProd = "PCC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "doc_info");

        return (List<Map<String, Object>>) response.getStdData().getParameter().get("doc_info");
    }

    @Override
    public List<DigiwinEspEnumerateResponse> getEnumerateInfo(String iamUserToken, String tenantId, String locale, String schema) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        JSONObject param = new JSONObject();
        param.put("enumerate_type", schema);
        parameter.put("parameter", param);

        String serviceName = "enumerate.info.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "enumerate_list");

        return ModuleUtils.listMapToListObject((List) response.getStdData().getParameter().get("enumerate_list"), DigiwinEspEnumerateResponse.class);
    }

    @Override
    public DigiwinEspStdData cargoDepart(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);

        String serviceName = "cargo.depart.info.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson);

        return response.getStdData();
    }

    @Override
    public Map<String, Object> getTransportVehicleInfo(String iamUserToken, String tenantId, String locale, String transportNo) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, Object> params = new HashMap<>(1);
        params.put("transport_no", transportNo);
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }

        String serviceName = "transport.vehicle.info.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "vehicle_info");

        return (Map<String, Object>) response.getStdData().getParameter().get("vehicle_info");
    }

    @Override
    public Map<String, Object> getTransportEntryArrangement(String iamUserToken, String tenantId, String locale, String transportNo) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, Object> params = new HashMap<>(1);
        params.put("transport_no", transportNo);
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }

        String serviceName = "transport.entry.arrangement.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "entry_arrangement_info");

        return (Map<String, Object>) response.getStdData().getParameter().get("entry_arrangement_info");
    }

    @Override
    public DigiwinTransportResponse getTransportMainInfo(String iamUserToken, String tenantId, String locale, String transportNo) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, Object> params = new HashMap<>(1);
        params.put("transport_no", transportNo);
        parameter.put("parameter", params);

        String serviceName = "transport.main.info.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "transport_main_info");

        return JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("transport_main_info"), DigiwinTransportResponse.class);
    }

    @Override
    public Map<String, Object> getTransportMainInfoResponseMap(String iamUserToken, String tenantId, String locale, String transportNo) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, Object> params = new HashMap<>(1);
        params.put("transport_no", transportNo);
        parameter.put("parameter", params);

        String serviceName = "transport.main.info.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "transport_main_info");

        return (Map<String, Object>) response.getStdData().getParameter().get("transport_main_info");
    }

    @Override
    public DigiwinEspStdData scheduleInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);

        String serviceName = "schedule.info.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson);

        return response.getStdData();
    }

    @Override
    public DigiwinEspStdData completeReceiptPreparationInfo(String iamUserToken, String tenantId, String locale, String transportNo) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, Object> params = new HashMap<>(1);
        params.put("transport_no", transportNo);
        parameter.put("parameter", params);

        String serviceName = "complete.receipt.preparation.info.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson);

        return response.getStdData();
    }

    /**
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param transportNo
     * @param params       {
     *                     unloader_id
     *                     unloader_name
     *                     unloader_tool
     *                     plan_unload_time
     *                     }
     * @return
     */
    @Override
    public DigiwinEspStdData receiptPreparationInfo(String iamUserToken, String tenantId, String locale, String transportNo, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        params.put("transport_no", transportNo);
        parameter.put("parameter", params);

        String serviceName = "receipt.preparation.info.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson);

        return response.getStdData();
    }

    @Override
    public DigiwinEspStdData transportComingSoonProcess(String iamUserToken, String tenantId, String locale, String transportNo, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        params.put("transport_no", transportNo);
        parameter.put("parameter", params);

        String serviceName = "transport.coming.soon.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson);

        return response.getStdData();
    }

    @Override
    public List<ZtbUserInfo> getUserInfo(String iamUserToken, String tenantId, String locale, String param, Integer pageNo, Integer pageSize, Map<String, String> para) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, Object> params = new HashMap<>(1);
        params.putAll(para);
        params.put("query_rule", param);
        parameter.put("parameter", params);
        parameter.put("page_no", pageNo);
        parameter.put("page_size", pageSize);

        String serviceName = "unloader.info.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "user_list");

        return ModuleUtils.listMapToListObject((List) response.getStdData().getParameter().get("user_list"), ZtbUserInfo.class);
    }

    @Override
    public Map<String, Object> getTransportCargoInfo(String iamUserToken, String tenantId, String locale, String transportNo, Integer pageNo, Integer pageSize, Boolean useHasNext) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("page_no", pageNo);
        parameter.put("page_size", pageSize);
        parameter.put("use_has_next", useHasNext);
        JSONObject transportNoObject = new JSONObject();
        transportNoObject.put("transport_no", transportNo);
        parameter.put("parameter", transportNoObject);

        String serviceName = "transport.cargo.info.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "cargo_information");

        Map<String, Object> cargoInformation = new HashMap<>(3);
        cargoInformation.put("total_results", response.getStdData().getParameter().get("total_results"));
        cargoInformation.put("has_next", response.getStdData().getParameter().get("has_next"));
        cargoInformation.put("cargo_information", response.getStdData().getParameter().get("cargo_information"));
        return cargoInformation;
    }

    /**
     * @param iamUserToken
     * @param tenantId
     * @param locale
     * @param params{      transport_no  运输单号
     *                     is_rejected 是否拒收
     *                     reject_reason  拒收原因
     *                     }
     * @return
     */
    @Override
    public DigiwinEspStdData confirmCargoReceiptInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);

        String serviceName = "cargo.receipt.confirm.info.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson);

        return response.getStdData();
    }

    @Override
    public List<AppointmentDeliveryDate> getAppointmentDeliveryDate(String iamUserToken, String tenantId, String locale, String deliveryNo) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, Object> params = new HashMap<>(1);
        params.put("delivery_no", deliveryNo);
        parameter.put("parameter", params);

        String serviceName = "appointment.delivery.date.data.get";
        String serviceProd = "ILC-SRM";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "can_appointment_delivery_date");

        return ModuleUtils.listMapToListObject((List) response.getStdData().getParameter().get("can_appointment_delivery_date"), AppointmentDeliveryDate.class);
    }

    @Override
    public List<UseAppointmentDeliveryPlatform> getAppointmentPlatformInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);

        String serviceName = "appointment.platform.data.get";
        String serviceProd = "ILC-SRM";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "can_appointment_delivery_platform");

        return ModuleUtils.listMapToListObject((List) response.getStdData().getParameter().get("can_appointment_delivery_platform"), UseAppointmentDeliveryPlatform.class);
    }

    @Override
    public List<CanAppointmentDeliveryTimeSlot> getAppointmentDeliveryTimeSlot(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);

        String serviceName = "appointment.delivery.time.slot.data.get";
        String serviceProd = "ILC-SRM";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "can_appointment_delivery_time_slot");

        return ModuleUtils.listMapToListObject((List) response.getStdData().getParameter().get("can_appointment_delivery_time_slot"), CanAppointmentDeliveryTimeSlot.class);
    }


    @Override
    public List<Map<String, Object>> getShippingSchedule(String iamUserToken, String tenantId, String locale, String transportNo) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, Object> params = new HashMap<>(1);
        params.put("transport_no", transportNo);
        parameter.put("parameter", params);

        String serviceName = "delivery.schedule.info.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "vehicle_appointment_delivery_list");

        return JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("vehicle_appointment_delivery_list"), List.class);
    }

    @Override
    public DigiwinEspStdData abnormalAlertCheck(String iamUserToken, String tenantId, String locale, String transportNo) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, Object> params = new HashMap<>(1);
        params.put("transport_no", transportNo);
        parameter.put("parameter", params);

        String serviceName = "abnormal.alert.check";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson);

        return response.getStdData();
    }

    @Override
    public DigiwinEspStdData validArrival(String iamUserToken, String tenantId, String locale, String taskNo, String transportNo, ApiRequestPosition position) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, Object> params = new HashMap<>(1);
        params.put("transport_no", transportNo);
        params.put("task_no", taskNo);
        parameter.put("parameter", params);
        if (position != null) {
            params.put("longitude", position.getLongitude());
            params.put("latitude", position.getLatitude());
            params.put("province", position.getProvince());
            params.put("city", position.getCity());
            params.put("area", position.getArea());
            params.put("complete_address", position.getCompleteAddress());
            params.put("detail_address", position.getDetailAddress());
        }
        String serviceName = "transport.arrival.valid.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }

        return response.getStdData();
    }

    @Override
    public DigiwinEspStdData cargoArrival(String arrivalType, String iamUserToken, String tenantId, String locale,
                                          String transportNo, String receiverName, String receiverMobile, ApiRequestPosition position) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, Object> params = new HashMap<>(1);
        params.put("transport_no", transportNo);
        params.put("arrival_type", arrivalType);
        params.put("receiver_name", receiverName);
        params.put("receiver_mobile", receiverMobile);
        if (position != null) {
            params.put("longitude", position.getLongitude());
            params.put("latitude", position.getLatitude());
            params.put("province", position.getProvince());
            params.put("city", position.getCity());
            params.put("area", position.getArea());
            params.put("complete_address", position.getCompleteAddress());
            params.put("detail_address", position.getDetailAddress());
        }
        parameter.put("parameter", params);

        String serviceName = "cargo.arrival.info.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.getStdData();
    }


    @Override
    public List<Map<String, Object>> getTransportDriver(String iamUserToken, String tenantId, String locale, String transportNo) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, Object> params = new HashMap<>(1);
        params.put("transport_no", transportNo);
        parameter.put("parameter", params);

        String serviceName = "old.driver.transport.transshipment.vehicle.info.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "vehicle_info");

        return JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("vehicle_info"), List.class);
    }

    @Override
    public DigiwinEspStdData oldDriverProcess(String iamUserToken, String tenantId, String locale, String transportNo, String vehicleInfoId, ApiRequestPosition position) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, Object> params = new HashMap<>(1);
        params.put("transport_no", transportNo);
        params.put("vehicle_info_id", vehicleInfoId);
        if (position != null) {
            params.put("longitude", position.getLongitude());
            params.put("latitude", position.getLatitude());
            params.put("province", position.getProvince());
            params.put("city", position.getCity());
            params.put("area", position.getArea());
            params.put("complete_address", position.getCompleteAddress());
            params.put("detail_address", position.getDetailAddress());
        }
        parameter.put("parameter", params);

        String serviceName = "old.driver.transport.transshipment.info.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson);

        return response.getStdData();
    }

    @Override
    public DigiwinEspStdData commitDriverMsg(String iamUserToken, String tenantId, String locale, Map<String, Object> params, ApiRequestPosition position) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        if (position != null) {
            params.put("longitude", position.getLongitude());
            params.put("latitude", position.getLatitude());
            params.put("province", position.getProvince());
            params.put("city", position.getCity());
            params.put("area", position.getArea());
            params.put("complete_address", position.getCompleteAddress());
            params.put("detail_address", position.getDetailAddress());
        }
        parameter.put("parameter", params);

        String serviceName = "transport.driver.msg.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson);

        return response.getStdData();
    }

    @Override
    public DigiwinEspStdData newDriverProcess(String iamUserToken, String tenantId, String locale, String transportNo, Object vehicleInfoId) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, Object> params = new HashMap<>(1);
        params.put("transport_no", transportNo);
        params.put("vehicle_info_id", vehicleInfoId);
        parameter.put("parameter", params);

        String serviceName = "new.driver.transport.transshipment.info.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson);

        return response.getStdData();
    }

    @Override
    public List<TransportList> getTaskTransportPositionInfo(String iamUserToken, String tenantId, String locale, String taskNo, Boolean isArrival) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, Object> params = new HashMap<>(2);
        params.put("task_no", taskNo);
        params.put("is_arrival", isArrival);
        parameter.put("parameter", params);
        parameter.put("use_has_next", false);

        String serviceName = "task.transport.position.info.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "transport_list");

        return ModuleUtils.listMapToListObject((List) response.getStdData().getParameter().get("transport_list"), TransportList.class);

    }

    @Override
    public List<Map<String, Object>> woOpReportCheckInInfo(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params) {
        String serviceProd = "APC";
        String serviceName = "wo.op.report.check.in.info.process";
        Map<String, String> headers = new HashMap<>(1);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("wo_op_report_data", params);

        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "wo_op_report_data");

        return (List<Map<String, Object>>) response.getStdData().getParameter().get("wo_op_report_data");
    }

    @Override
    public Boolean isDeptDirector(String iamUserToken, String tenantId, String locale, String eocCompanyId, String eocSiteId) {
        List<PersonnelDutyResp> list = personnelDutyGet(iamUserToken, tenantId, locale, eocCompanyId, eocSiteId);
        if (CollectionUtils.isEmpty(list)) {
            return Boolean.FALSE;
        }
        if ("director".equals(list.get(0).getDutyNo())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public Boolean isDeptDirector(List<PersonnelDutyResp> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Boolean.FALSE;
        }
        if ("director".equals(list.get(0).getDutyNo())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public List<PersonnelDutyResp> personnelDutyGet(String iamUserToken, String tenantId, String locale,
                                                    String eocCompanyId, String eocSiteId) {
        final String serviceProd = "APC";
        final String serviceName = "personnel.duty.get";
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        Map<String, String> digiEocmap = new HashMap<>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        digiEocmap.put("eoc_site_id", eocSiteId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        JSONObject parameter = new JSONObject();

        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "personnel_info");

        return ModuleUtils
                .listMapToListObject((List) response.getStdData().getParameter().get("personnel_info"), PersonnelDutyResp.class);
    }

    @Override
    public List<Map<String, Object>> currentTeamPersonnelInfoGet(String iamUserToken, String tenantId, String locale,
                                                                 String eocCompanyId, String eocSiteId) {
        final String serviceProd = "APC";
        final String serviceName = "current.team.personnel.info.get";
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        Map<String, String> digiEocmap = new HashMap<>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        digiEocmap.put("eoc_site_id", eocSiteId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        JSONObject parameter = new JSONObject();

        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "team_personnel_list");

        return (List<Map<String, Object>>) response.getStdData().getParameter().get("team_personnel_list");
    }

    @Override
    public List<Map<String, Object>> teamPersonnelInfoGet(String iamUserToken, String tenantId,
                                                          String locale, Map<String, Object> params,
                                                          Map<String, Object> headerParams) {
        final String serviceProd = "APC";
        final String serviceName = "current.team.personnel.info.get";
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(headerParams));

        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "team_personnel_list");

        return (List<Map<String, Object>>) response.getStdData().getParameter().get("team_personnel_list");
    }

    @Override
    public List<ZtbArea> getAreaList(String iamUserToken, String tenantId, String locale, String parentId) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        JSONObject parent = new JSONObject();
        parent.put("parent_id", parentId);
        parameter.put("parameter", parent);

        String serviceName = "area.list.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "areaList");

        return ModuleUtils.listMapToListObject(JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("areaList"), List.class), ZtbArea.class);
    }

    @Override
    public List<ZtbUserAddress> getuserAddressList(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "user.address.list.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "user_address_list");
        return ModuleUtils.listMapToListObject(JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("user_address_list"), List.class), ZtbUserAddress.class);
    }

    @Override
    public Boolean createUserAddress(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);

        String serviceName = "user.address.create";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.isRespOk();
    }

    @Override
    public Boolean deleteUserAddress(String iamUserToken, String tenantId, String locale, String addressId) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, String> params = new HashMap<>(1);
        params.put("address_id", addressId);
        parameter.put("parameter", params);

        String serviceName = "user.address.delete";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.isRespOk();
    }

    @Override
    public Boolean updateUserAddress(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);

        String serviceName = "user.address.update";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.isRespOk();
    }

    @Override
    public Map<String, Object> getUserAddress(String iamUserToken, String tenantId, String locale, String addressId) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, String> params = new HashMap<>(1);
        params.put("address_id", addressId);
        parameter.put("parameter", params);

        String serviceName = "user.address.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (response == null || response.getStdData() == null ||
                response.getStdData().getParameter() == null ||
                response.getStdData().getParameter().get("user_address") == null) {
            throw new ServiceException(localeService.getLanguageValue(locale, "暂未找到地址信息"));
        }
        return JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("user_address"), Map.class);
    }

    @Override
    public ZtbDeliveryLoadingCount getDeliveryLoadingCount(String iamUserToken, String tenantId, String locale, String taskNo) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, String> params = new HashMap<>(1);
        params.put("task_no", taskNo);
        parameter.put("parameter", params);

        String serviceName = "delivery.loading.count.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        return JsonUtil.objectToJavaObject(response.getStdData().getParameter(), ZtbDeliveryLoadingCount.class);
    }

    @Override
    public List<ZtbCargoUnloading> getDeliveryUnloadingList(String iamUserToken, String tenantId, String locale, String taskNo) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, String> params = new HashMap<>(1);
        params.put("task_no", taskNo);
        parameter.put("parameter", params);

        String serviceName = "delivery.unloading.list.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "cargo_unloading_list");

        return ModuleUtils.listMapToListObject(JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("cargo_unloading_list"), List.class), ZtbCargoUnloading.class);
    }

    @Override
    public List<ZTBDriverVehicle> getDeliveryLoadedCarList(String iamUserToken, String tenantId, String locale, String taskNo) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, String> params = new HashMap<>(1);
        params.put("task_no", taskNo);
        parameter.put("parameter", params);

        String serviceName = "delivery.loaded.car.list.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        if (response.getStdData().getParameter().get("transport_list") == null) {
            return Collections.emptyList();
        }
        return ModuleUtils.listMapToListObject(JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("transport_list"), List.class), ZTBDriverVehicle.class);
    }

    @Override
    public List<ZtbCargoUnloading> getDeliveryLoadedItemList(String iamUserToken, String tenantId, String locale, String transportNo) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, String> params = new HashMap<>(1);
        params.put("transport_no", transportNo);
        parameter.put("parameter", params);

        String serviceName = "delivery.loaded.item.list.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "transport_detail");

        return ModuleUtils.listMapToListObject(JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("transport_detail"), List.class), ZtbCargoUnloading.class);
    }

    @Override
    public Boolean driverRoleValid(String iamUserToken, String tenantId, String locale, String userId) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, String> params = new HashMap<>(1);
        params.put("user_id", userId);
        parameter.put("parameter", params);

        String serviceName = "driver.role.valid";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "is_driver");

        return JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("is_driver"), Boolean.class);
    }

    @Override
    public List<WoOpReportInfo> woOpReportPersonnelCheckedInInfoGet(String iamUserToken, String tenantId, String locale,
                                                                    String eocCompanyId, String eocSiteId) {
        final String serviceProd = "APC";
        final String serviceName = "wo.op.report.personnel.checked.in.info.get";
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        Map<String, String> digiEocmap = new HashMap<>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        digiEocmap.put("eoc_site_id", eocSiteId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        JSONObject parameter = new JSONObject();

        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "wo_op_report_info");

        List<WoOpReportInfo> woOpReportInfoList = ModuleUtils.listMapToListObject(
                (List) response.getStdData().getParameter().get("wo_op_report_info"), WoOpReportInfo.class);
        woOpReportInfoList.forEach(e -> e.setSupervisor(MapUtils.getBoolean(response.getStdData().getParameter(), "is_supervisor")));
        return woOpReportInfoList;
    }

    @Override
    public List<WoOpReportInfo> woOpReportPersonnelNotCheckInInfoGet(String iamUserToken, String tenantId, String locale,
                                                                     String eocCompanyId, String eocSiteId) {
        final String serviceProd = "APC";
        final String serviceName = "wo.op.report.personnel.not.check.in.info.get";
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        Map<String, String> digiEocmap = new HashMap<>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        digiEocmap.put("eoc_site_id", eocSiteId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        JSONObject parameter = new JSONObject();

        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "wo_op_report_info");

        return ModuleUtils.listMapToListObject(
                (List) response.getStdData().getParameter().get("wo_op_report_info"), WoOpReportInfo.class);
    }

    @Override
    public List<WoOpReportInfo> woOpReportPersonnelExceptInfoGet(String iamUserToken, String tenantId, String locale,
                                                                 String eocCompanyId, String eocSiteId) {
        final String serviceProd = "APC";
        final String serviceName = "wo.op.report.personnel.except.info.get";
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        Map<String, String> digiEocmap = new HashMap<>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        digiEocmap.put("eoc_site_id", eocSiteId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        JSONObject parameter = new JSONObject();

        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "wo_op_report_info");

        return ModuleUtils.listMapToListObject(
                (List) response.getStdData().getParameter().get("wo_op_report_info"), WoOpReportInfo.class);
    }

    @Override
    public List<WoOpReportInfo> requestSupportInfoGet(String iamUserToken, String tenantId, String locale,
                                                      String eocCompanyId, String eocSiteId) {
        final String serviceProd = "APC";
        final String serviceName = "request.support.info.get";
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        Map<String, String> digiEocmap = new HashMap<>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        digiEocmap.put("eoc_site_id", eocSiteId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        JSONObject parameter = new JSONObject();

        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        Optional<List> parameterOpt = Optional.ofNullable(response.getStdData())
                .map(DigiwinEspStdData::getParameter)
                .map(e -> (List) e.get("request_support"));
        if (!parameterOpt.isPresent()) {
            return Collections.emptyList();
        }

        return ModuleUtils.listMapToListObject(
                (List) parameterOpt.get(), WoOpReportInfo.class);
    }

    @Override
    public Map<String, Object> taskTransportVehicleCodeScan(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);

        String serviceName = "task.transport.vehicle.code.scan";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "transport_info");

        return JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("transport_info"), Map.class);
    }

    @Override
    public Map<String, Object> taskTransportOcrScan(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);

        String serviceName = "task.transport.ocr.scan";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        return JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("transport_info"), Map.class);
    }

    @Override
    public List<ZtbCargoUnloading> taskTransportBarcodeScan(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);

        String serviceName = "task.transport.barcode.scan";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson, "item_list");

        return ModuleUtils.listMapToListObject(JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("item_list"), List.class), ZtbCargoUnloading.class);
    }

    @Override
    public Map<String, Object> changeTaskTransportVehicle(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);

        String serviceName = "task.transport.vehicle.change";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.getStdData().getParameter();
    }

    @Override
    public Map<String, Object> submitTaskTransportLoading(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);

        String serviceName = "task.transport.loading.submit";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.getStdData().getParameter();
    }

    @Override
    public List<ZtbTransportReceiptStatusCount> getTransportReceiptStatusCount(String iamUserToken, String tenantId, String locale, String transportNo) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        Map<String, String> params = new HashMap<>(1);
        params.put("transport_no", transportNo);
        parameter.put("parameter", params);

        String serviceName = "transport.receipt.status.count.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return ModuleUtils.listMapToListObject((List<?>) response.getStdData().getParameter().get("receipt_status_list"), ZtbTransportReceiptStatusCount.class);
    }

    @Override
    public List<ZtbCargoUnloading> getTransportReceiptItemInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);

        String serviceName = "transport.receipt.item.info.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return ModuleUtils.listMapToListObject((List<?>) response.getStdData().getParameter().get("cargo_information"), ZtbCargoUnloading.class);
    }

    @Override
    public Boolean transportAbnormalAlarmProcess(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);

        String serviceName = "transport.abnormal.alarm.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.isRespOk();
    }

    @Override
    public Boolean deliveryStartManualSubmit(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);

        String serviceName = "delivery.start.manual.submit";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.isRespOk();
    }

    @Override
    public Boolean deliveryHeadInfoSubmit(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);

        String serviceName = "delivery.head.info.submit";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.isRespOk();
    }

    @Override
    public Boolean transportPaperReceiptSubmit(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);

        String serviceName = "transport.paper.receipt.submit";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.isRespOk();
    }

    @Override
    public String getSrmLoadingWebUrl(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);

        String serviceName = "srm.loading.web.url.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        if (responseModel == null) {
            return null;
        }
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return (String) response.getStdData().getParameter().get("web_url");
    }

    @Override
    public Map<String, Object> getDeliverySourceDetail(String iamUserToken, String tenantId, String locale, String sourceNo) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        Map<String, String> params = new HashMap<>(1);
        params.put("source_no", sourceNo);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);

        String serviceName = "delivery.source.detail.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.getStdData().getParameter();
    }

    @Override
    public Map<String, Object> validTransportArrival(String iamUserToken, String tenantId, String locale, String transport_no) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        Map<String, String> params = new HashMap<>(1);
        params.put("transport_no", transport_no);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);

        String serviceName = "transport.arrival.valid";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.getStdData().getParameter();
    }

    @Override
    public List<Map<String, Object>> getTransportReceive(String iamUserToken, String tenantId, String locale, String transport_no) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        Map<String, String> params = new HashMap<>(1);
        params.put("transport_no", transport_no);
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);

        String serviceName = "transport.receive.record.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("transport_receive_list");
    }

    @Override
    public Map<String, Object> scanTransportToReceive(String userId, String iamUserToken, String tenantId, String locale, String transport_no) {

        DigiwinIamUserInfo userInfo = iamProxyService.userInfoById(userId, iamUserToken, locale);
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        Map<String, String> params = new HashMap<>(1);
        params.put("transport_no", transport_no);
        if (ObjectUtil.isNotEmpty(userInfo)) {
            params.put("receiver_name", userInfo.getName());
            params.put("receiver_mobile", userInfo.getTelephone());
        }
        JSONObject parameter = new JSONObject();
        parameter.put("parameter", params);

        String serviceName = "receive.transport.scan";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return (Map<String, Object>) response.getStdData().getParameter().get("scan_result");
    }

    @Override
    public List<Map<String, Object>> getWoOpReportWaitProcessAbnormalInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "wo.op.report.wait.process.abnormal.info.get";
        String serviceProd = "APC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null ||
                response.getStdData().getParameter().get("wo_op_report_data") == null) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("wo_op_report_data");
    }

    @Override
    public List<Map<String, Object>> getCurrentTeamInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(params));

        String serviceName = "current.team.info.get";
        String serviceProd = "APC";
        String parameterBodyJson = "{}";
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null ||
                response.getStdData().getParameter().get("team_data") == null) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("team_data");
    }

    @Override
    public List<Map<String, Object>> getWoOpSupportDemandWindowsInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "wo.op.support.demand.windows.info.get";
        String serviceProd = "APC";
        Map<String, Object> body = new HashMap<>(1);
        List<Map<String, Object>> info = new ArrayList<>(1);
        info.add(params);
        body.put("wo_op_support_demand_windows_info", info);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null ||
                response.getStdData().getParameter().get("supporter_info") == null) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("supporter_info");
    }

    @Override
    public List<Map<String, Object>> getWoOpRequestSupportApproveInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "wo.op.request.support.approve.info.get";
        String serviceProd = "APC";
        Map<String, Object> body = new HashMap<>(1);
        List<Map<String, Object>> info = new ArrayList<>(1);
        info.add(params);
        body.put("wo_op_request_support_approve_info", info);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null ||
                response.getStdData().getParameter().get("approve_info") == null) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("approve_info");
    }

    @Override
    public List<Map<String, Object>> getInfoSupplierQuestion(String iamUserToken, String tenantId, String locale, String supplierSource) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "question.supplier.info.get";
        String serviceProd = "FRC";
        Map<String, Object> body = new HashMap<>(1);
        body.put("supplier_source", supplierSource);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null ||
                response.getStdData().getParameter().get("supplier_info") == null) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("supplier_info");
    }

    @Override
    public List<Map<String, Object>> getProjectInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "project.third.party.info.get";
        String serviceProd = "FRC";
        Map<String, Object> body = new HashMap<>(1);
        Map<String, Object> info = new HashMap<>(1);
        info.put("project_source", params.get("project_source"));
        info.put("project_status", "all");
        info.put("inquiry_data", params.get("inquiry_data"));

        String projectPersonnelRequired = params.get("projectPersonnelRequired").toString();
        //项目人员权限选择 Y:启用  N:不启用
        if ("Y".equals(projectPersonnelRequired)) {
            // 传值 展示当前登录用户执行或参与的项目; 不传 展示该租户下所有的项目
            info.put("liable_person_id", params.get("userId"));
            info.put("liable_person_name", params.get("userId"));
        }
        body.put("project_info", info);

        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null ||
                response.getStdData().getParameter().get("project_info") == null) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("project_info");
    }

    @Override
    public List<Map<String, Object>> getLayoutAreaWoOpInfo(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "layout.area.wo.op.info.get";
        String serviceProd = "APC";
        Map<String, Object> body = new HashMap<>(1);
        if (!CollectionUtils.isEmpty(params)) {
            Map<String, String> digiEocmap = new HashMap<>();
            digiEocmap.put("eoc_company_id", (String) params.get(0).get("eoc_company_id"));
            digiEocmap.put("eoc_site_id", (String) params.get(0).get("eoc_site_id"));
            headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        }
        body.put("report_area_info", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null ||
                response.getStdData().getParameter().get("machine_position_map_data") == null) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("machine_position_map_data");
    }

    @Override
    public Map<String, Object> getWoOpDispatchAreaSpaceDetailInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, Object> returnMap = new HashMap<>(2);
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "wo.op.dispatch.area.space.detail.info.get";
        String serviceProd = "APC";
        Map<String, Object> body = new HashMap<>(1);
        if (!CollectionUtils.isEmpty(params)) {
            Map<String, String> digiEocmap = new HashMap<>();
            digiEocmap.put("eoc_company_id", (String) params.get("eoc_company_id"));
            digiEocmap.put("eoc_site_id", (String) params.get("eoc_site_id"));
            headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        }
        List<Map<String, Object>> mapList = new ArrayList<>(1);
        params.remove("isAPC");
        params.remove("type");
        params.remove("onSiteResourcePlanningMechanism");
        mapList.add(params);
        body.put("query_condition", mapList);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null ||
                response.getStdData().getParameter().get("wo_op_data") == null) {
            return returnMap;
        }
        Map woOpData = JsonUtil.objectToJavaObject(response.getStdData().getParameter().get("wo_op_data"), Map.class);
        //已生效数据集合
        returnMap.put("eff_wo_op_data", woOpData.get("eff_wo_op_data"));
        //佔用比例
        returnMap.put("area_space_percentage", woOpData.get("area_space_percentage"));

        return returnMap;
    }

    @Override
    public List<Map<String, Object>> getDispatchAreaSpaceColorInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "wo.op.dispatch.area.space.color.info.get";
        String serviceProd = "APC";
        Map<String, Object> body = new HashMap<>(1);
        if (!CollectionUtils.isEmpty(params)) {
            Map<String, String> digiEocmap = new HashMap<>();
            digiEocmap.put("eoc_company_id", (String) params.get("eoc_company_id"));
            digiEocmap.put("eoc_site_id", (String) params.get("eoc_site_id"));
            headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        }
        List<Map<String, Object>> mapList = new ArrayList<>(1);
        mapList.add(params);
        body.put("query_condition", mapList);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            return Collections.emptyList();
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null ||
                response.getStdData().getParameter().get("wo_op_data") == null) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("wo_op_data");
    }

    @Override
    public List<Map<String, Object>> getDispatchOpWoDscBmInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "bm.dsc.wo.op.dispatch.get";
        String serviceProd = "BM-DSC";
        Map<String, Object> body = new HashMap<>(1);
        List<Map<String, Object>> mapList = new ArrayList<>(1);
        mapList.add(params);
        body.put("wo_op_dispatch_data", mapList);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            return Collections.emptyList();
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null ||
                response.getStdData().getParameter().get("wo_op_dispatch_data") == null) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("wo_op_dispatch_data");
    }

    @Override
    public List<Map<String, Object>> getWorkstationProgressFeedbackInfo(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "workstation.progress.feedback.info.get";
        String serviceProd = "APC";
        Map<String, Object> body = new HashMap<>(1);
        body.put("workstation_progress_feedback_info", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null ||
                response.getStdData().getParameter().get("workstation_progress_feedback_info") == null) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("workstation_progress_feedback_info");
    }

    @Override
    public List<Map<String, Object>> getWoOpOnlineReporterInfo(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "wo.op.online.reporter.info.get";
        String serviceProd = "APC";
        Map<String, Object> body = new HashMap<>(1);
        body.put("wo_op_report_data", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null ||
                response.getStdData().getParameter().get("wo_op_report_data") == null
        ) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("wo_op_report_data");
    }

    @Override
    public List<Map<String, Object>> returnWoOpReportAbnormalInfoClosecase(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        if (!CollectionUtils.isEmpty(params)) {
            Map<String, String> digiEocmap = new HashMap<>();
            digiEocmap.put("eoc_company_id", (String) params.get(0).get("eoc_company_id"));
            digiEocmap.put("eoc_site_id", (String) params.get(0).get("eoc_site_id"));
            headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        }

        String serviceName = "wo.op.report.abnormal.info.closecase.return";
        String serviceProd = "APC";
        Map<String, Object> body = new HashMap<>(1);
        body.put("wo_op_report_abnormal", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        List<Map<String, Object>> reportAbnormals = (List<Map<String, Object>>) response.getStdData().getParameter().get("wo_op_report_abnormal");
        return reportAbnormals;
    }

    @Override
    public Boolean processWoOpReportAbnormalInfoClosecase(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        if (!CollectionUtils.isEmpty(params)) {
            Map<String, String> digiEocmap = new HashMap<>();
            digiEocmap.put("eoc_company_id", (String) params.get(0).get("eoc_company_id"));
            digiEocmap.put("eoc_site_id", (String) params.get(0).get("eoc_site_id"));
            headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        }

        String serviceName = "wo.op.report.abnormal.info.closecase.process";
        String serviceProd = "APC";
        Map<String, Object> body = new HashMap<>(1);
        body.put("wo_op_report_abnormal", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.isRespOk();
    }

    @Override
    public List<Map<String, Object>> getEquipmentInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "equipment.info.get";
        String serviceProd = "FRC";
        Map<String, Object> body = new HashMap<>(1);
        body.put("equipment_info", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null ||
                response.getStdData().getParameter().get("equipment_info") == null) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("equipment_info");
    }

    @Override
    public List<Map<String, Object>> getProjectStageThirdPartyInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "project.stage.third.party.info.get";
        String serviceProd = "FRC";
        Map<String, Object> body = new HashMap<>(1);
        body.put("project_info", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null ||
                response.getStdData().getParameter().get("project_info") == null) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("project_info");
    }

    @Override
    public List<Map<String, Object>> getTransferQuantityInfo(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "wo.op.report.transfer.info.get";
        String serviceProd = "APC";
        Map<String, Object> map = new HashMap<>(1);
        map.put("wo_op_report_data", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(map);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null ||
                response.getStdData().getParameter().get("wo_op_report_data") == null) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("wo_op_report_data");
    }

    @Override
    public List<Map<String, Object>> getOpNextInfo(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "wo.op.next.op.get";
        String serviceProd = "APC";
        Map<String, Object> map = new HashMap<>(1);
        map.put("wo_op_data", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(map);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null ||
                response.getStdData().getParameter().get("wo_op_data") == null) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("wo_op_data");
    }

    @Override
    public List<Map<String, Object>> getWoOpReportQtyInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "wo.op.report.qty.info.get";
        String serviceProd = "APC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null ||
                response.getStdData().getParameter().get("wo_op_report_data") == null) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("wo_op_report_data");
    }

    @Override
    public boolean updateIssueNoticeInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "ca.cim.issue.notice.info.update";
        String serviceProd = "ca-cim-ap";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        Optional codeOptional = Optional.ofNullable(response.getStdData())
                .map(DigiwinEspStdData::getExecution)
                .map(DigiwinEspExecution::getCode);
        if (codeOptional.isPresent() && "0".equals(codeOptional.get())) {
            return true;
        }
        return false;
    }

    @Override
    public boolean updateOutSourceReportInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "ca.cim.outsourcing.report.info.update";
        String serviceProd = "ca-cim-ap";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        Optional codeOptional = Optional.ofNullable(response.getStdData())
                .map(DigiwinEspStdData::getExecution)
                .map(DigiwinEspExecution::getCode);
        if (codeOptional.isPresent() && "0".equals(codeOptional.get())) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean woOpDispatchDataProcess(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "wo.op.dispatch.data.process";
        String serviceProd = "APC";
        Map<String, List<Map<String, Object>>> bodys = new HashMap<>(1);
        bodys.put("wo_op_dispatch_data", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(bodys);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        Optional codeOptional = Optional.ofNullable(response.getStdData())
                .map(DigiwinEspStdData::getExecution)
                .map(DigiwinEspExecution::getCode);
        if (codeOptional.isPresent() && "0".equals(codeOptional.get())) {
            return true;
        }
        return false;
    }

    @Override
    public Map<String, Object> updateProcessInfoTransferReport(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params) {
        Map<String, Object> retrunMap = new HashMap<>(2);

        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "wo.op.report.transfer.info.process";
        String serviceProd = "APC";

        Map<String, Object> paramsMap = params.get(0);
        if (!ObjectUtils.isEmpty(paramsMap.get("eoc_company_id")) && !ObjectUtils.isEmpty(paramsMap.get("eoc_site_id"))) {
            Map<String, Object> eocMap = new HashMap<>();
            eocMap.put("eoc_company_id", paramsMap.get("eoc_company_id"));
            eocMap.put("eoc_site_id", paramsMap.get("eoc_site_id"));
            headers.put("digi-eocmap", JSONObject.toJSONString(eocMap));
        }

        Map<String, Object> map = new HashMap<>(1);
        map.put("wo_op_report_data", params);

        String parameterBodyJson = JsonUtil.javaObjectToJsonString(map);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        Optional<String> codeOptional = Optional.ofNullable(response.getStdData())
                .map(DigiwinEspStdData::getExecution)
                .map(DigiwinEspExecution::getCode);
        if (codeOptional.isPresent() && "0".equals(codeOptional.get())) {
            if (!ObjectUtil.isEmpty(response.getStdData().getParameter())) {
                if (ObjectUtils.isEmpty(response.getStdData().getParameter().get("error_msg"))) {
                    retrunMap.put("submit", true);
                    retrunMap.put("errorMsg", null);
                    retrunMap.put("data", response.getStdData().getParameter());
                    return retrunMap;
                } else {
                    //code = "0",但是error_msg有值，返回前端提示
                    retrunMap.put("submit", false);
                    retrunMap.put("errorMsg", response.getStdData().getParameter().get("error_msg"));
                    return retrunMap;
                }
            }
        }
        return retrunMap;
    }

    @Override
    public List<Map<String, Object>> getWoOpWorkstationRecommandTeamInfo(String iamUserToken,
                                                                         String tenantId, String locale,
                                                                         List<Map<String, Object>> params,
                                                                         Map<String, Object> headerParams) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(headerParams));

        String serviceName = "wo.op.workstation.recommand.team.info.get";
        String serviceProd = "APC";
        Map<String, Object> bodys = new HashMap<>(1);
        bodys.put("wo_op_info", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(bodys);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null ||
                response.getStdData().getParameter().get("work_team_personnel_info") == null) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("work_team_personnel_info");
    }

    @Override
    public List<Map<String, Object>> createTbdsTrialProductionReport(String iamUserToken, String tenantId, String locale,
                                                                     List<Map<String, Object>> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "bm.opsc.trial.production.report.create";
        String serviceProd = "BM-OPSC";
        Map<String, List<Map<String, Object>>> bodys = new HashMap<>(1);

        handleDocumentInfo(params);
        bodys.put("op_data", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(bodys);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        if (ObjectUtils.isEmpty(responseModel)) {
            LocaleService localeService = SpringContextHolder.getBean(LocaleService.class);
            throw new ServiceException(localeService.getLanguageValue(locale, "保存失败"));
        }
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        Optional codeOptional = Optional.ofNullable(response.getStdData())
                .map(DigiwinEspStdData::getExecution)
                .map(DigiwinEspExecution::getCode);
        if (codeOptional.isPresent() && "0".equals(codeOptional.get())
                && response.getStdData() != null && !CollectionUtils.isEmpty(response.getStdData().getParameter())) {
            return (List<Map<String, Object>>) response.getStdData().getParameter().get("op_data");

        }
        return Collections.emptyList();
    }

    @Override
    public Integer getTbdsTrialProductionComplete(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params, String opSeq) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "bm.opsc.trial.production.complete.get";
        String serviceProd = "BM-OPSC";
        Map<String, List<Map<String, Object>>> bodys = new HashMap<>(1);
        bodys.put("query_info", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(bodys);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        Optional codeOptional = Optional.ofNullable(response.getStdData())
                .map(DigiwinEspStdData::getExecution)
                .map(DigiwinEspExecution::getCode);
        if (codeOptional.isPresent() && "0".equals(codeOptional.get())
                && response.getStdData() != null && !CollectionUtils.isEmpty(response.getStdData().getParameter())) {
            List<Map<String, Object>> datas = (List<Map<String, Object>>) response.getStdData().getParameter().get("op_data");
            for (Map<String, Object> data : datas) {
                if (opSeq.equals(data.get("op_seq"))) {
                    return Integer.valueOf((String) data.get("is_associate_project"));
                }
            }
        }
        return 0;
    }

    @Override
    public List<Map<String, Object>> getTbdsTrialProductionCompleteList(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "bm.opsc.trial.production.complete.get";
        String serviceProd = "BM-OPSC";
        Map<String, List<Map<String, Object>>> bodys = new HashMap<>(1);
        bodys.put("query_info", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(bodys);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        Optional codeOptional = Optional.ofNullable(response.getStdData())
                .map(DigiwinEspStdData::getExecution)
                .map(DigiwinEspExecution::getCode);
        if (codeOptional.isPresent() && "0".equals(codeOptional.get())
                && response.getStdData() != null && !CollectionUtils.isEmpty(response.getStdData().getParameter())) {
            return (List<Map<String, Object>>) response.getStdData().getParameter().get("op_data");

        }
        return Collections.emptyList();
    }

    @Override
    public List<Map<String, Object>> getBmQmscTestPlanReportInfo(String iamUserToken, String tenantId, String locale, String joinInspectionNo) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "bm.qmsc.test.plan.report.info.get";
        String serviceProd = "BM-QMSC";
        Map<String, List<Map<String, Object>>> bodys = new HashMap<>(1);
        List<Map<String, Object>> body = new ArrayList<>(1);
        Map<String, Object> testReportInfo = new HashMap<>(1);
        testReportInfo.put("inspection_no", joinInspectionNo);
        body.add(testReportInfo);
        bodys.put("test_report_info", body);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(bodys);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        Optional codeOptional = Optional.ofNullable(response.getStdData())
                .map(DigiwinEspStdData::getExecution)
                .map(DigiwinEspExecution::getCode);
        if (codeOptional.isPresent() && "0".equals(codeOptional.get())
                && response.getStdData() != null && !CollectionUtils.isEmpty(response.getStdData().getParameter())) {
            return (List<Map<String, Object>>) response.getStdData().getParameter().get("test_report_info");

        }
        return Collections.emptyList();
    }

    @Override
    public List<Map<String, Object>> getBmOpscEarliestStartDateTrialWoProcess(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> trialWoProcessList) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "bm.opsc.earliest.start.date.trial.wo.process.get";
        String serviceProd = "BM-OPSC";
        Map<String, List<Map<String, Object>>> bodys = new HashMap<>(1);
        bodys.put("trial_wo_process", trialWoProcessList);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(bodys);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        Optional codeOptional = Optional.ofNullable(response.getStdData())
                .map(DigiwinEspStdData::getExecution)
                .map(DigiwinEspExecution::getCode);
        if (codeOptional.isPresent() && "0".equals(codeOptional.get())
                && response.getStdData() != null && !CollectionUtils.isEmpty(response.getStdData().getParameter())) {
            return (List<Map<String, Object>>) response.getStdData().getParameter().get("trial_wo_process");

        }
        return Collections.emptyList();
    }

    @Override
    public List<Map<String, Object>> getBmOpscTrialWoProcess(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> trialWoProcessList) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "bm.opsc.trial.wo.process.get";
        String serviceProd = "BM-OPSC";
        Map<String, List<Map<String, Object>>> bodys = new HashMap<>(1);
        bodys.put("trial_wo_process", trialWoProcessList);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(bodys);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        Optional codeOptional = Optional.ofNullable(response.getStdData())
                .map(DigiwinEspStdData::getExecution)
                .map(DigiwinEspExecution::getCode);
        if (codeOptional.isPresent() && "0".equals(codeOptional.get())
                && response.getStdData() != null && !CollectionUtils.isEmpty(response.getStdData().getParameter())) {
            return (List<Map<String, Object>>) response.getStdData().getParameter().get("trial_wo_process");

        }
        return Collections.emptyList();
    }

    @Override
    public List<Map<String, Object>> getBmMoscTrialWo(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> trialWoList) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "bm.mosc.trial.wo.get";
        String serviceProd = "BM-MOSC";
        Map<String, List<Map<String, Object>>> bodys = new HashMap<>(1);
        bodys.put("trial_wo", trialWoList);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(bodys);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        Optional codeOptional = Optional.ofNullable(response.getStdData())
                .map(DigiwinEspStdData::getExecution)
                .map(DigiwinEspExecution::getCode);
        if (codeOptional.isPresent() && "0".equals(codeOptional.get())
                && response.getStdData() != null && !CollectionUtils.isEmpty(response.getStdData().getParameter())) {
            return (List<Map<String, Object>>) response.getStdData().getParameter().get("trial_wo");

        }
        return Collections.emptyList();
    }

    @Override
    public List<Map<String, Object>> getBmUscMeasureUnitList(String iamUserToken, String tenantId, String locale) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "bm.usc.measure.unit.list.get";
        String serviceProd = "BM-USC";
        Map<String, List<Map<String, Object>>> bodys = new HashMap<>(1);
        List<Map<String, Object>> body = new ArrayList<>(1);
        Map<String, Object> manageStatus = new HashMap<>(1);
        manageStatus.put("manage_status", "Y");
        body.add(manageStatus);
        bodys.put("query_condition", body);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(bodys);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        Optional codeOptional = Optional.ofNullable(response.getStdData())
                .map(DigiwinEspStdData::getExecution)
                .map(DigiwinEspExecution::getCode);
        if (codeOptional.isPresent() && "0".equals(codeOptional.get())
                && response.getStdData() != null && !CollectionUtils.isEmpty(response.getStdData().getParameter())) {
            return (List<Map<String, Object>>) response.getStdData().getParameter().get("measure_unit_info");

        }
        return Collections.emptyList();
    }

    @Override
    public void saveDriverPosition(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        params.put("detail_address", params.get("detailAddress"));
        params.put("complete_address", params.get("completeAddress"));
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }

        String serviceName = "transport.driver.position.process";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        this.isRespOk(response, serviceProd, serviceName, parameterBodyJson);
    }

    @Override
    public List<Map<String, Object>> getTransportDriverMsg(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        JSONObject parameter = new JSONObject();
        if (params != null && params.size() > 0) {
            parameter.put("parameter", params);
        }

        String serviceName = "transport.driver.msg.get";
        String serviceProd = "srm-loading";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(parameter);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);

        // 判断应用API的响应资料是否ok
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("msg_list");
    }

    /**
     * 判断应用API的响应资料是否ok
     * 如果不OK，抛出ServiceException
     *
     * @param response          应用API接口响应
     * @param serviceProd       服务产品
     * @param serviceName       服务名称
     * @param parameterBodyJson 请求参数
     * @param serviceFields     应用API业务字段参数列表
     */
    private void isRespOk(DigiwinEspResponse response, String serviceProd, String serviceName,
                          String parameterBodyJson, String... serviceFields) {
        if (response == null) {
            throw new ServiceException("Service " + serviceName + " call returned NONE Response!");
        }
        // 这块判断目前只在APC应用下使用，其它应用暂未使用此字段判断
        if (response.isRespOk("error_msg")) {
            String message = (String) response.getStdData().getParameter().get("error_msg");
            if (StringUtils.hasLength(message)) {
                throw new ServiceException(message);
            } else {
                throw new ServiceException("error_msg is empty, please check log of Service " + serviceName);
            }
        }

        if (serviceFields.length == 0) {
            if (!response.isRespOk()) {
                throw new ServiceException(response
                        .getResponseFullDescriptionMsgWhenNotOK(serviceProd, serviceName, parameterBodyJson));
            }
            return;
        }
        boolean isRespOk = true;
        for (String field : serviceFields) {
            if (!(isRespOk = response.isRespOk(field))) {
                break;
            }
        }
        if (!isRespOk) {
            throw new ServiceException(response
                    .getResponseFullDescriptionMsgWhenNotOK(serviceProd, serviceName, parameterBodyJson));
        }
    }

    @Override
    public List<Map<String, Object>> getAacrArdateInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(1);
        headers.put("digi-token", iamUserToken);

        String serviceName = "aacr.ardata.get";
        String serviceProd = "A20230410171317-bq3200";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null ||
                response.getStdData().getParameter().get("ar_data") == null) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("ar_data");
    }

    @Override
    public List<Map<String, Object>> createAacrAppArProgress(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(1);
        headers.put("digi-token", iamUserToken);

        String serviceName = "aacr.app.arprogress.create";
        String serviceProd = "A20230410171317-bq3200";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null ||
                response.getStdData().getParameter().get("ar_progress") == null) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("ar_progress");
    }

    private void handleDocumentInfo(List<Map<String, Object>> params) {
        if (!CollectionUtils.isEmpty(params)) {
            params.forEach(item -> {
                List<Map<String, Object>> documentInfoList = (List<Map<String, Object>>) MapUtil.getOrDefault(item, "document_info", Collections.emptyList());
                if (CollectionUtils.isEmpty(documentInfoList)) {
                    Map<String, Object> documentInfoMap = new HashMap<>();
                    documentInfoMap.put("project_no", item.get("project_no"));
                    documentInfoMap.put("eoc_company_id", item.get("eoc_company_id"));
                    documentInfoMap.put("eoc_site_id", item.get("eoc_site_id"));
                    documentInfoMap.put("trial_wo_no", item.get("trial_wo_no"));
                    documentInfoMap.put("op_seq", item.get("op_seq"));
                    documentInfoMap.put("op_no", item.get("op_no"));

                    Map<String, Object> attachmentMap = new HashMap<>();
                    attachmentMap.put("data", Collections.emptyList());
                    attachmentMap.put("rowData", "");
                    documentInfoMap.put("attachment", attachmentMap);
                    documentInfoMap.put("document_type", "2");

                    item.put("document_info", Collections.singletonList(documentInfoMap));
                }
            });
        }
    }

    @Override
    public List<Map<String, Object>> bmDpscWorkingDayPlan(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "bm.dpsc.working.day.plan.get";
        String serviceProd = "BM-DPSC";
        Map<String, Object> body = new HashMap<>(1);
        List<Map<String, Object>> mapList = new ArrayList<>(1);
        mapList.add(params);
        body.put("day_plan_data", mapList);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            return Collections.emptyList();
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null ||
                response.getStdData().getParameter().get("day_plan_data") == null) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("day_plan_data");
    }

    @Override
    public List<Map<String, Object>> getApcWorkingDayPlanDispatchInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "apc.working.day.plan.dispatch.info.get";
        String serviceProd = "APC";
        Map<String, Object> body = new HashMap<>(1);
        List<Map<String, Object>> mapList = new ArrayList<>(1);
        mapList.add(params);
        body.put("apc_day_plan_data", mapList);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            return Collections.emptyList();
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null ||
                response.getStdData().getParameter().get("apc_day_plan_data") == null) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("apc_day_plan_data");
    }

    @Override
    public void updateTaskWarnInvImsc(String iamUserToken, String tenantId, String locale, List<Map<String, Object>> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "bmd.imsc.inv.warn.task.update";
        String serviceProd = "BMD-IMSC-001";
        Map<String, Object> body = new HashMap<>(1);
        body.put("safety_inventory_warn_info", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException("");
        }
    }

    @Override
    public Map<String, Object> getWoOpMergeReportWorkHoursInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);

        String serviceName = "wo.op.merge.report.work.hours.info.get";
        String serviceProd = "APC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.getStdData().getParameter();
    }

    @Override
    public Map<String, Object> getWoOpReportWorkHoursInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "wo.op.report.work.hours.info.get";
        String serviceProd = "APC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.getStdData().getParameter();
    }

    @Override
    public Map<String, Object> getBmWrscWoOpReportWorkHours(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "bm.wrsc.wo.op.report.work.hours.get";
        String serviceProd = "BM-WRSC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.getStdData().getParameter();
    }

    @Override
    public Map<String, Object> getQuestionEocDeptUserInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "question.eoc.dept.user.info.get";
        String serviceProd = "FRC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.getStdData().getParameter();
    }

    @Override
    public List<Map<String, Object>> getTaskReportRecordInfo(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(1);
        headers.put("digi-token", iamUserToken);
        String serviceName = "task.report.record.info.get";
        String serviceProd = "PCC";
        Map<String, Object> body = new HashMap<>(1);
        body.put("query_condition", Collections.singletonList(params));
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null ||
                response.getStdData().getParameter().get("report_info") == null) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("report_info");
    }

    @Override
    public Map<String, Object> getWoOpReportWorkHoursHistoryInfoGet(String iamUserToken, String tenantId, String locale, Map<String, Object> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "wo.op.report.work.hours.history.info.get";
        String serviceProd = "APC";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(params);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        return response.getStdData().getParameter();
    }

    @Override
    public List<Map<String, Object>> getDispatchReportInfo(String iamUserToken, String tenantId, String locale, String eocCompanyId, List<Map<String, Object>> params) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "dispatch.report.info.get";
        String serviceProd = "APC";
        Map<String, Object> body = new HashMap<>(1);
        Map<String, String> digiEocmap = new HashMap<>();
        digiEocmap.put("eoc_company_id", eocCompanyId);
        headers.put("digi-eocmap", JsonUtil.javaObjectToJsonString(digiEocmap));
        body.put("query_condition", params);
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(body);
        ResponseModel responseModel = invokeRestSync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            throw new ServiceException(response.getStdDataExecutionDescription());
        }
        if (response.getStdData() == null || response.getStdData().getParameter() == null ||
                response.getStdData().getParameter().get("query_data") == null) {
            return Collections.emptyList();
        }
        return (List<Map<String, Object>>) response.getStdData().getParameter().get("query_data");
    }

    @Override
    public Map<String, Object> getExportAbiUrlFasync(String iamUserToken, String tenantId, String locale, AbiReportAsyncExport export) {
        Map<String, String> headers = new HashMap<>(2);
        headers.put("digi-token", iamUserToken);
        String serviceName = "abi.rpt.export";
        String serviceProd = "ABI";
        String parameterBodyJson = JsonUtil.javaObjectToJsonString(export);
        ResponseModel responseModel = invokeRestFasync(tenantId, locale, serviceProd,
                serviceName, headers, parameterBodyJson);
        DigiwinEspResponse response = JsonUtil.jsonStringToObject(responseModel.getBodyJsonString(),
                DigiwinEspResponse.class);
        if (!response.isRespOk()) {
            return responseModel.getHeaders();
        }
        return response.getStdData().getParameter();
    }
}

