package com.digiwin.mobile.mobileuibot.proxy.experience.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.exception.ServiceException;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.config.request.mock.OuterMockData;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.experience.service.DigiwinExperienceProxyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinExperienceProxyServiceImpl
 * @Author: Zaregoto
 * @Date: 2021/6/29 21:06
 */
@Service
public class DigiwinExperienceProxyServiceImpl implements DigiwinExperienceProxyService {

    @Autowired
    private HttpService httpService;

    @Override
    public void reportMockData(OuterMockData outerMockData) {
        // mock 数据，只存储在测试区，故写死测试区域名
        String domain = AppContext.getApiUrlSetting().getExperienceUrl();
//        String domain = "https://experience-test.apps.digiwincloud.com.cn";
        String url = domain + DigiwinExperienceProxyService.API_PREFIX
                + "/mock/reportMockData";

        ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<JSONObject>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(),
                        JsonUtil.javaObjectToJsonString(outerMockData), responseType);

        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            throw new ServiceException(responseEntity.getBody().getErrorMessage());
        }
    }

    @Override
    public String gainMockDataOne(OuterMockData outerMockData) {
        // mock 数据，只存储在测试区，故写死测试区域名
        String domain = AppContext.getApiUrlSetting().getExperienceUrl();
//        String domain = "https://experience-test.apps.digiwincloud.com.cn";
        String url = domain + DigiwinExperienceProxyService.API_PREFIX
                + "/mock/gainMockDataOne";

        ParameterizedTypeReference<DigiwinAthenaApiResponse<String>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<String>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<String>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(),
                        JsonUtil.javaObjectToJsonString(outerMockData), responseType);

        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            throw new ServiceException(responseEntity.getBody().getErrorMessage());
        }
        return responseEntity.getBody().getResponse();
    }

    @Override
    public void deleteMockData(OuterMockData outerMockData) {
        // mock 数据，只存储在测试区，故写死测试区域名
        String domain = AppContext.getApiUrlSetting().getExperienceUrl();
//        String domain = "https://experience-test.apps.digiwincloud.com.cn";
        String url = domain + DigiwinExperienceProxyService.API_PREFIX
                + "/mock/deleteMockData";

        ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<JSONObject>>() {
                };

        ResponseEntity<DigiwinAthenaApiResponse<JSONObject>> responseEntity =
                this.httpService.doPost(url, new AthenaBasicHttpRequestHead(),
                        JsonUtil.javaObjectToJsonString(outerMockData), responseType);

        if (!responseEntity.getStatusCode().is2xxSuccessful()) {
            throw new ServiceException(responseEntity.getBody().getErrorMessage());
        }
    }
}
