package com.digiwin.mobile.mobileuibot.proxy.fileparsing;

import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataFileParsingPptQueryDTO;
import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataFileParsingPptUpdateDTO;

/**
 * <p>功能描述：敏捷问数FileParsing服务调用类</p>
 *
 * @author yanfeng
 * @date 2025/08/26
 */
public interface AgileDataFileParsingProxyService {

    String API_PREFIX = "/fileparsing/";

    /**
     * 敏捷数据：查询我的ppt列表
     */
    DigiwinAgileDataFileParsingResponse getPptFileList(AgileDataFileParsingPptQueryDTO queryDTO);

    /**
     * 敏捷数据：修改ppt文件名
     */
    DigiwinAgileDataFileParsingResponse updatePptFileName(AgileDataFileParsingPptQueryDTO queryDTO);

    /**
     * 敏捷数据：删除ppt文件
     */
    DigiwinAgileDataFileParsingResponse deletePptFile(AgileDataFileParsingPptQueryDTO queryDTO);

    /**
     * 敏捷数据：上传ppt文件
     * @param queryDTO
     * @return
     */
    DigiwinAgileDataFileParsingResponse uploadPptFile(AgileDataFileParsingPptUpdateDTO queryDTO);

    /**
     * 敏捷数据：获取pdf的dmc分享链接
     */
    DigiwinAgileDataFileParsingResponse getPDFDmcShareUrl(AgileDataFileParsingPptQueryDTO queryDTO);

}