package com.digiwin.mobile.mobileuibot.proxy.fileparsing.dto;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class AgileDataFileParsingPptResultDTO implements Serializable {

    /**
     * adq主键，用于查新,修改，删除等
     */
    private String pptId;
    /**
     * PPT的名称，同文档中心的文件名称
     */
    private String pptName;
    /**
     * PPT 文档 ID，同文档中心的文件ID
     */
    private String pptDocId;
    /**
     * PPT 类型   template 模板，create 生成的
     */
    private String pptType;
    /**
     * 是否默认 PPT
     */
    private Boolean defaultPpt;
    private String tenantId;
    private String userId;
    /**
     * 文档中心分享的url，可以直接下载
     */
    private String pptUrl;

    /**
     * 文档中心预览的url，可以直接预览
     */
    private String pptPreviewUrl;
    /**
     * PPT的过期时间(文档中心)
     */
    private String expireDate;
    /**
     * PPT的创建时间(文档中心)
     */
    private String createDate;
    /**
     * PPT是否被删除(文档中心)
     */
    private String deleteFile;
    /**
     * PPT页数
     */
    private String pptPageSize;

    private String dataType;
}