package com.digiwin.mobile.mobileuibot.proxy.fileparsing.impl;

import com.digiwin.mobile.mobileuibot.agileData.constant.AgileDataConstant;
import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataFileParsingPptQueryDTO;
import com.digiwin.mobile.mobileuibot.agileData.dto.AgileDataFileParsingPptUpdateDTO;
import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.common.log.TraceIdUtil;
import com.digiwin.mobile.mobileuibot.proxy.fileparsing.AgileDataFileParsingProxyService;
import com.digiwin.mobile.mobileuibot.proxy.fileparsing.DigiwinAgileDataFileParsingResponse;
import com.digiwin.mobile.mobileuibot.proxy.fileparsing.dto.AgileDataFileParsingPptListResultDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @date 2025/8/26
 * @author yanfeng
 */
@Slf4j
@Service("agileDataFileParsingProxyService")
public class AgileDataFileParsingProxyServiceImpl implements AgileDataFileParsingProxyService {

    @Autowired
    private HttpService httpService;

    @Override
    public DigiwinAgileDataFileParsingResponse getPptFileList(AgileDataFileParsingPptQueryDTO queryDTO) {
        String url = AppContext.getApiUrlSetting().getAgileDataFileParsingUrl() + AgileDataFileParsingProxyService.API_PREFIX
                + "listFile";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAgileDataFileParsingResponse<AgileDataFileParsingPptListResultDTO>> responseType =
                new ParameterizedTypeReference<DigiwinAgileDataFileParsingResponse<AgileDataFileParsingPptListResultDTO>>() {
                };
        ResponseEntity<DigiwinAgileDataFileParsingResponse<AgileDataFileParsingPptListResultDTO>> responseEntity;
        String body = JsonUtil.javaObjectToJsonString(queryDTO);
        try {
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(AgileDataConstant.CLIENT_AGENT, queryDTO.getLocale(),
                    queryDTO.getToken(), queryDTO.getTenantId()), body, responseType);
            log.info("获取getPptFileList接口调用返回, url:{} " +
                            "\n request:{} " +
                            "\n response:{}" +
                            "\n traceId:{}",
                    url,
                    body,
                    JsonUtil.javaObjectToJsonString(responseEntity),
                    TraceIdUtil.get());
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                return null;
            }
            if (null != responseEntity.getBody()) {
                return responseEntity.getBody();
            }
        } catch (Exception e) {
            log.error("获取getPptFileList接口调用失败, url:{} \n request:{}, \n error:{},\n traceId:{}", url, body, e.getMessage(), TraceIdUtil.get());
        }
        return null;
    }

    @Override
    public DigiwinAgileDataFileParsingResponse updatePptFileName(AgileDataFileParsingPptQueryDTO queryDTO) {
        String url = AppContext.getApiUrlSetting().getAgileDataFileParsingUrl() + AgileDataFileParsingProxyService.API_PREFIX
                + "modifyFile";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAgileDataFileParsingResponse<Object>> responseType =
                new ParameterizedTypeReference<DigiwinAgileDataFileParsingResponse<Object>>() {
                };
        ResponseEntity<DigiwinAgileDataFileParsingResponse<Object>> responseEntity;
        String body = JsonUtil.javaObjectToJsonString(queryDTO);
        try {
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(AgileDataConstant.CLIENT_AGENT, queryDTO.getLocale(),
                    queryDTO.getToken(), queryDTO.getTenantId()), body, responseType);
            log.info("updatePptFileName接口调用返回, url:{} " +
                            "\n request:{} " +
                            "\n response:{}" +
                            "\n traceId:{}",
                    url,
                    body,
                    JsonUtil.javaObjectToJsonString(responseEntity),
                    TraceIdUtil.get());
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                return null;
            }
            if (null != responseEntity.getBody()) {
                return responseEntity.getBody();
            }
        } catch (Exception e) {
            log.error("updatePptFileName接口调用失败, url:{} \n request:{}, \n error:{},\n traceId:{}", url, body, e.getMessage(), TraceIdUtil.get());
        }
        return null;
    }

    @Override
    public DigiwinAgileDataFileParsingResponse deletePptFile(AgileDataFileParsingPptQueryDTO queryDTO) {
        String url = AppContext.getApiUrlSetting().getAgileDataFileParsingUrl() + AgileDataFileParsingProxyService.API_PREFIX
                + "deleteFile";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAgileDataFileParsingResponse<Object>> responseType =
                new ParameterizedTypeReference<DigiwinAgileDataFileParsingResponse<Object>>() {
                };
        ResponseEntity<DigiwinAgileDataFileParsingResponse<Object>> responseEntity;
        String body = JsonUtil.javaObjectToJsonString(queryDTO);
        try {
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(AgileDataConstant.CLIENT_AGENT, queryDTO.getLocale(),
                    queryDTO.getToken(), queryDTO.getTenantId()), body, responseType);
            log.info("deletePptFile接口调用返回, url:{} " +
                            "\n request:{} " +
                            "\n response:{}" +
                            "\n traceId:{}",
                    url,
                    body,
                    JsonUtil.javaObjectToJsonString(responseEntity),
                    TraceIdUtil.get());
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                return null;
            }
            if (null != responseEntity.getBody()) {
                return responseEntity.getBody();
            }
        } catch (Exception e) {
            log.error("deletePptFile接口调用失败, url:{} \n request:{}, \n error:{},\n traceId:{}", url, body, e.getMessage(), TraceIdUtil.get());
        }
        return null;
    }

    @Override
    public DigiwinAgileDataFileParsingResponse uploadPptFile(AgileDataFileParsingPptUpdateDTO queryDTO) {
        String url = AppContext.getApiUrlSetting().getAgileDataFileParsingUrl() + AgileDataFileParsingProxyService.API_PREFIX
                + "uploadFile";
        Map<String, Object> map = new HashMap<>();
        map.put("userId", queryDTO.getUserId());
        map.put("tenantId", queryDTO.getTenantId());
        ResponseEntity<DigiwinAgileDataFileParsingResponse> responseEntity;
        try {
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(AgileDataConstant.CLIENT_AGENT, queryDTO.getLocale(),
                    queryDTO.getToken(), queryDTO.getTenantId()), queryDTO.getFile(), map, DigiwinAgileDataFileParsingResponse.class);
            log.info("uploadPptFile接口调用返回, url:{} " +
                            "\n response:{}" +
                            "\n traceId:{}",
                    url,
                    JsonUtil.javaObjectToJsonString(responseEntity),
                    TraceIdUtil.get());
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                return null;
            }
            if (null != responseEntity.getBody()) {
                return responseEntity.getBody();
            }
        } catch (Exception e) {
            log.error("uploadPptFile接口调用失败, url:{}, \n error:{},\n traceId:{}", url, e.getMessage(), TraceIdUtil.get());
        }
        return null;
    }

    @Override
    public DigiwinAgileDataFileParsingResponse getPDFDmcShareUrl(AgileDataFileParsingPptQueryDTO queryDTO) {
        String url = AppContext.getApiUrlSetting().getAgileDataFileParsingUrl() + AgileDataFileParsingProxyService.API_PREFIX
                + "getPDFDmcShareUrl";

        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAgileDataFileParsingResponse<String>> responseType =
                new ParameterizedTypeReference<DigiwinAgileDataFileParsingResponse<String>>() {
                };
        ResponseEntity<DigiwinAgileDataFileParsingResponse<String>> responseEntity;
        String body = JsonUtil.javaObjectToJsonString(queryDTO);
        try {
            responseEntity = this.httpService.doPost(url, new AthenaBasicHttpRequestHead(AgileDataConstant.CLIENT_AGENT, queryDTO.getLocale(),
                    queryDTO.getToken(), queryDTO.getTenantId()), body, responseType);
            log.info("getPDFDmcShareUrl接口调用返回, url:{} " +
                            "\n request:{} " +
                            "\n response:{}" +
                            "\n traceId:{}",
                    url,
                    body,
                    JsonUtil.javaObjectToJsonString(responseEntity),
                    TraceIdUtil.get());
            if (!responseEntity.getStatusCode().is2xxSuccessful()) {
                return null;
            }
            if (null != responseEntity.getBody()) {
                return responseEntity.getBody();
            }
        } catch (Exception e) {
            log.error("getPDFDmcShareUrl接口调用失败, url:{} \n request:{}, \n error:{},\n traceId:{}", url, body, e.getMessage(), TraceIdUtil.get());
        }
        return null;
    }
}