package com.digiwin.mobile.mobileuibot.proxy.iam.model;

import com.alibaba.fastjson.JSONObject;
import lombok.Data;

import java.io.Serializable;

/**
 * <p>功能描述：鼎捷云IAM基础类</p>
 *
 * @FileName: DigiwinIamErrorResponse
 * @Author: zaregoto
 * @Date: 2024/4/10 16:21
 */
@Data
public class DigiwinIamBaseResponse implements Serializable {
    private static final long serialVersionUID = -336807606758105941L;

    /**
     * 错误响应示例：
     * {
     * "timestamp": "2024-04-10 16:11:13",
     * "code": 500,
     * "message": "The user [xxx] in tenant [xxx] has disabled",
     * "path": "/api/iam/v2/identity/token/refresh/tenant",
     * "success": false,
     * "sourceId": "IAM",
     * "errorType": "Business",
     * "errorCode": "20000",
     * "errorMessage": "The user [xxx] in tenant [xxx] has disabled",
     * "expId": "f5827a6c448e42cea26d1928d99c0330",
     * "errorInstructors": {}
     * }
     */
    protected String timestamp;
    protected Integer code;
    protected String message;
    protected String path;
    protected Boolean success;
    protected String errorType;
    protected String errorCode;
    protected String errorMessage;
    protected String expId;
    protected JSONObject errorInstructors;

}