package com.digiwin.mobile.mobileuibot.proxy.iam.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * 用户信息
 *
 * @author wuyang
 * @date 20220121
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class DigiwinIamUserInfo extends DigiwinIamBaseResponse {
    private static final long serialVersionUID = -8919117702044643460L;
    /**
     * 用户sid
     */
    private Long sid;
    /**
     * 创建时间
     */
    private String createDate;
    /**
     * 创建提供者
     */
    private Long createProvider;
    private Long createOrg;
    /**
     * 修改人sid
     */
    private Long modifyBy;
    /**
     * 修改时间
     */
    private String modifyDate;
    /**
     * 修改提供者
     */
    private Long modifyProvider;
    private String hash;
    /**
     * 是否可用
     */
    private Boolean disabled;
    /**
     * 是否删除
     */
    private Boolean deleted;
    /**
     * 用户id
     */
    private String id;
    /**
     * 账号别名
     */
    private String name;
    /**
     * 座机
     */
    private String phone;
    /**
     * 手机
     */
    private String telephone;
    /**
     * 邮箱
     */
    private String email;
    /**
     * 头像路径
     */
    private String headImageUrl;
    /**
     * 性别
     */
    private String sex;
    /**
     * 生日
     */
    private String birthday;
    /**
     * 电话前缀
     */
    private String cellphonePrefix;
    /**
     * 地址
     */
    private String address;
    /**
     * 是否激活
     */
    private Boolean activated;
    /**
     * 是否为企业用户
     */
    private Boolean enterprise;
    /**
     * 所属的用户的默认租户
     */
    private Long defaultTenantSid;
    /**
     * 是否认证
     */
    private Boolean confirm;
    /**
     * 是否可见
     */
    private Boolean visible;
    /**
     * 是否只读
     */
    private Boolean readonly;
    /**
     * 直属主管
     */
    private Long chargeSid;
    /**
     * 用户类型用户类型（0.鼎捷云用户 1.企业用户 ）
     */
    private int type;
    /**
     * 密码是否变更
     */
    private Boolean changed;
    private Boolean agreeAgreement;
    /**
     * 权限到期日
     */
    private String dueDate;
    private String remark;
    /**
     * 当为企业用户是，这个参数会有值（目前暂时塞入"企业用户"）
     */
    private String enterpriseName;
    /**
     * 返回accId
     */
    private String accId;
    /**
     * 用户token
     */
    private String token;
    /**
     * token过期时间
     */
    private Long tokenExpiresIn;
    /**
     * token类型
     */
    private String tokenType;
    /**
     * 用户Id
     */
    private String userId;
    /**
     * 用户姓名
     */
    private String userName;

    // 创建人sid
    private Long createBy;
    private String modifyById;
    private String nickname;
    private String comeFrom;
    // 是否开启认证
    private Boolean doubleCheck;
    // 邮箱验证(email)/手机号验证(mobile)
    private String identityCodeAcceptType;
    private String pwDate;
    private Boolean devAgreementSigned;
    private String purpose;
    private List<UserMapping> userMappings;

    @Data
    public static
    class UserMapping {
        private Long tenantSid;
        private String tenantId;
        private Long userSid;
        private String userId;
        private String providerId;
        private String verifyUserId;
    }
}
