package com.digiwin.mobile.mobileuibot.proxy.iam.service;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.DigiwhaleLoginResponse;
import com.digiwin.mobile.mobileuibot.proxy.digiwhale.model.PasswordChange;
import com.digiwin.mobile.mobileuibot.proxy.iam.model.*;
import com.digiwin.mobile.mobileuibot.sso.dto.ThirdPartyLoginFreeQueryDTO;
import org.springframework.http.ResponseEntity;

import javax.servlet.http.HttpServletRequest;
import java.util.List;
import java.util.Map;

/**
 * <p>功能描述：鼎捷IAM系统代理服务</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: DigiwinIamProxyService
 * @Author: Zaregoto
 * @Date: 2021/4/20 14:26
 */
public interface DigiwinIamProxyService {

    String API_PREFIX = "/api/iam/v2";
    String ATHENA_APP_ID = "Athena";

    String LOGIN_INTERNAL_USERNAME = "integration";

    String LOGIN_INTERNAL_PASSWORD = "6826CC688C4AF1BD0A8DDA2DBDF8897B";

    List<DigiwinIamTenant> listUserTenantsInAthena(String userToken);

    /**
     * 切换租户，重新刷新UserToken
     *
     * @param tenantId  租户id
     * @param tenantSid 租户sid （租户id与租户sid必传一个）
     * @param userToken 当前用户token
     * @return
     */
    DigiwinIamTokenRefreshTenant tokenRefreshTenant(String tenantId, String tenantSid, String userToken);

    DigiwinIamAnalyzedToken tokenAnalyze(String userToken);

    /**
     * 检查token是否过期
     *
     * @param userToken
     * @return
     */
    int tokenAnalyzeByCheck(String userToken);

    Integer logout(String userToken);

    /**
     * 通过用户的userID列表获取用户信息
     *
     * @param userIds
     * @return
     */
    List<DigiwinIamUserInfo> userList(List<String> userIds, String userToken, String locale);

    /**
     * 通过用户的user列表获取用户信息
     *
     * @param userId
     * @param userToken
     * @param locale
     * @return
     */
    DigiwinIamUserInfo userInfoById(String userId, String userToken, String locale);

    /**
     * 判断当前手机号是否注册过
     *
     * @param telephone
     * @param locale
     * @return
     */
    Boolean mobileIsRegister(String telephone, String locale);

    /**
     * 使用手机号或邮箱注册用户
     *
     * @param telephone
     * @param verificationCode
     * @param locale
     * @return
     * @Link <a href="https://doc.apipost.net/docs/2d9c2f897864000">...</a>
     */
    ResponseEntity<DigiwhaleLoginResponse> userRegisterByMobileOrEmail(String telephone, String verificationCode, String locale, String clientAgent);

    /**
     * 验证码登录
     *
     * @param username
     * @param password
     * @param locale
     * @return
     */
    ResponseEntity<DigiwhaleLoginResponse> userLoginByVerificationCode(String username, String password, String locale, String iamDeviceId, String clientAgent);

    /**
     * 普通账号登录(鼎捷云账号)
     *
     * @param username
     * @param password
     * @param locale
     * @param tenantId
     * @param clientAgent
     * @return
     */
    ResponseEntity<DigiwhaleLoginResponse> userLoginByEncodePassword(String publicKey, String username, String password,
                                                                     String locale, String tenantId, String clientAgent, HttpServletRequest request, String iamDeviceId);

    /**
     * 企业用户账号登录
     *
     * @param username
     * @param password
     * @param locale
     * @param tenantId
     * @param clientAgent 类型：String  必有字段  备注：客户端加密公钥
     * @return ResponseEntity<DigiwhaleLoginResponse>
     * @author yanfeng
     */
    ResponseEntity<DigiwhaleLoginResponse> firmAccountLogin(String publicKey, String username, String password,
                                                            String locale, String tenantId, String clientAgent, HttpServletRequest request, String iamDeviceId);

    /**
     * AD登录
     *
     * @param clientEncryptPublicKey
     * @param username
     * @param password
     * @param locale
     * @param tenantId
     * @param clientAgent
     * @return
     */
    ResponseEntity<DigiwhaleLoginResponse> userLoginByAD(String username, String clientEncryptPublicKey,
                                                         String password, String locale, String tenantId, String clientAgent, HttpServletRequest request, String iamDeviceId);

    /**
     * 代理模式登录，获取代理用户清单
     * 代理模式登录,代理人支持手机/邮箱/id+密码登录，并且输入被代理的租户授权码
     *
     * @param username               代理人的账号/邮箱/手机号
     * @param clientEncryptPublicKey 经过后端公钥加密后的前端公钥
     * @param password               加密密码
     * @param locale                 语言别
     * @param agentAuthorizationCode 代理授权码
     * @param clientAgent            设备
     * @return
     */
    ResponseEntity<DigiwhaleLoginResponse> userLoginGetProxyUsers(String username, String clientEncryptPublicKey,
                                                                  String password, String locale, String agentAuthorizationCode,
                                                                  String clientAgent);

    /**
     * 代理模式登录，根据代理token以及代理用户信息登录
     *
     * @param username    被代理用户id,请使用AES加密
     * @param agentToken  代理用户token
     * @param locale      语言别
     * @param clientAgent 设备
     * @return
     */
    ResponseEntity<DigiwhaleLoginResponse> userLoginByProxy(String username, String agentToken,
                                                            String locale, String clientAgent, String iamDeviceId);

    /**
     * 刷卡登录
     *
     * @param username
     * @param clientEncryptPublicKey
     * @param locale
     * @param tenantId
     * @param clientAgent
     * @return
     */
    ResponseEntity<DigiwhaleLoginResponse> userLoginByCard(String username, String clientEncryptPublicKey,
                                                           String locale, String tenantId, String clientAgent, String loginType, String iamDeviceId);

    /**
     * 获取新版互联的publicKey
     *
     * @return
     */
    String doGetPublicKey();

    /**
     * 获取新版互联获取加密后的aes的key值
     *
     * @param clientEncryptPublicKey
     * @return
     */
    String doGetAesKey(String clientEncryptPublicKey);

    /**
     * 获取三方应用授权码
     *
     * @param userToken
     * @param appId
     * @param callbackUrl
     * @return
     * @link <a href="http://172.16.2.141:22694/html/web/controller/share/share.html#6441feeeeae133071b1a7a91">...</a>
     */
    String getAuthorizeCode(String userToken, String appId, String callbackUrl);

    /**
     * 检查用户密码是否需要修改密码
     *
     * @param locale
     * @param userToken
     * @return
     */
    PasswordChange checkUserPasswordChange(String locale, String userToken);

    /**
     * 鼎捷云账号/企业用户都用此接口
     * 更新用戶密碼
     * http://172.16.2.141:22694/html/web/controller/share/share.html#6441feefeae133071b1a7b82
     *
     * @param iamUserToken
     * @param parameters
     * @return
     */
    Boolean updatePassword(String iamUserToken, Map<String, Object> parameters);

    /**
     * 展延變更密碼週期
     *
     * @param iamUserToken
     * @return
     */
    Boolean renewalPassword(String iamUserToken);

    /**
     * 判断是否是超级管理员
     *
     * @param userToken
     * @param userId
     * @return
     */
    Boolean isSuperAdmin(String userToken, String userId);

    /**
     * 获取当前用户在当前租户下角色信息
     *
     * @param userToken
     * @param userId
     * @return
     */
    DigiwinIamUserRoleInfo userRole(String userToken, String userId);

    /**
     * 取得用户功能权限
     *
     * @param userToken
     * @param params
     * @return
     */
    DigiwinIamUserAuthInfo getUserPermissionFunctional(String userToken, Map<String, Object> params);

    /**
     * 用户进行解绑已经绑定的三方信息
     *
     * @param userToken
     * @param userId
     * @return
     */
    JSONObject deleteBundle(String userId, String userToken, String unionId);

    /**
     * 绑定用户微信UUID/line userId信息
     *
     * @param
     * @param
     */
    JSONObject importThirdplatform(String comeFrom, String unionId, String iamId, String userToken, String tenantId);


    /**
     * 第三方免登入获取token
     *
     * @param queryDTO
     * @return
     */
    DigiwhaleLoginResponse identityOauthTokenGrantAccess(ThirdPartyLoginFreeQueryDTO queryDTO);

    /**
     * 企微一期使用
     * 临时token置换userToken
     *
     * @param tempToken
     * @param tenantId
     * @param userId
     * @param appId     固定传：athena
     * @return
     */
    String identityTokenTempAccess(String tempToken, String tenantId, String userId, String appId);

    /**
     * 根据企微code获取鼎捷用户信息
     * 企微2期使用
     *
     * @param code     必有字段 授权码
     * @param tenantId 必有字段  租户id
     * @param type     必有字段 类型， weCom/huawei(企微/华为)
     * @param appId    可有字段  备注：企微agentId，没有值则默认取第一个代开发应用
     * @return DigiwhaleLoginResponse
     * @author yanfeng
     * @link <a href="http://172.16.2.141:22694/html/web/controller/share/share.html#65edb9ff694cee1857e043de">...</a>
     */
    DigiwhaleLoginResponse identityOauthTokenAccess(String code, String tenantId, String type, String appId);

    /**
     * 根据当前租户获取应用
     * expired = false 为有效；
     * expired = true  为失效；
     *
     * @param iamUserToken
     * @return
     */
    List<String> queryUserAppCodes(String iamUserToken);


    /**
     * 用户元数据设置语言
     *
     * @param userToken
     * @param userSid
     * @param locale
     */
    void userMetadataUserLanguage(String userToken, String userSid, String locale);

    /**
     * 获取用户元数据设置语言
     *
     * @param userToken
     * @param userSid
     * @param userID
     */
    ResponseEntity<Object> getUserMetadataUserLanguage(String userToken, String userSid, String userID);

    /**
     * 赋予用户角色
     *
     * @param iamUserToken
     * @param roleId       角色Id
     * @param userIds      用户Id数组
     */
    Boolean associationRoleAddUsers(String iamUserToken, String roleId, List<String> userIds);

    /**
     * 将当前用户加入到目标租户下并自动授权应用
     *
     * @param iamUserToken  当前用户的token（一般是刚注册的）
     * @param tenantId      可选字段：租户id
     * @param tenantSid     可选字段：租户sid（租户id与租户sid必传一个）
     * @param appId         可选字段：应用id
     * @param tenantVisible 可选字段：租户是否可见，不传默认IAM以true来处理
     * @return
     */
    DigiwinIamUserAddJoinTenant userAddJoinTenant(String iamUserToken, String tenantId, String tenantSid, String appId, String tenantVisible);

    /**
     * 检查用户是否已加入过任意租户
     *
     * @param user         账号：可以是用户id、邮箱、电话
     * @param iamUserToken 用户已登录的token
     * @return
     */
    Boolean checkUserInTenant(String user, String iamUserToken);

    /**
     * 为当前用户添加预设租户
     *
     * @param iamUserToken 当前用户的token
     * @param tenantId     预设租户id。预设租户id和sid不能同时为空
     * @param tenantSid    预设租户sid
     * @return
     */
    Boolean setUserDefaultTenant(String iamUserToken, String tenantId, String tenantSid);

    /**
     * 为当前用户设置默认语系
     *
     * @param iamUserToken 当前用户的token
     * @param tenantSid    租户sid。非必要字段，区分租户时，传入租户sid；不区分租户时，传入0
     * @param locale       语言别
     * @param userSid      用户sid
     * @return
     */
    Boolean setUserDefaultAcceptLanguage(String iamUserToken, Long tenantSid, Long userSid, String locale);

    /**
     * 内部应用跳转移动端使用
     * 根据免登授权码获取用户身份凭据
     *
     * @param authCode    必有字段  备注：免登授权码
     * @param sourceAppId 必有字段  备注：来源应用id
     * @return DigiwhaleLoginResponse
     * @author yanfeng
     * @link <a href="http://172.16.2.141:22694/html/web/controller/share/share.html#65e92ef6694cee1857e043d5">...</a>
     */
    DigiwinIamAuthoredUser authCodeSubstitutionAccessToken(String authCode, String sourceAppId);

    /**
     * 生成第三方应用免登授权码
     *
     * @param iamUserToken 必有字段  备注：用户token
     * @param sourceAppId  必有字段  备注：来源应用id
     * @return DigiwhaleLoginResponse
     * @author yanfeng
     * @link <a href="http://172.16.2.141:22694/html/web/controller/share/share.html#65e92837694cee1857e043d3">...</a>
     */
    String getAuthCode(String iamUserToken, String sourceAppId);

    /**
     * 记录用户登录失败次数及是否冻结
     *
     * @param userId
     * @return
     */
    JSONObject loginFailure(String userId);

    /**
     * 获取校验图
     *
     * @param userId
     * @return
     */
    JSONObject getImage(String userId);

    String getIamDeviceId(String deviceId, String deviceType);

    /**
     * 获取用户基本信息
     *
     * @param iamUserToken
     * @param userId
     * @return
     */
    JSONObject getUserInfo(String iamUserToken, String userId);

    /**
     * 三方帐号解绑
     *
     * @param iamUserToken
     * @param params
     * @return
     */
    DigiwinIamResult deleteUserMapping(String iamUserToken, Map<String, Object> params);

    /**
     * 根据邮箱获取用户信息
     *
     * @param iamUserToken
     * @param params
     * @return
     */
    DigiwinIamResult getUserInfoByEmail(String iamUserToken, Map<String, String> params);

    /**
     * 加入租户并授权应用
     *
     * @param iamUserToken
     * @param params
     * @Line <a href="https://docs.apipost.net/docs/detail/4a933d4180ca000?locale=zh-cn&target_id=4fd9866">...</a>
     * @return
     */
    DigiwinIamResult userAddJoinTenantCustom(String iamUserToken, Map<String, String> params);

    /**
     * 往iam注册用户
     *
     * @param iamUserToken
     * @param params
     * @return
     */
    ResponseEntity<JSONObject> registerIamUser(String iamUserToken, Map<String, Object> params);

    /**
     * 集成帐号登录（用于内部跨租户查询信息）
     *
     * @param tenantId
     * @return
     */
    ResponseEntity<DigiwhaleLoginResponse> loginInternal(String tenantId);


    /**
     * 查询line对于雅典娜账号的全局映射
     *
     * @param iamUserToken
     * @param params
     * @return
     */
    JSONObject queryGlobalLine(String iamUserToken, Map<String, String> params);

    /**
     * 查询当前租户信息
     *
     * @param iamUserToken
     * @return
     */
    DigiwinIamTenant currentTenant(String iamUserToken);

    /**
     * 查询用户信息
     *
     * @param iamUserToken 登录用户token
     * @param userId       用户id
     * @return 用户信息
     */
    DigiwinIamUserInfo queryUserInfo(String iamUserToken, String userId);

    /**
     * 更新用户双重验证状态
     *
     * @param iamUserToken 登录用户token
     * @param params       参数
     * @return 成功返回true，失败返回false
     */
    Boolean doubleCheckUpdate(String iamUserToken, Map<String, Object> params);

    /**
     * 邮箱是否存在检查
     *
     * @param iamUserToken 用户token
     * @param account 邮箱
     * @return 结果
     */
    DigiwinIamAccountRegisterResponse emailExistCheck(String iamUserToken, String account);

    /**
     * 手机号是否存在检查
     *
     * @param iamUserToken 用户token
     * @param account 手机号
     * @return 结果
     */
    DigiwinIamAccountRegisterResponse mobilephoneExistCheck(String iamUserToken, String account);

    /**
     * 忘记/修改密码（不需要旧密码）
     *
     * @param iamUserToken 用户token
     * @param params       参数
     */
    Boolean passwordUpdate(String iamUserToken, Map<String, Object> params);
}