package com.digiwin.mobile.mobileuibot.proxy.im.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * @author wuyang
 * IM的群聊类
 * @date 2022-01-17
 */
@AllArgsConstructor
@NoArgsConstructor
@Data
public class IMTeam implements Serializable {

    private static final long serialVersionUID = 849596440166791719L;
    /**
     * 群名称
     */
    private String teamName;
    /**
     * 群主
     */
    private String owner;
    /**
     * 群类型（1-项目群，2-任务群）
     */
    private Integer type;
    /**
     * 群标识（对应云信的t_id）
     */
    private String bizId;
    /**
     * 父级群
     */
    private String pId;
    /**
     * 是否是主群
     */
    private Integer ifMaster;
    /**
     * 是否可见（0-不可见，1-可见）
     */
    private Integer visible;
    /**
     * 群来源（字符串，自己定义）
     */
    private String source;
    /**
     * 群成员
     */
    private List<String> memberIds = new ArrayList<>();
    /**
     * 业务数据id
     */
    private String businessKey;
    /**
     * 群组名称
     */
    private String bizName;
    /**
     * 外部租户eoc成员列表
     */
    private List<String> externalEocMembers = new ArrayList<>();
    /**
     * 外部账户列表
     */
    private List<String> externalAccounts = new ArrayList<>();
}
