package com.digiwin.mobile.mobileuibot.proxy.im.model;

import java.util.Objects;

/**
 * <p>功能描述：</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @FileName: IMTeamTypeEnum
 * @Author: Zaregoto
 * @Date: 2022/6/8 17:59
 */
public enum IMTeamTypeEnum {
    /**
     * Athena逻辑与定义：项目类型的群
     */
    PROJECT_TYPE(1),

    /**
     * Athena逻辑与定义：任务类型的群
     */
    TASK_TYPE(2),
    ;

    private final Integer value;

    IMTeamTypeEnum(Integer value) {
        this.value = value;
    }

    public Integer getValue() {
        return value;
    }

    public static IMTeamTypeEnum getEnumByValue(Integer value) {
        for (IMTeamTypeEnum testedEnum : IMTeamTypeEnum.values()) {
            if (Objects.equals(testedEnum.getValue(), value)) {
                return testedEnum;
            }
        }
        return null;
    }
}
