package com.digiwin.mobile.mobileuibot.proxy.im.model;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * 云信用户信息
 *
 * @author zhangjj
 * @date 2021/9/9 0009 15:30
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class IMUser implements Serializable {
    private static final long serialVersionUID = 6155443460173289090L;

    /**
     * 云信账号
     */
    private String accid;

    /**
     * 云信token(相当于密码)
     */
    private String token;
    private Long athenaTenantId;
    private String eocId;
    private String tenantName;
    private Integer type;
    private String uniqueId;
    private String userName;

    /**
     * IM原厂的环境名
     * 云信使用,agora不使用
     */
    private String envName;

    /**
     * IM原厂的智能助理账号id
     * 此字段废弃，前端不使用
     */
    private String aiAssistantAccId;


    /**
     * 先写死,后期会根据不同的环境或者包名来给对应的type
     * 1:云信 2:agora
     */
    private String imType;

    public static IMUser createEmpty() {
        return new IMUser();
    }
}