package com.digiwin.mobile.mobileuibot.proxy.im.service;

import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.im.model.IMTeam;
import com.digiwin.mobile.mobileuibot.proxy.im.model.IMUser;
import com.digiwin.mobile.mobileuibot.proxy.im.model.TeamMember;

import java.util.List;

/**
 * <p>功能描述：鼎捷IM服务代理</p>
 * <p>Copyright(c) Digiwin Mobile Technology Co., LTD </p>
 *
 * @author zhangjj
 * @date 2021/9/9 0009 15:26
 */
public interface DigiwinImProxyService {

    /**
     * 用户登录与创建云信账户
     *
     * @param iamUserToken
     * @return
     */
    IMUser userLoginAndCreate(String iamUserToken, String tenantId);

    /**
     * 用户登录与创建云信账户
     *
     * @param iamUserToken
     * @return
     */
    IMUser userGetAndCreate(String iamUserToken, String tenantId, String eocId);

    /**
     * 创建项目/任务关联群聊
     *
     * @param iamUserToken
     * @param imTeam
     * @return
     */
    DigiwinAthenaApiResponse<String> teamCreate(String iamUserToken, IMTeam imTeam, String tenantId);

    /**
     * 获取群聊下内部成员列表
     *
     * @param teamId
     * @param iamUserToken
     * @return
     */
    List<TeamMember> getTeamMembers(String iamUserToken, String teamId, String tenantId);

    /**
     * 群聊加人
     *
     * @param iamUserToken
     * @param teamId
     * @param memberIds
     * @param bizId
     * @param type
     * @return
     */
    DigiwinAthenaApiResponse<String> teamAddMembers(String iamUserToken, String teamId, List<String> memberIds, String bizId, Integer type, String tenantId);

    /**
     * 获取当前租户下所有人员
     *
     * @param iamUserToken
     * @param tenantId
     * @return
     */
    List<TeamMember> getAllMembers(String iamUserToken, String tenantId);

    /**
     * 获取云信账号
     *
     * @param eocId
     * @param iamUserToken
     * @return
     */
    String getAccIdByEocId(String eocId, String iamUserToken);
}
