package com.digiwin.mobile.mobileuibot.proxy.im.service.impl;

import com.digiwin.mobile.mobileuibot.common.context.AppContext;
import com.digiwin.mobile.mobileuibot.common.http.HttpService;
import com.digiwin.mobile.mobileuibot.common.http.model.AthenaBasicHttpRequestHead;
import com.digiwin.mobile.mobileuibot.common.json.JsonUtil;
import com.digiwin.mobile.mobileuibot.proxy.DigiwinAthenaApiResponse;
import com.digiwin.mobile.mobileuibot.proxy.im.model.IMTeam;
import com.digiwin.mobile.mobileuibot.proxy.im.model.IMUser;
import com.digiwin.mobile.mobileuibot.proxy.im.model.TeamMember;
import com.digiwin.mobile.mobileuibot.proxy.im.service.DigiwinImProxyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

import java.util.*;

/**
 * @author zhangjj
 * @date 2021/9/9 0009 15:32
 */
@Service
public class DigiwinImProxyServiceImpl implements DigiwinImProxyService {

    @Autowired
    private HttpService httpService;

    @Override
    public IMUser userLoginAndCreate(String iamUserToken, String tenantId) {
        try {
            String url = AppContext.getApiUrlSetting().getImUrl() + "/user/loginAndCreate";
            // 使用ParameterizedTypeReference对返回带泛型参数的包装
            ParameterizedTypeReference<DigiwinAthenaApiResponse<IMUser>> responseType =
                    new ParameterizedTypeReference<DigiwinAthenaApiResponse<IMUser>>() {
                    };
            ResponseEntity<DigiwinAthenaApiResponse<IMUser>> responseEntity =
                    httpService.doPost(url, new AthenaBasicHttpRequestHead("", "", iamUserToken, tenantId), new HashMap<>(), responseType);

            HttpStatus statusCode = responseEntity.getStatusCode();

            return statusCode.is2xxSuccessful()
                    && Optional.ofNullable(responseEntity).map(HttpEntity::getBody)
                    .map(DigiwinAthenaApiResponse::getStatus).orElse(-1) == HttpStatus.OK.value()
                    ? responseEntity.getBody().getResponse() : IMUser.createEmpty();
        } catch (Exception e) {
            return new IMUser();
        }
    }

    @Override
    public IMUser userGetAndCreate(String iamUserToken, String tenantId, String eocId) {
        String url = AppContext.getApiUrlSetting().getImUrl() + "/user/getAndCreate";
        Map<String, Object> bodyPayLoad = new HashMap<>(4);
        if (StringUtils.hasLength(eocId)) {
            bodyPayLoad.put("eocId", eocId);
        }
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<IMUser>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<IMUser>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<IMUser>> responseEntity =
                httpService.doPost(url, new AthenaBasicHttpRequestHead("", "", iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(bodyPayLoad), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful()
                && Optional.ofNullable(responseEntity).map(HttpEntity::getBody)
                .map(DigiwinAthenaApiResponse::getStatus).orElse(-1) == HttpStatus.OK.value()
                ? responseEntity.getBody().getResponse() : IMUser.createEmpty();
    }

    @Override
    public DigiwinAthenaApiResponse<String> teamCreate(String iamUserToken, IMTeam imTeam, String tenantId) {
        String url = AppContext.getApiUrlSetting().getImUrl() + "/team/create";
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<String>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<String>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<String>> responseEntity =
                httpService.doPost(url, new AthenaBasicHttpRequestHead("", "", iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(imTeam), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ? responseEntity.getBody() : null;
    }

    @Override
    public List<TeamMember> getTeamMembers(String iamUserToken, String teamId, String tenantId) {
        String url = AppContext.getApiUrlSetting().getImUrl() + "/team/getTeamMembers/" + teamId;
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<TeamMember>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<TeamMember>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<TeamMember>>> responseEntity =
                httpService.doGet(url, new AthenaBasicHttpRequestHead("", "", iamUserToken, tenantId), new HashMap<>(1), responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful()
                && Optional.ofNullable(responseEntity).map(HttpEntity::getBody)
                .map(DigiwinAthenaApiResponse::getStatus).orElse(-1) == HttpStatus.OK.value()
                ? responseEntity.getBody().getResponse() : Collections.emptyList();
    }

    @Override
    public DigiwinAthenaApiResponse<String> teamAddMembers(String iamUserToken, String teamId, List<String> memberIds, String bizId, Integer type, String tenantId) {
        Map<String, Object> bodyPayLoad = new HashMap<>(4);
        bodyPayLoad.put("tId", teamId);
        bodyPayLoad.put("type", type);
        bodyPayLoad.put("memberIds", memberIds);
        bodyPayLoad.put("bizId", bizId);

        String url = AppContext.getApiUrlSetting().getImUrl() + "/team/addMembers";
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<String>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<String>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<String>> responseEntity =
                httpService.doPost(url, new AthenaBasicHttpRequestHead("", "", iamUserToken, tenantId), JsonUtil.javaObjectToJsonString(bodyPayLoad), responseType);

        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful() ? responseEntity.getBody() : null;
    }

    @Override
    public List<TeamMember> getAllMembers(String iamUserToken, String tenantId) {
        String url = AppContext.getApiUrlSetting().getImUrl() + "/user/getUsers";
        // 使用ParameterizedTypeReference对返回带泛型参数的包装
        ParameterizedTypeReference<DigiwinAthenaApiResponse<List<TeamMember>>> responseType =
                new ParameterizedTypeReference<DigiwinAthenaApiResponse<List<TeamMember>>>() {
                };
        ResponseEntity<DigiwinAthenaApiResponse<List<TeamMember>>> responseEntity =
                httpService.doGet(url, new AthenaBasicHttpRequestHead("", "", iamUserToken, tenantId), new HashMap<>(1), responseType);
        HttpStatus statusCode = responseEntity.getStatusCode();

        return statusCode.is2xxSuccessful()
                && Optional.ofNullable(responseEntity).map(HttpEntity::getBody)
                .map(DigiwinAthenaApiResponse::getStatus).orElse(-1) == HttpStatus.OK.value()
                ? responseEntity.getBody().getResponse() : Collections.emptyList();
    }

    @Override
    public String getAccIdByEocId(String eocId, String iamUserToken) {
        String accId = "";
        //查询对应的云信账号
        String imUrl = AppContext.getApiUrlSetting().getImUrl() + "/user/getUserInfo/" + eocId;
        ResponseEntity<Map> imResponseEntity =
                httpService.doGet(imUrl, new AthenaBasicHttpRequestHead(iamUserToken), new HashMap<>(), Map.class);
        Map<String, Object> imResponseMap = imResponseEntity.getBody();
        if (imResponseMap.get("response") != null) {
            Map imInfo = (Map) imResponseMap.get("response");
            accId = (String) imInfo.get("accid");
        }
        return accId;
    }
}